#!/bin/bash
# Copyright 2013, 2015, 2016, 2017, 2018 Cumulus Networks, Inc.  All rights reserved.

# Track how many times we've tried.  Give up after 5 attempts
# by touching the file.
cntfile=/run/cumulus-aclcheck.cnt
typeset -i cnt
if [ ! -s $cntfile ]; then echo 0 > $cntfile ; fi

if [ ! -e /run/cache/cumulus/acltool/installed ]; then
	read cnt < $cntfile
	(( cnt++ ))
	echo $cnt > $cntfile
	/usr/sbin/service acltool restart &> /dev/null
	res=$?
	if [ $res -ne 0 ]; then
	        if [ $cnt -gt 5 ]; then
			echo "Giving up on aclcheck after $cnt attempts" 1>&2
			systemctl stop cumulus-aclcheck.timer
		fi
	
		echo "Acls not installed, CPU unprotected (see /run/cache/cumulus/acltool/error for errors)" 1>&2
		exit 1
	else
		echo "Acls reinstalled" 1>&2
		rm -f $cntfile
		systemctl stop cumulus-aclcheck.timer
		exit 0
	fi
fi
exit 0
