#!/usr/bin/env python
# Copyright 2018-2020 Cumulus Networks, Inc.
#
# mroute-check helper for underlay multicast (special) mroutes

# TODO:
#
# Use switchd's sfs node along with ASIC SDK commands to validate for now.
# Move to SDK commands when SDK supports all relevant commands(generic ones
# and not memory dumps).

import os
import subprocess

DEBUG_TOGGLE = '/cumulus/switchd/ctrl/debug'
VXLAN_INFO = '/cumulus/switchd/debug/vxlan/info'

class Ul_mcast:
    def __init__(self, debug):
        self.desc = "Underlay Multicast VXLAN Tunnels"
        self.debug = debug

        # check and enable switchd debug for sfs node to appear
        self.switchd_debug_enabled = self.get_switchd_debug(self)
        if not self.switchd_debug_enabled:
            self.enable_switchd_debug(self)
	self.disable_switchd_vxlan_hw_dump(self)

    def __str__(self):
        return 'Ul-mcast special mroutes helper\n'

    def __del__(self):
        # restore switchd debug
        if not self.switchd_debug_enabled:
            self.disable_switchd_debug(self)
	self.restore_switchd_vxlan_hw_dump(self)

    @staticmethod
    def get_switchd_debug(self):
        return os.path.isfile(VXLAN_INFO)

    @staticmethod
    def enable_switchd_debug(self):
        os.system('echo 1 > /cumulus/switchd/ctrl/debug')
        return

    @staticmethod
    def disable_switchd_debug(self):
        os.system('echo 1 > /cumulus/switchd/ctrl/debug')
        return

    @staticmethod
    def disable_switchd_vxlan_hw_dump(self):
        # TODO: Get the cached value from vxlan_hw_dump and restore it
        os.system('echo FALSE > /cumulus/switchd/ctrl/vxlan_hw_dump')
        return

    @staticmethod
    def restore_switchd_vxlan_hw_dump(self):
        os.system('echo TRUE > /cumulus/switchd/ctrl/vxlan_hw_dump')
        return

    def check_orig_mroute(self, asic, source, group):

        # check tunnel initiator and terminator
        #
        # tunnels:
        # ========
        # init_id: 0x4c000001; term_id: 0x4c000004; sip: 27.0.0.7; dip: 239.1.1.101
        # init_id: 0x4c000000; term_id: 0x4c000003; sip: 27.0.0.8; dip: 27.0.0.7
        # init_id: 0x4c000002; term_id: 0x4c000005; sip: 27.0.0.7; dip: 239.1.1.100

        if self.debug:
            print "(%s,%s) orig-mroute validation" % (source, group)
        proc = subprocess.Popen(['grep', 'term_id', VXLAN_INFO], stdout=subprocess.PIPE)
        out = proc.communicate()[0]
        lines = out.splitlines()

        orig_mroute_present = False
        for l in lines:
            if 'term_id' in l:
                init_id = l.split()[1][0:-1]
                sip = l.split()[5][0:-1]
                dip = l.split()[7]

            if source in sip and group in dip and init_id != "0x0":
                orig_mroute_present = True
                break

        if not orig_mroute_present:
            return orig_mroute_present
        if self.debug:
            print "(%s,%s) vxlan tunnel initiator present" % (source, group)

        # check l3 egress object associated with the tunnel
        #
        # gports:
        # =======
        # gport: 0x80000004; vpn: (28673/0x7001); eg_if: 100007; f: 0x80984 class_id: 2
        #   match_tun: 0xffffffff; egress_tun: 0x4c000002
        # gport: 0x80000003; vpn: (28673/0x7001); eg_if: 100006; f: 0x80984 class_id: 2
        #   match_tun: 0xffffffff; egress_tun: 0x4c000001

        match_str = 'egress_tun: ' + str(init_id)
        proc = subprocess.Popen(['grep', '-B1', match_str, VXLAN_INFO], stdout=subprocess.PIPE)
        out = proc.communicate()[0]
        lines = out.splitlines()

        orig_mroute_present = False
        octets = group.split('.')
        mcast_mac = '01:00:5e:'
        second_oct = int(octets[1]) & 127
        third_oct = int(octets[2])
        fourth_oct = int(octets[3])
        mcast_mac = mcast_mac + format(second_oct, '02x') + ':'
        mcast_mac = mcast_mac + format(third_oct, '02x') + ':' + format(fourth_oct, '02x')

        for l in lines:
            if 'gport' in l:
                egress_if = l.split()[5][0:-1]
                mcast_flag = l.split()[7]
                if int(mcast_flag,16) & 0x80984 == 0x80984:
                    mac, l3_ipmc = asic.get_l3_egress(egress_if)
                    if mcast_mac in mac and l3_ipmc == 'yes':
                        orig_mroute_present = True
                        break

        if not orig_mroute_present:
            return orig_mroute_present
        if self.debug:
            print "(%s,%s) l3 egress present" % (source, group)

        # check whether uuc/umc/bc group contains the l3 egress object
        #
        # vpns:
        # =====
        # vpn: 0x7001; vni: 16777215; has_svi: 0
        #   flags: 0x9a; eg_vlan: 0; bc_grp: 0xc000002; mc_grp: 0xc000001
        # vpn: 0x7005; vni: 1001; has_svi: 1
        #   flags: 0x9a; eg_vlan: 0; bc_grp: 0xc00000a; mc_grp: 0xc000009
        # vpn: 0x7003; vni: 1000; has_svi: 1
        #   flags: 0x9a; eg_vlan: 0; bc_grp: 0xc000006; mc_grp: 0xc000005

        proc = subprocess.Popen(['grep', '-B1', 'mc_grp', VXLAN_INFO], stdout=subprocess.PIPE)
        out = proc.communicate()[0]
        lines = out.splitlines()

        orig_mroute_present = False
        for l in lines:
            if 'mc_grp' in l:
                bc_grp = l.split()[5][0:-1]
                mc_grp = l.split()[7]
                mc_entry_present = asic.get_repl_group_entry(mc_grp, egress_if)
                bc_entry_present = asic.get_repl_group_entry(bc_grp, egress_if)
                if mc_entry_present and bc_entry_present:
                    orig_mroute_present = True
                    break

        if self.debug and orig_mroute_present:
            print "(%s,%s) bum group includes l3-egress" % (source, group)
        return orig_mroute_present

    def check_term_mroute(self, source, group):

        # check tunnel initiator and terminator
        #
        # tunnels:
        # ========
        # init_id: 0x0; term_id: 0x4c000001; sip: 0.0.0.0; dip: 239.1.1.101
        # init_id: 0x0; term_id: 0x4c000002; sip: 0.0.0.0; dip: 239.1.1.100

        proc = subprocess.Popen(['grep', 'term_id', VXLAN_INFO], stdout=subprocess.PIPE)
        out = proc.communicate()[0]
        lines = out.splitlines()

        term_mroute_present = False
        for l in lines:
            if 'term_id' in l:
                init_id = l.split()[1][0:-1]
                sip = l.split()[5][0:-1]
                dip = l.split()[7]

            if source in sip and group in dip and init_id == "0x0":
                term_mroute_present = True
                break

        return term_mroute_present
