#!/usr/bin/env python
# Copyright 2019-2020 Cumulus Networks, Inc.
#
# kernel_hw_check cl-kernel-hw-checker helper library

from sys import stdout, stderr
from functools import reduce
from cStringIO import StringIO
import json

VERBOSE = 1
VERY_VERBOSE = 2
JSON = 3

class DiffTestParam(object):

    def __init__(self, set1, set2, exceptions, msg, key):
        self.set1 = set1
        self.set2 = set2
        self.exceptions = exceptions
        self.msg = msg
        self.key = key

        # also store any result diffs here
        self.results = None

class Comparer(object):

    def __init__(self):
        print "Comparer Object for kernel and asic"
        self.diff_dict = {}

    def _s_diff_t(self, s, t, exceptions):
        """
        Find differences between set s and set t.
        An exception set can be used to rule out known differences.
        """
        return sorted(s.difference(t).difference(exceptions))

    def s_diff_t(self, diff_test_param):
        return self._s_diff_t(diff_test_param.set1,
                              diff_test_param.set2,
                              diff_test_param.exceptions)

    def run_tests(self, check_tuples, return_bit=0):
        for i, diff_test_param in enumerate(check_tuples, return_bit):
            diff = self.s_diff_t(diff_test_param)
            if diff:
                print "DIFFERENCE"
                print diff
                diff_test_param.results = diff

                if diff_test_param.key in self.diff_dict:
                    self.diff_dict[diff_test_param.key].append(diff_test_param)
                else:
                    self.diff_dict[diff_test_param.key] = [diff_test_param]
                self.ret_code = 1
        pass

    def get_result_json(self):

        if not self.diff_dict:
            return json.dumps({'status': 'success'})

        out_sio = StringIO()
        data_dict = {}

        for diff_key in self.diff_dict:
            if len(self.diff_dict[diff_key]) > 1:
                res_list = []
                for dtparam_obj in self.diff_dict[diff_key]:
                    res_list.extend(dtparam_obj.results)
                data_dict[diff_key] = res_list
            else:
                # If only 1 result, just grab its results directly
                data_dict[diff_key] = self.diff_dict[diff_key][0].results

        out_dict = {'status': 'error',
                    'data': data_dict}
        json.dump(out_dict, out_sio)
        return out_sio.getvalue()

    def get_result_str(self):
        """
        Handle human readable and JSON output given a \
        dictionary of key-->DiffTestParam objects.
        """
        if not self.diff_dict:
            return ""
        out_sio = StringIO()
        for diff_obj_list in sorted(self.diff_dict.values()):
            if diff_obj_list:
                for diff_obj in diff_obj_list:
                    print >> out_sio, "%s:" % diff_obj.msg
                    for i, diff in enumerate(diff_obj.results):
                        if i > 2:
                            print >> out_sio, "   more..."
                            break
                        print >> out_sio, "  ", diff
        return out_sio.getvalue()

def check(check_name, hw_checker, verbose,  link=None):
    hw_check_fun_name = "check_" + check_name
    assert hasattr(hw_checker, hw_check_fun_name), \
            "Missing ASIC function '%s'\n" % hw_check_fun_name
    hw_check_fun = getattr(hw_checker, "check_" + check_name)

    if link is not None:
        return hw_check_fun(link, verbose)
    else:
        return hw_check_fun(verbose)
