#!/bin/bash

set -e

progname=$(basename "$0")

usage () {
	echo "Usage: $progname [options]"
	echo ""
	echo "Reads distribution service file from stdin."
	echo "Writes modified service file to stdout."
	echo ""
	echo "optional arguments:"
	echo "  -h, --help            Print this help and exit."
}

result=$(getopt -o h --long help -n "$progname" -- "$@")

if [ $? != 0 ]; then
	echo "Error: getopt error" >&2
	exit 1
fi

eval set -- "$result"

while true ; do
	case "$1" in
		-h|--help)
			usage
			exit 0
			;;
		--)
			shift
			break
			;;
		*)
			echo "Error: could not parse arguments" >&2
			exit 1
			;;
	esac
	shift
done

if [ "$1" ]; then
	echo "Error: too many arguments" >&2
	usage >&2
	exit 2
fi

echo "# Automatically generated by gen_service.sh from cumulus-docker-setup based on"
echo "# docker-ce $(dpkg-query --show --showformat '${Version}\n' docker-ce)"
echo

while read line; do
	if [[ "$line" =~ ^Requires[[:space:]]*=(.*)$ ]]; then
		if units=$(echo "${BASH_REMATCH[1]}" | xargs -n1 | \
			grep -vx "docker.socket"); then
			echo "Requires=$(echo "$units" | xargs)"
		fi
	elif [[ "$line" =~ ^ExecStart[[:space:]]*=(.*)$ ]]; then
		cmd=${BASH_REMATCH[1]/-H fd:\/\/ }
		echo "ExecStart=$cmd"
	else
		echo "$line"
	fi
done
