#ifndef __CS_MGR_CLI_H__
#define __CS_MGR_CLI_H__

#define CSMGR_CLI_SOCK_PATH "/run/csmgr_cli.sock"
#define CSMGR_CLI_MAX_BUFFER 1024

#define CSMGR_PORTS_IN_MAINTENACE_PORT_MODE_FILE "/tmp/.ports_in_maint"

typedef enum {
    WARMBOOT = 1,
    FASTBOOT,
    COLDBOOT,
    MAINTENANCE_MODE_ENABLE,
    MAINTENANCE_MODE_DISABLE,
    MAINTENANCE_PORT_DOWN,
    MAINTENANCE_PORT_RESTORE,
    UPGRADE_MODE,
    UPGRADE_DRY_RUN_MODE,
    SHOW,

    /* following are for responses. */
    
    SHOW_IN_PROGRESS,
    RESP_OVER,
    INVALID
} cs_mgr_cli_cmd_t;

typedef struct {
    cs_mgr_cli_cmd_t cmd;    
} cs_mgr_cli_msg_t;

typedef struct {
    cs_mgr_cli_msg_t status;   /* must match cs_mgr_cli_msg_t above - must be at the beginning. */
    int len;         /* length of entire structure (including data). */
    char data[0];
} cs_mgr_cli_resp_t;

#endif   /* __CS_MGR_CLI_H__ */
