#ifndef CS_MGR_H
#define CS_MGR_H

#include <signal.h>
#include "cs_mgr_intf.h"

#define DEFAULT_KEEPALIVE_INIT_DELAY 60
#define DEFAULT_KEEPALIVE_INTERVAL 60
#define DEFAULT_MODULE_RESPONSE_TIMEOUT 5
#define MODCOUNT_INFINITY (-1 * MAX_MODULES - 1)

/* 
 * Init wait to check for L3 modules. SwitchD takes 25 seconds, CLAGD is quick. STP etc are not in. If 
 * upper layers are not up in 7x5 sec, we assume they will not be there now.
 */

#define CSMGR_NUM_L2_MODULES          2
#define CSMGR_MODULE_UP_POLL_INTERVAL 8
#define CSMGR_MODULE_UP_POLL 5
#define CSMGR_MODULE_DISCOVERY_RESP_WAIT 1

typedef struct registered_modules_t {
    module_status mod_status;
    int last_keepalive;
} registered_modules;

typedef void (*TIMER_CB)(union sigval arg);

extern registered_modules registered_mods[];
extern Mode  startup_operative_mode, operative_mode;
extern State required_state;

#define CSMGR_DEFAULT_BOOT_MODE REBOOT_COLD
#define MAX_MODE_STR_LEN 64
#define CSMGR_STATE_FP "/var/cache/csmsgr/csmgrd.state"

#define MLX_SDK_BOOT_MODE_FILE "/sys/module/sx_core/parameters/fast_boot"
#define MLX_FAST_BOOT 1
#define MLX_COLD_BOOT 0

/* the following should be consistent with mode_to_str() */

static inline Mode str_to_mode(char *mode_str) {
    if (!strcmp("upgrade", mode_str)) return UPGRADE;
    if (!strcmp("reboot_cold", mode_str)) return(REBOOT_COLD);
    if (!strcmp("reboot_fast", mode_str)) return(REBOOT_FAST);
    if (!strcmp("reboot_warm", mode_str)) return(REBOOT_WARM);
    if (!strcmp("sys_upgrade_reboot_cold", mode_str)) return(SYS_UPGRADE_REBOOT_COLD);
    if (!strcmp("sys_upgrade_reboot_fast", mode_str)) return(SYS_UPGRADE_REBOOT_FAST);
    if (!strcmp("sys_upgrade_reboot_warm", mode_str)) return(SYS_UPGRADE_REBOOT_WARM);
    if (!strcmp("maintenance", mode_str)) return(MAINTENANCE);
    return -1;
}

extern bool csmgr_process_init_complete(void *comm_socket, msg *req, int *resp_len, int buf_len, void *buf);
extern bool csmgr_arm_monitor_timer(int start_delay, int interval);
extern bool csmgr_pub_msg (int len, void *m);
extern bool csmgr_admin_modules (Mode reason, Module target_mod, bool up);
extern int csmgr_get_num_active_modules(void);
extern bool csmgr_is_mod_registered(Module mod);
extern bool record_csmgr_state(Module module, Mode mode);
extern Mode read_csmgr_state(Module module);
extern int csmgr_create_comm_channel(void);
extern int csmgr_create_pub_channel(void);

extern int csmgr_start_cli(void);
extern int csmgr_stop_cli(void);

#endif // CS_MGR_H
