#ifndef CS_MGR_INTF_H
#define CS_MGR_INTF_H

typedef enum {
    CSMGR          = 0,
    ALL_MODULES    = 1,
    FRR            = 2,
    BGP            = 3,
    OSPF           = 4,
    STP            = 5,
    CLAG           = 6,
    SWITCHD        = 7,
    SDK            = 8,
    MAX_MODULES    = 9,
} Module;

static inline char * mod_id_to_str(Module mod) {
    switch (mod) {
        case CSMGR:
            return("csmgr");
        case ALL_MODULES:
            return("all");
        case FRR            :
            return("frr");
        case BGP:
            return("bgp");
        case OSPF:
            return("ospf");
        case STP:
            return("stp");
        case CLAG:
            return("clag");
        case SWITCHD:
            return("switchd");
        case SDK:
            return("sdk");
        case MAX_MODULES:
            return("max_modules");
    }

    return("Unknown");
}

/* Please keep Mode and mode_to_str consistent */

typedef enum {
    UPGRADE        = 0,
    REBOOT_COLD    = 1,
    REBOOT_FAST    = 2,
    REBOOT_WARM    = 3,
    SYS_UPGRADE_REBOOT_COLD    = 4,
    SYS_UPGRADE_REBOOT_FAST    = 5,
    SYS_UPGRADE_REBOOT_WARM    = 6,
    MAINTENANCE    = 7,
} Mode;

static inline char *mode_to_str(Mode mode) {
    switch (mode) {
        case UPGRADE:
            return("upgrade");
        case REBOOT_COLD:
            return("reboot_cold");
        case REBOOT_FAST:
            return("reboot_fast");
        case REBOOT_WARM:
            return("reboot_warm");
        case SYS_UPGRADE_REBOOT_COLD:
            return("sys_upgrade_reboot_cold");
        case SYS_UPGRADE_REBOOT_FAST:
            return("sys_upgrade_reboot_fast");
        case SYS_UPGRADE_REBOOT_WARM:
            return("sys_upgrade_reboot_warm");
        case MAINTENANCE:
            return("Maintenance");
        default:
            return("unknown");
    }
}

/* The following typedef and mod_state_to_str() must be kept consistent. */

typedef enum {
    /* modules to sys_mgr. */
    SUCCESS        = 0,
    FAILURE,
    IN_PROGRESS,
    LOAD_COMPLETE,
    INIT_COMPLETE,
    KEEP_ALIVE_RESP,
    MODULE_STATUS_RESP,
    MODULE_REGISTER,
    MODULE_UNREGISTER,

    /* mostly initiated by sys_mgr to modules. */
    GO_DOWN = 100,
    DOWN,
    COME_UP,
    UP,
    MODE_INFO,
    MOD_LIST,
    KEEP_ALIVE_REQ,
    ACK,
    NACK,
    NETWORK_LAYER_INFO,
    MODULE_STATUS_REQ,
} State;

static inline char *mod_state_to_str (State state) {
    switch (state) {
    case SUCCESS: return("success");
    case FAILURE: return("failure");
    case IN_PROGRESS: return("in progress");
    case LOAD_COMPLETE: return("load complete");
    case INIT_COMPLETE: return("init complete");
    case KEEP_ALIVE_RESP: return("keepalive response");
    case MODULE_STATUS_RESP: return("module status response");
    case MODULE_REGISTER: return("module register");
    case MODULE_UNREGISTER: return("module unregister");
    case GO_DOWN: return("going down");
    case DOWN: return("down");
    case COME_UP: return("coming up");
    case UP: return("up");
    case MODE_INFO: return("mode info");
    case MOD_LIST: return("mode list");
    case KEEP_ALIVE_REQ: return("keepalive request");
    case ACK: return("ack");
    case NACK: return("nack");
    case NETWORK_LAYER_INFO: return("network layer info");
    case MODULE_STATUS_REQ: return("module status request");
    }
    
    return("Unknown");
}

typedef enum {
    NO_ERROR       = 0,
    BUSY           = 1,
    UNKNOWN        = 0,
} Failure_Reason; 

/* Internal usage for register / unregister. */

typedef struct module_connect_t {
    Module mod;
} module_connect;

/* status communicated csmgr. */

typedef struct module_mode_t {
    Module mod;
    Mode   mode;
    State  state;
} module_mode;

typedef struct module_status_t {
    module_mode mode;
    Failure_Reason failure_reason;
} module_status;

typedef module_status module_status_response;   /* identical. */

typedef struct module_down_status_t {
    Module mod; /* the mod in question. */
    module_mode mode;
    Failure_Reason failure_reason;
} module_down_status;

typedef struct module_list_t {
    Module mod_list[0];
} module_list;

typedef struct keepalive_request_t {
    int seq;
} keepalive_request;

typedef struct keepalive_response_t {
    int seq;
    module_status mod_status;
} keepalive_response;

typedef struct msg_t {
    int type;
    int len;
    char data[0];
} msg;

typedef struct msg_pkg_t {
    int total_len;
    msg entry[0];
} msg_pkg;

/* end point names. */

//#define CSMGR_PUB_SUB_CHAN "ipc:///tmp/CSMGR"

#define CSMGR_PUB_SUB_CHAN "tcp://127.0.0.1:49012"
#define CSMGR_COMM_CHAN    "tcp://127.0.0.1:49002"

#define MAX_MSG_LEN 1024
#define CSMGR_DEFAULT_COMM_SOCKET_TIMEOUT 500   /* milliseconsd. */
#define CSMGR_DEFAULT_COMM_SOCKET_RETRY   6
#define CSMGR_DEFAULT_COMM_RESET_ON_ERROR true

/* Module Callback function */

typedef int (*INFR_CB)(int len, void *buf);  

/* Library interface functions. */

extern int csmgr_register_cb(Module self, int num_mods, Module mods[], INFR_CB csmgr_cb);
extern int csmgr_unregister(Module self);
extern int csmgr_send(Module self, int len, void *req, int resp_len, void *resp);
extern void csmgr_set_comm_channel_parms(int timeout, int num_retry, bool reset_on_error);

#endif // CS_MGR__INTF_H
