/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es.security;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.shard.IndexSearcherWrapper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import tech.beshu.ror.es.ESContextImpl;
import tech.beshu.ror.es.security.DocumentFieldReader;
import tech.beshu.ror.es.security.DocumentFilterReader;
import tech.beshu.ror.settings.BasicSettings;
import tech.beshu.ror.shims.es.LoggerShim;
import tech.beshu.ror.utils.FilterTransient;

public class RoleIndexSearcherWrapper
extends IndexSearcherWrapper {
    private final LoggerShim logger;
    private final Function<ShardId, QueryShardContext> queryShardContextProvider;
    private final ThreadContext threadContext;
    private final Boolean enabled;

    public RoleIndexSearcherWrapper(IndexService indexService, Settings s, Environment env) throws Exception {
        if (indexService == null) {
            throw new IllegalArgumentException("Please provide an indexService");
        }
        Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (String[])new String[]{((Object)((Object)this)).getClass().getSimpleName()});
        logger.debug("Create new RoleIndexSearcher wrapper, [{}]", (Object)indexService.getIndexSettings().getIndex().getName());
        this.queryShardContextProvider = shardId -> indexService.newQueryShardContext(shardId.id(), null, null, null);
        this.threadContext = indexService.getThreadPool().getThreadContext();
        this.logger = ESContextImpl.mkLoggerShim(logger);
        BasicSettings baseSettings = BasicSettings.fromFileObj((LoggerShim)this.logger, (Path)env.configFile().toAbsolutePath(), (Object)s);
        this.enabled = baseSettings.isEnabled();
    }

    protected DirectoryReader wrap(DirectoryReader reader) {
        if (!this.enabled.booleanValue()) {
            this.logger.debug("Document filtering not available. Return default reader");
            return reader;
        }
        try {
            Set fields;
            String fieldsHeader = (String)this.threadContext.getTransient("_fields");
            Set set = fields = Strings.isNullOrEmpty((String)fieldsHeader) ? null : Sets.newHashSet((Object[])fieldsHeader.split(",")).stream().map(String::trim).collect(Collectors.toSet());
            if (fields != null) {
                reader = DocumentFieldReader.wrap(reader, fields);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't extract FLS fields from threadContext.", e);
        }
        FilterTransient filterTransient = FilterTransient.deserialize((String)((String)this.threadContext.getTransient("_filter")));
        if (filterTransient == null) {
            this.logger.trace("filterTransient not found from threadContext.");
            return reader;
        }
        ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
        if (shardId == null) {
            throw new IllegalStateException(LoggerMessageFormat.format((String)"Couldn't extract shardId from reader [{}]", (Object[])new Object[]{reader}));
        }
        String filter = filterTransient.getFilter();
        if (filter == null || filter.equals("")) {
            return reader;
        }
        try {
            BooleanQuery.Builder boolQuery = new BooleanQuery.Builder();
            boolQuery.setMinimumNumberShouldMatch(1);
            QueryShardContext queryShardContext = this.queryShardContextProvider.apply(shardId);
            XContentParser parser = JsonXContent.jsonXContent.createParser(queryShardContext.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, filter);
            QueryBuilder queryBuilder = queryShardContext.parseInnerQueryBuilder(parser);
            ParsedQuery parsedQuery = queryShardContext.toQuery(queryBuilder);
            boolQuery.add(parsedQuery.query(), BooleanClause.Occur.SHOULD);
            DocumentFilterReader.DocumentFilterDirectoryReader wrappedReader = DocumentFilterReader.wrap(reader, (Query)new ConstantScoreQuery((Query)boolQuery.build()));
            return wrappedReader;
        }
        catch (IOException e) {
            this.logger.error("Unable to setup document security");
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    protected IndexSearcher wrap(IndexSearcher indexSearcher) throws EngineException {
        return indexSearcher;
    }
}

