/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es.security;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ExceptionsHelper;

public final class DocumentFilterReader
extends FilterLeafReader {
    private final Bits liveDocs;
    private final int numDocs;

    private DocumentFilterReader(LeafReader reader, Query query) throws IOException {
        super(reader);
        IndexSearcher searcher = new IndexSearcher((IndexReader)this);
        searcher.setQueryCache(null);
        Weight preserveWeight = searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 0.0f);
        int maxDoc = this.in.maxDoc();
        FixedBitSet bits = new FixedBitSet(maxDoc);
        Scorer preserveScorer = preserveWeight.scorer(this.getContext());
        if (preserveScorer != null) {
            bits.or(preserveScorer.iterator());
        }
        if (this.in.hasDeletions()) {
            Bits oldLiveDocs = this.in.getLiveDocs();
            assert (oldLiveDocs != null);
            BitSetIterator it = new BitSetIterator((BitSet)bits, 0L);
            int i = it.nextDoc();
            while (i != Integer.MAX_VALUE) {
                if (!oldLiveDocs.get(i)) {
                    bits.clear(i);
                }
                i = it.nextDoc();
            }
        }
        this.liveDocs = bits;
        this.numDocs = bits.cardinality();
    }

    public static DocumentFilterDirectoryReader wrap(DirectoryReader in, Query filterQuery) throws IOException {
        return new DocumentFilterDirectoryReader(in, filterQuery);
    }

    public int numDocs() {
        return this.numDocs;
    }

    public boolean hasDeletions() {
        return true;
    }

    public Bits getLiveDocs() {
        return this.liveDocs;
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public static final class DocumentFilterDirectoryReader
    extends FilterDirectoryReader {
        private final Query filterQuery;

        DocumentFilterDirectoryReader(DirectoryReader in, Query filterQuery) throws IOException {
            super(in, (FilterDirectoryReader.SubReaderWrapper)new DocumentFilterDirectorySubReader(filterQuery));
            this.filterQuery = filterQuery;
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new DocumentFilterDirectoryReader(in, this.filterQuery);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private static final class DocumentFilterDirectorySubReader
    extends FilterDirectoryReader.SubReaderWrapper {
        private final Query query;

        public DocumentFilterDirectorySubReader(Query filterQuery) {
            this.query = filterQuery;
        }

        public LeafReader wrap(LeafReader reader) {
            try {
                return new DocumentFilterReader(reader, this.query);
            }
            catch (Exception e) {
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }
    }
}

