/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es.security;

import com.google.common.collect.Iterators;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import tech.beshu.ror.Constants;
import tech.beshu.ror.utils.MatcherWithWildcardsAndNegations;

public class DocumentFieldReader
extends FilterLeafReader {
    protected static final Logger logger = Loggers.getLogger(DocumentFieldReader.class, (String[])new String[]{DocumentFieldReader.class.getName()});
    private final FieldInfos remainingFieldsInfo;
    private final FieldPolicy policy;

    private DocumentFieldReader(LeafReader reader, Set<String> fields) {
        super(reader);
        this.policy = new FieldPolicy(fields);
        FieldInfos fInfos = this.in.getFieldInfos();
        HashSet<String> baseFields = new HashSet<String>(fInfos.size());
        for (FieldInfo f2 : fInfos) {
            baseFields.add(f2.name);
        }
        if (baseFields.isEmpty()) {
            logger.warn("original fields were empty! This is weird!");
            this.remainingFieldsInfo = fInfos;
        } else {
            Set<FieldInfo> remainingFields = StreamSupport.stream(fInfos.spliterator(), false).filter(x -> this.policy.canKeep(x.name)).collect(Collectors.toSet());
            this.remainingFieldsInfo = new FieldInfos(remainingFields.toArray(new FieldInfo[remainingFields.size()]));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("always allow: " + Constants.FIELDS_ALWAYS_ALLOW);
            logger.debug("original fields were: " + baseFields);
            logger.debug("new      fields  are: " + StreamSupport.stream(this.remainingFieldsInfo.spliterator(), false).map(f -> f.name).collect(Collectors.toSet()));
        }
    }

    public static DocumentFieldDirectoryReader wrap(DirectoryReader in, Set<String> fields) throws IOException {
        return new DocumentFieldDirectoryReader(in, fields);
    }

    public FieldInfos getFieldInfos() {
        return this.remainingFieldsInfo;
    }

    public Fields getTermVectors(int docID) throws IOException {
        final Fields original = this.in.getTermVectors(docID);
        return new Fields(){

            public Iterator<String> iterator() {
                return Iterators.filter((Iterator)original.iterator(), s -> DocumentFieldReader.this.policy.canKeep((String)s));
            }

            public Terms terms(String field) throws IOException {
                return DocumentFieldReader.this.policy.canKeep(field) ? original.terms(field) : null;
            }

            public int size() {
                return DocumentFieldReader.this.remainingFieldsInfo.size();
            }
        };
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return this.policy.canKeep(field) ? this.in.getNumericDocValues(field) : null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return this.policy.canKeep(field) ? this.in.getBinaryDocValues(field) : null;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        return this.policy.canKeep(field) ? this.in.getNormValues(field) : null;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return this.policy.canKeep(field) ? this.in.getSortedDocValues(field) : null;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return this.policy.canKeep(field) ? this.in.getSortedNumericDocValues(field) : null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        return this.policy.canKeep(field) ? this.in.getSortedSetDocValues(field) : null;
    }

    public PointValues getPointValues(String field) throws IOException {
        return this.policy.canKeep(field) ? this.in.getPointValues(field) : null;
    }

    public Terms terms(String field) throws IOException {
        return this.policy.canKeep(field) ? this.in.terms(field) : null;
    }

    public LeafMetaData getMetaData() {
        return this.in.getMetaData();
    }

    public Bits getLiveDocs() {
        return this.in.getLiveDocs();
    }

    public int numDocs() {
        return this.in.numDocs();
    }

    public LeafReader getDelegate() {
        return this.in;
    }

    public void document(int docID, final StoredFieldVisitor visitor) throws IOException {
        super.document(docID, new StoredFieldVisitor(){

            public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                return DocumentFieldReader.this.policy.canKeep(fieldInfo.name) ? visitor.needsField(fieldInfo) : StoredFieldVisitor.Status.NO;
            }

            public int hashCode() {
                return visitor.hashCode();
            }

            public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
                visitor.stringField(fieldInfo, value);
            }

            public boolean equals(Object obj) {
                return visitor.equals(obj);
            }

            public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
                visitor.doubleField(fieldInfo, value);
            }

            public void floatField(FieldInfo fieldInfo, float value) throws IOException {
                visitor.floatField(fieldInfo, value);
            }

            public void intField(FieldInfo fieldInfo, int value) throws IOException {
                visitor.intField(fieldInfo, value);
            }

            public void longField(FieldInfo fieldInfo, long value) throws IOException {
                visitor.longField(fieldInfo, value);
            }

            public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
                if (!"_source".equals(fieldInfo.name)) {
                    visitor.binaryField(fieldInfo, value);
                    return;
                }
                Tuple xContentTypeMapTuple = XContentHelper.convertToMap((BytesReference)new BytesArray(value), (boolean)false, (XContentType)XContentType.JSON);
                Map map = (Map)xContentTypeMapTuple.v2();
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    if (DocumentFieldReader.this.policy.canKeep((String)it.next())) continue;
                    it.remove();
                }
                XContentBuilder xBuilder = XContentBuilder.builder((XContent)((XContentType)xContentTypeMapTuple.v1()).xContent()).map(map);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                BytesReference.bytes((XContentBuilder)xBuilder).writeTo((OutputStream)out);
                visitor.binaryField(fieldInfo, out.toByteArray());
            }
        });
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public static class FieldPolicy {
        private final MatcherWithWildcardsAndNegations fieldsMatcher;

        public FieldPolicy(Set<String> fields) {
            this.fieldsMatcher = new MatcherWithWildcardsAndNegations(fields);
        }

        public boolean canKeep(String field) {
            int indexOfDot = field.lastIndexOf(46);
            if (indexOfDot > 0) {
                field = field.substring(0, indexOfDot);
            }
            if (Constants.FIELDS_ALWAYS_ALLOW.contains(field)) {
                return true;
            }
            return this.fieldsMatcher.match(field);
        }
    }

    public static final class DocumentFieldDirectoryReader
    extends FilterDirectoryReader {
        private final Set<String> fields;

        DocumentFieldDirectoryReader(DirectoryReader in, Set<String> fields) throws IOException {
            super(in, (FilterDirectoryReader.SubReaderWrapper)new DocumentFieldDirectorySubReader(fields));
            this.fields = fields;
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new DocumentFieldDirectoryReader(in, this.fields);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private static final class DocumentFieldDirectorySubReader
    extends FilterDirectoryReader.SubReaderWrapper {
        private final Set<String> fields;

        public DocumentFieldDirectorySubReader(Set<String> fields) {
            this.fields = fields;
        }

        public LeafReader wrap(LeafReader reader) {
            try {
                return new DocumentFieldReader(reader, this.fields);
            }
            catch (Exception e) {
                throw ExceptionsHelper.convertToElastic((Exception)e);
            }
        }
    }
}

