/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es.rradmin;

import com.google.common.util.concurrent.FutureCallback;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import tech.beshu.ror.es.ResponseActionListener;
import tech.beshu.ror.es.SettingsObservableImpl;
import tech.beshu.ror.es.rradmin.RRAdminRequest;
import tech.beshu.ror.es.rradmin.RRAdminResponse;
import tech.beshu.ror.settings.RawSettings;
import tech.beshu.ror.settings.SettingsUtils;

public class TransportRRAdminAction
extends HandledTransportAction<RRAdminRequest, RRAdminResponse> {
    private final NodeClient client;
    private final SettingsObservableImpl settingsObservable;

    @Inject
    public TransportRRAdminAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client, SettingsObservableImpl settingsObservable) {
        super("cluster:admin/rradmin/refreshsettings", transportService, actionFilters, RRAdminRequest::new);
        this.client = client;
        this.settingsObservable = settingsObservable;
    }

    private String normalisePath(String s) {
        return s.substring(0, s.length() - (s.endsWith("/") ? 1 : 0));
    }

    protected void doExecute(Task task, RRAdminRequest request, final ActionListener<RRAdminResponse> listener) {
        try {
            String method = request.getMethod().toUpperCase();
            String body = request.getContent();
            String path = request.getPath();
            if ("POST".equals(method)) {
                if ("/_readonlyrest/admin/refreshconfig".equals(this.normalisePath(path))) {
                    this.settingsObservable.refreshFromIndex();
                    listener.onResponse((Object)new RRAdminResponse("ok refreshed"));
                    return;
                }
                if ("/_readonlyrest/admin/config".equals(this.normalisePath(path))) {
                    if (body.length() == 0) {
                        listener.onFailure(new Exception("empty body"));
                        return;
                    }
                    this.settingsObservable.refreshFromStringAndPersist(new RawSettings(SettingsUtils.extractYAMLfromJSONStorage((String)body), this.settingsObservable.getCurrent().getLogger()), new FutureCallback(){

                        public void onSuccess(Object result) {
                            listener.onResponse((Object)new RRAdminResponse("updated settings"));
                        }

                        public void onFailure(Throwable t) {
                            listener.onFailure(new Exception("could not update settings ", t));
                        }
                    });
                    return;
                }
            }
            if ("GET".equals(method)) {
                if ("/_readonlyrest/admin/config/file".equals(this.normalisePath(path))) {
                    try {
                        String currentSettingsYAML = this.settingsObservable.getFromFile().yaml();
                        listener.onResponse((Object)new RRAdminResponse(currentSettingsYAML));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                    return;
                }
                if ("/_readonlyrest/admin/config".equals(this.normalisePath(path))) {
                    String currentSettingsYAML = this.settingsObservable.getCurrent().yaml();
                    listener.onResponse((Object)new RRAdminResponse(currentSettingsYAML));
                    return;
                }
                if ("/_readonlyrest/metadata/current_user".equals(this.normalisePath(path))) {
                    listener.onResponse((Object)new RRAdminResponse("will be filled in " + ResponseActionListener.class.getSimpleName()));
                    return;
                }
            }
            listener.onFailure(new Exception("Didn't find anything to handle this request"));
        }
        catch (Exception e) {
            listener.onResponse((Object)new RRAdminResponse(e));
        }
    }
}

