/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es;

import com.google.common.util.concurrent.FutureCallback;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.Environment;
import tech.beshu.ror.es.ESContextImpl;
import tech.beshu.ror.settings.BasicSettings;
import tech.beshu.ror.settings.RawSettings;
import tech.beshu.ror.settings.SettingsObservable;
import tech.beshu.ror.settings.SettingsUtils;
import tech.beshu.ror.shims.es.LoggerShim;

@Singleton
public class SettingsObservableImpl
extends SettingsObservable {
    private static final LoggerShim logger = ESContextImpl.mkLoggerShim(LogManager.getLogger(SettingsObservableImpl.class));
    private final NodeClient client;
    private final Environment environment;

    @Inject
    public SettingsObservableImpl(NodeClient client, Settings s, Environment env) {
        this.environment = env;
        this.client = client;
        this.current = BasicSettings.fromFileObj((LoggerShim)logger, (Path)env.configFile().toAbsolutePath(), (Object)s).getRaw();
    }

    protected Path getConfigPath() {
        return this.environment.configFile().toAbsolutePath();
    }

    protected LoggerShim getLogger() {
        return logger;
    }

    protected RawSettings getFromIndex() {
        GetResponse resp;
        try {
            resp = (GetResponse)this.client.prepareGet(".readonlyrest", "settings", "1").get();
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ElasticsearchException("no settings found in index", (Throwable)rnfe, new Object[0]);
        }
        catch (Throwable t) {
            throw new ElasticsearchException(t.getMessage(), t, new Object[0]);
        }
        if (resp == null || !resp.isExists()) {
            throw new ElasticsearchException("no settings found in index", (Throwable)new ElasticsearchException("null response from index query", new Object[0]), new Object[0]);
        }
        String yamlString = (String)resp.getSource().get("settings");
        return new RawSettings(yamlString, logger);
    }

    protected void writeToIndex(RawSettings rawSettings, final FutureCallback f) {
        this.client.prepareBulk().add((IndexRequest)this.client.prepareIndex(".readonlyrest", "settings", "1").setSource(SettingsUtils.toJsonStorage((String)rawSettings.yaml()), XContentType.JSON).request()).execute((ActionListener)new ActionListener<BulkResponse>(){

            public void onResponse(BulkResponse bulkItemResponses) {
                logger.info("all ok, written settings");
                f.onSuccess((Object)bulkItemResponses);
            }

            public void onFailure(Exception e) {
                logger.error("could not write settings to index: ", (Throwable)e);
                f.onFailure((Throwable)e);
            }
        });
    }

    public boolean isClusterReady() {
        try {
            ClusterHealthStatus status = ((ClusterHealthResponse)this.client.admin().cluster().prepareHealth(new String[0]).get()).getStatus();
            return !status.equals((Object)ClusterHealthStatus.RED);
        }
        catch (Throwable e) {
            return false;
        }
    }
}

