/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.Netty4Transport;
import tech.beshu.ror.SSLCertParser;
import tech.beshu.ror.es.ESContextImpl;
import tech.beshu.ror.settings.BasicSettings;
import tech.beshu.ror.shims.es.LoggerShim;

public class SSLNetty4InternodeServerTransport
extends Netty4Transport {
    private static final boolean DEFAULT_SSL_VERIFICATION_INTERNODE = true;
    private final BasicSettings.SSLSettings sslSettings;
    private final LoggerShim logger = ESContextImpl.mkLoggerShim(Loggers.getLogger(((Object)((Object)this)).getClass(), (String[])new String[]{((Object)((Object)this)).getClass().getSimpleName()}));
    private boolean sslVerification = true;

    public SSLNetty4InternodeServerTransport(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, BasicSettings.SSLSettings sslSettings) {
        super(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService);
        this.sslSettings = sslSettings;
        this.sslVerification = sslSettings.isClientAuthVerify().orElse(true);
    }

    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node) {
        return new Netty4Transport.ClientChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                super.initChannel(ch);
                SSLNetty4InternodeServerTransport.this.logger.info(">> internode SSL channel initializing");
                SslContextBuilder sslCtxBuilder = SslContextBuilder.forClient();
                if (!SSLNetty4InternodeServerTransport.this.sslVerification) {
                    sslCtxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                }
                final SslContext sslCtx = sslCtxBuilder.build();
                ch.pipeline().addFirst(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

                    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
                        SSLEngine sslEngine = sslCtx.newEngine(ctx.alloc());
                        sslEngine.setUseClientMode(true);
                        sslEngine.setNeedClientAuth(true);
                        ctx.pipeline().replace((ChannelHandler)this, "internode_ssl_client", (ChannelHandler)new SslHandler(sslEngine));
                        super.connect(ctx, remoteAddress, localAddress, promise);
                    }
                }});
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                if (cause instanceof NotSslRecordException || cause.getCause() != null && cause.getCause() instanceof NotSslRecordException) {
                    SSLNetty4InternodeServerTransport.this.logger.error("Receiving non-SSL connections from: (" + ctx.channel().remoteAddress() + "). Will disconnect");
                    ctx.channel().close();
                } else {
                    super.exceptionCaught(ctx, cause);
                }
            }
        };
    }

    public final ChannelHandler getServerChannelInitializer(String name) {
        return new SslChannelInitializer(name);
    }

    public class SslChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        private Optional<SslContext> context;

        public SslChannelInitializer(String name) {
            super((Netty4Transport)SSLNetty4InternodeServerTransport.this, name);
            this.context = Optional.empty();
            new SSLCertParser(SSLNetty4InternodeServerTransport.this.sslSettings, SSLNetty4InternodeServerTransport.this.logger, (certChain, privateKey) -> {
                try {
                    SslContextBuilder sslCtxBuilder = SslContextBuilder.forServer((InputStream)new ByteArrayInputStream(certChain.getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(privateKey.getBytes(StandardCharsets.UTF_8)), null);
                    if (SSLNetty4InternodeServerTransport.this.sslVerification) {
                        sslCtxBuilder.clientAuth(ClientAuth.REQUIRE);
                    }
                    SSLNetty4InternodeServerTransport.this.logger.info("ROR Internode using SSL provider: " + SslContext.defaultServerProvider().name());
                    SSLCertParser.validateProtocolAndCiphers((SSLEngine)sslCtxBuilder.build().newEngine(ByteBufAllocator.DEFAULT), (LoggerShim)SSLNetty4InternodeServerTransport.this.logger, (BasicSettings.SSLSettings)SSLNetty4InternodeServerTransport.this.sslSettings);
                    SSLNetty4InternodeServerTransport.this.sslSettings.getAllowedSSLCiphers().ifPresent(arg_0 -> ((SslContextBuilder)sslCtxBuilder).ciphers(arg_0));
                    SSLNetty4InternodeServerTransport.this.sslSettings.getAllowedSSLProtocols().map(protoList -> protoList.toArray(new String[protoList.size()])).ifPresent(arg_0 -> ((SslContextBuilder)sslCtxBuilder).protocols(arg_0));
                    this.context = Optional.of(sslCtxBuilder.build());
                }
                catch (Exception e) {
                    this.context = Optional.empty();
                    SSLNetty4InternodeServerTransport.this.logger.error("Failed to load SSL CertChain & private key from Keystore! " + e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
                }
            });
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            this.context.ifPresent(sslCtx -> ch.pipeline().addFirst("ror_internode_ssl_handler", (ChannelHandler)sslCtx.newHandler(ch.alloc())));
        }
    }
}

