/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.netty4.Netty4HttpServerTransport;
import org.elasticsearch.threadpool.ThreadPool;
import tech.beshu.ror.SSLCertParser;
import tech.beshu.ror.es.ESContextImpl;
import tech.beshu.ror.settings.BasicSettings;
import tech.beshu.ror.shims.es.LoggerShim;

public class SSLNetty4HttpServerTransport
extends Netty4HttpServerTransport {
    private static final boolean DEFAULT_SSL_VERIFICATION_HTTP = false;
    private final BasicSettings.SSLSettings sslSettings;
    private final LoggerShim logger = ESContextImpl.mkLoggerShim(Loggers.getLogger(((Object)((Object)this)).getClass(), (String[])new String[]{((Object)((Object)this)).getClass().getSimpleName()}));
    private final Environment environment;
    private Boolean sslVerification = false;

    public SSLNetty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, Environment environment) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher);
        this.environment = environment;
        BasicSettings basicSettings = BasicSettings.fromFileObj((LoggerShim)this.logger, (Path)this.environment.configFile().toAbsolutePath(), (Object)settings);
        if (basicSettings.getSslHttpSettings().map(x -> x.isSSLEnabled()).orElse(false).booleanValue()) {
            this.sslSettings = (BasicSettings.SSLSettings)basicSettings.getSslHttpSettings().get();
            this.logger.info("creating SSL HTTP transport");
            this.sslVerification = this.sslSettings.isClientAuthVerify().orElse(false);
        } else {
            this.sslSettings = null;
        }
    }

    protected void onException(HttpChannel channel, Exception cause) {
        if (!this.lifecycle.started()) {
            return;
        }
        if (cause.getCause() instanceof NotSslRecordException) {
            this.logger.warn(cause.getMessage() + " connecting from: " + channel.getRemoteAddress());
        } else {
            super.onException(channel, cause);
        }
        channel.close();
    }

    public ChannelHandler configureServerChannelHandler() {
        return new SSLHandler(this);
    }

    private class SSLHandler
    extends Netty4HttpServerTransport.HttpChannelHandler {
        private Optional<SslContext> context;

        SSLHandler(Netty4HttpServerTransport transport) {
            super(transport, SSLNetty4HttpServerTransport.this.handlingSettings);
            this.context = Optional.empty();
            new SSLCertParser(SSLNetty4HttpServerTransport.this.sslSettings, SSLNetty4HttpServerTransport.this.logger, (certChain, privateKey) -> {
                try {
                    SslContextBuilder sslCtxBuilder = SslContextBuilder.forServer((InputStream)new ByteArrayInputStream(certChain.getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(privateKey.getBytes(StandardCharsets.UTF_8)), null);
                    SSLNetty4HttpServerTransport.this.logger.info("ROR SSL HTTP: Using SSL provider: " + SslContext.defaultServerProvider().name());
                    SSLCertParser.validateProtocolAndCiphers((SSLEngine)sslCtxBuilder.build().newEngine(ByteBufAllocator.DEFAULT), (LoggerShim)SSLNetty4HttpServerTransport.this.logger, (BasicSettings.SSLSettings)SSLNetty4HttpServerTransport.this.sslSettings);
                    SSLNetty4HttpServerTransport.this.sslSettings.getAllowedSSLCiphers().ifPresent(arg_0 -> ((SslContextBuilder)sslCtxBuilder).ciphers(arg_0));
                    if (SSLNetty4HttpServerTransport.this.sslVerification.booleanValue()) {
                        sslCtxBuilder.clientAuth(ClientAuth.REQUIRE);
                    }
                    SSLNetty4HttpServerTransport.this.sslSettings.getAllowedSSLProtocols().map(protoList -> protoList.toArray(new String[protoList.size()])).ifPresent(arg_0 -> ((SslContextBuilder)sslCtxBuilder).protocols(arg_0));
                    this.context = Optional.of(sslCtxBuilder.build());
                }
                catch (Exception e) {
                    this.context = Optional.empty();
                    SSLNetty4HttpServerTransport.this.logger.error("Failed to load SSL HTTP CertChain & private key from Keystore! " + e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
                }
            });
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            this.context.ifPresent(sslCtx -> ch.pipeline().addFirst("ssl_netty4_handler", (ChannelHandler)sslCtx.newHandler(ch.alloc())));
        }
    }
}

