/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.termvectors.MultiTermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.reflections.ReflectionUtils;
import tech.beshu.ror.shims.es.ESContext;
import tech.beshu.ror.shims.es.LoggerShim;
import tech.beshu.ror.shims.request.RequestInfoShim;
import tech.beshu.ror.utils.RCUtils;
import tech.beshu.ror.utils.ReflecUtils;

public class RequestInfo
implements RequestInfoShim {
    private final RestRequest request;
    private final String action;
    private final ActionRequest actionRequest;
    private final String id;
    private final ClusterService clusterService;
    private final Long taskId;
    private final RemoteClusterService remoteClusterService;
    private final ThreadPool threadPool;
    private final LoggerShim logger;
    private final RestChannel channel;
    private String content = null;
    private Integer contentLength;
    private ESContext context;

    RequestInfo(RestChannel channel, Long taskId, String action, ActionRequest actionRequest, ClusterService clusterService, ThreadPool threadPool, ESContext context, RemoteClusterService remoteClusterService) {
        this.context = context;
        this.logger = context.logger(this.getClass());
        this.threadPool = threadPool;
        this.request = channel.request();
        this.channel = channel;
        this.action = action;
        this.actionRequest = actionRequest;
        this.clusterService = clusterService;
        this.taskId = taskId;
        this.remoteClusterService = remoteClusterService;
        String tmpID = this.request.hashCode() + "-" + actionRequest.hashCode();
        this.id = taskId != null ? tmpID + "#" + taskId : tmpID;
    }

    public String extractType() {
        return this.actionRequest.getClass().getSimpleName();
    }

    public Integer getContentLength() {
        if (this.contentLength == null) {
            BytesReference cnt = this.request.content();
            this.contentLength = cnt == null ? Integer.valueOf(0) : Integer.valueOf(this.request.content().length());
        }
        return this.contentLength;
    }

    public Set<String> extractIndexMetadata(String index) {
        SortedMap lookup = this.clusterService.state().metaData().getAliasAndIndexLookup();
        return ((AliasOrIndex)lookup.get(index)).getIndices().stream().map(IndexMetaData::getIndexUUID).collect(Collectors.toSet());
    }

    public Long extractTaskId() {
        return this.taskId;
    }

    public RestChannel getChannel() {
        return this.channel;
    }

    public Integer extractContentLength() {
        if (this.contentLength == null) {
            BytesReference cnt = this.request.content();
            this.contentLength = cnt == null ? Integer.valueOf(0) : Integer.valueOf(this.request.content().length());
        }
        return this.contentLength;
    }

    public String extractContent() {
        if (this.content == null) {
            try {
                this.content = this.request.content().utf8ToString();
            }
            catch (Exception e) {
                this.content = "";
            }
        }
        return this.content;
    }

    public String extractMethod() {
        return this.request.method().name();
    }

    public String extractURI() {
        return this.request.uri();
    }

    public Set<String> extractIndices() {
        MultiGetRequest cir;
        IndexRequest ir;
        Object[] indices = new String[]{};
        ActionRequest ar = this.actionRequest;
        if (ar instanceof IndexRequest) {
            ir = (IndexRequest)ar;
            indices = ir.indices();
        } else if (ar instanceof MultiGetRequest) {
            cir = (MultiGetRequest)ar;
            for (MultiGetRequest.Item ir2 : cir.getItems()) {
                indices = (String[])ArrayUtils.concat((Object[])indices, (Object[])ir2.indices(), String.class);
            }
        } else if (ar instanceof MultiSearchRequest) {
            cir = (MultiSearchRequest)ar;
            for (SearchRequest ir3 : cir.requests()) {
                indices = (String[])ArrayUtils.concat((Object[])indices, (Object[])ir3.indices(), String.class);
            }
        } else if (ar instanceof MultiTermVectorsRequest) {
            cir = (MultiTermVectorsRequest)ar;
            for (TermVectorsRequest ir4 : cir.getRequests()) {
                indices = (String[])ArrayUtils.concat((Object[])indices, (Object[])ir4.indices(), String.class);
            }
        } else if (ar instanceof BulkRequest) {
            cir = (BulkRequest)ar;
            for (DocWriteRequest ir5 : cir.requests()) {
                indices = (String[])ArrayUtils.concat((Object[])indices, (Object[])ir5.indices(), String.class);
            }
        } else if (ar instanceof DeleteRequest) {
            ir = (DeleteRequest)ar;
            indices = ir.indices();
        } else if (ar instanceof IndicesAliasesRequest) {
            ir = (IndicesAliasesRequest)ar;
            indices = (String[])ir.getAliasActions().stream().map(x -> Sets.newHashSet((Object[])x.indices())).flatMap(Collection::stream).distinct().toArray(String[]::new);
        } else if (ar instanceof ReindexRequest) {
            try {
                SearchRequest sr = (SearchRequest)ReflecUtils.invokeMethodCached((Object)ar, ar.getClass(), (String)"getSearchRequest");
                IndexRequest ir6 = (IndexRequest)ReflecUtils.invokeMethodCached((Object)ar, ar.getClass(), (String)"getDestination");
                indices = (String[])ArrayUtils.concat((Object[])sr.indices(), (Object[])ir6.indices(), String.class);
            }
            catch (Exception e) {
                this.logger.error("cannot extract indices from: " + this.extractMethod() + " " + this.extractURI() + "\n" + this.extractContent(), (Throwable)e);
                e.printStackTrace();
            }
        } else if (!ar.getClass().getSimpleName().startsWith("Sql")) {
            if (ar instanceof CompositeIndicesRequest) {
                this.logger.error("Found an instance of CompositeIndicesRequest that could not be handled: report this as a bug immediately! " + ar.getClass().getSimpleName());
            } else if (ar instanceof RestoreSnapshotRequest) {
                RestoreSnapshotRequest rsr = (RestoreSnapshotRequest)ar;
                indices = rsr.indices();
            } else {
                indices = ReflecUtils.extractStringArrayFromPrivateMethod((String)"indices", (Object)ar, (ESContext)this.context);
                if (indices == null || indices.length == 0) {
                    indices = ReflecUtils.extractStringArrayFromPrivateMethod((String)"index", (Object)ar, (ESContext)this.context);
                }
            }
        }
        if (indices == null) {
            indices = new String[]{};
        }
        HashSet indicesSet = Sets.newHashSet((Object[])indices);
        if (this.logger.isDebugEnabled()) {
            String idxs = String.join((CharSequence)",", indicesSet);
            this.logger.debug("Discovered indices: " + idxs);
        }
        return indicesSet;
    }

    public Set<String> extractSnapshots() {
        if (this.actionRequest instanceof GetSnapshotsRequest) {
            GetSnapshotsRequest rsr = (GetSnapshotsRequest)this.actionRequest;
            return Sets.newHashSet((Object[])rsr.snapshots());
        }
        if (this.actionRequest instanceof CreateSnapshotRequest) {
            CreateSnapshotRequest r = (CreateSnapshotRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{r.snapshot()});
        }
        if (this.actionRequest instanceof DeleteSnapshotRequest) {
            DeleteSnapshotRequest r = (DeleteSnapshotRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{r.snapshot()});
        }
        if (this.actionRequest instanceof RestoreSnapshotRequest) {
            RestoreSnapshotRequest r = (RestoreSnapshotRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{r.snapshot()});
        }
        if (this.actionRequest instanceof SnapshotsStatusRequest) {
            SnapshotsStatusRequest r = (SnapshotsStatusRequest)this.actionRequest;
            return Sets.newHashSet((Object[])r.snapshots());
        }
        return Collections.emptySet();
    }

    public void writeSnapshots(Set<String> newSnapshots) {
        if (newSnapshots.isEmpty()) {
            return;
        }
        String[] newSnapshotsA = newSnapshots.toArray(new String[newSnapshots.size()]);
        if (this.actionRequest instanceof GetSnapshotsRequest) {
            GetSnapshotsRequest rsr = (GetSnapshotsRequest)this.actionRequest;
            rsr.snapshots(newSnapshotsA);
            return;
        }
        if (this.actionRequest instanceof SnapshotsStatusRequest) {
            SnapshotsStatusRequest r = (SnapshotsStatusRequest)this.actionRequest;
            r.snapshots(newSnapshotsA);
            return;
        }
    }

    public void writeRepositories(Set<String> newRepositories) {
        if (newRepositories.isEmpty()) {
            return;
        }
        String[] newRepositoriesA = newRepositories.toArray(new String[newRepositories.size()]);
        if (this.actionRequest instanceof GetSnapshotsRequest) {
            GetSnapshotsRequest rsr = (GetSnapshotsRequest)this.actionRequest;
            rsr.repository(newRepositoriesA[0]);
            return;
        }
        if (this.actionRequest instanceof SnapshotsStatusRequest) {
            SnapshotsStatusRequest r = (SnapshotsStatusRequest)this.actionRequest;
            r.repository(newRepositoriesA[0]);
            return;
        }
        if (this.actionRequest instanceof GetRepositoriesRequest) {
            GetRepositoriesRequest r = (GetRepositoriesRequest)this.actionRequest;
            r.repositories(newRepositoriesA);
            return;
        }
        if (this.actionRequest instanceof VerifyRepositoryRequest) {
            VerifyRepositoryRequest r = (VerifyRepositoryRequest)this.actionRequest;
            r.name(newRepositoriesA[0]);
            return;
        }
    }

    public Set<String> extractRepositories() {
        if (this.actionRequest instanceof GetSnapshotsRequest) {
            GetSnapshotsRequest rsr = (GetSnapshotsRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{rsr.repository()});
        }
        if (this.actionRequest instanceof CreateSnapshotRequest) {
            CreateSnapshotRequest r = (CreateSnapshotRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{r.repository()});
        }
        if (this.actionRequest instanceof DeleteSnapshotRequest) {
            DeleteSnapshotRequest r = (DeleteSnapshotRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{r.repository()});
        }
        if (this.actionRequest instanceof RestoreSnapshotRequest) {
            RestoreSnapshotRequest r = (RestoreSnapshotRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{r.repository()});
        }
        if (this.actionRequest instanceof SnapshotsStatusRequest) {
            SnapshotsStatusRequest r = (SnapshotsStatusRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{r.repository()});
        }
        if (this.actionRequest instanceof PutRepositoryRequest) {
            PutRepositoryRequest r = (PutRepositoryRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{r.name()});
        }
        if (this.actionRequest instanceof GetRepositoriesRequest) {
            GetRepositoriesRequest r = (GetRepositoriesRequest)this.actionRequest;
            return Sets.newHashSet((Object[])r.repositories());
        }
        if (this.actionRequest instanceof DeleteRepositoryRequest) {
            DeleteRepositoryRequest r = (DeleteRepositoryRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{r.name()});
        }
        if (this.actionRequest instanceof VerifyRepositoryRequest) {
            VerifyRepositoryRequest r = (VerifyRepositoryRequest)this.actionRequest;
            return Sets.newHashSet((Object[])new String[]{r.name()});
        }
        return Collections.emptySet();
    }

    public String extractAction() {
        return this.action;
    }

    public String extractId() {
        return this.id;
    }

    public Map<String, String> extractRequestHeaders() {
        TreeMap<String, String> h = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this.request.getHeaders().keySet().forEach(k -> {
            if (this.request.getAllHeaderValues(k).isEmpty()) {
                return;
            }
            h.put((String)k, (String)this.request.getAllHeaderValues(k).iterator().next());
        });
        return h;
    }

    public String extractLocalAddress() {
        try {
            String remoteHost = this.request.getHttpChannel().getLocalAddress().getAddress().getHostAddress();
            return remoteHost;
        }
        catch (Exception e) {
            this.logger.error("Could not extract local address", (Throwable)e);
            return null;
        }
    }

    public String extractRemoteAddress() {
        try {
            String remoteHost = this.request.getHttpChannel().getRemoteAddress().getAddress().getHostAddress();
            if (RCUtils.isLocalHost((String)remoteHost)) {
                remoteHost = "127.0.0.1";
            }
            return remoteHost;
        }
        catch (Exception e) {
            this.logger.error("Could not extract remote address", (Throwable)e);
            return null;
        }
    }

    public void writeIndices(Set<String> newIndices) {
        Iterator it;
        if (newIndices.isEmpty()) {
            return;
        }
        newIndices.remove("<no-index>");
        newIndices.remove("");
        if (this.actionRequest instanceof IndicesRequest.Replaceable) {
            ((IndicesRequest.Replaceable)this.actionRequest).indices(newIndices.toArray(new String[newIndices.size()]));
            return;
        }
        if (this.actionRequest instanceof BulkShardRequest) {
            BulkShardRequest bsr = (BulkShardRequest)this.actionRequest;
            String singleIndex = newIndices.iterator().next();
            String uuid = this.extractIndexMetadata(singleIndex).iterator().next();
            AccessController.doPrivileged(() -> {
                Set fields = ReflectionUtils.getAllFields(bsr.shardId().getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withName((String)"index")});
                fields.stream().forEach(f -> {
                    f.setAccessible(true);
                    try {
                        f.set(bsr.shardId(), new Index(singleIndex, uuid));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                });
                return null;
            });
        }
        if (this.actionRequest instanceof MultiSearchRequest) {
            MultiSearchRequest msr = (MultiSearchRequest)this.actionRequest;
            for (SearchRequest sr : msr.requests()) {
                if (sr.indices().length == 0 || Sets.newHashSet((Object[])sr.indices()).contains("*")) {
                    sr.indices(newIndices.toArray(new String[newIndices.size()]));
                    continue;
                }
                Set expandedSrIndices = this.getExpandedIndices(Sets.newHashSet((Object[])sr.indices()));
                HashSet remaining = Sets.newHashSet((Iterable)expandedSrIndices);
                remaining.retainAll(newIndices);
                if (remaining.size() == 0) {
                    sr.source(new SearchSourceBuilder().size(0));
                    continue;
                }
                if (remaining.size() == expandedSrIndices.size()) continue;
                sr.indices(remaining.toArray(new String[remaining.size()]));
            }
            return;
        }
        if (this.actionRequest instanceof MultiGetRequest) {
            MultiGetRequest mgr = (MultiGetRequest)this.actionRequest;
            it = mgr.getItems().iterator();
            while (it.hasNext()) {
                Set indices;
                MultiGetRequest.Item item = (MultiGetRequest.Item)it.next();
                Set remaining = indices = this.getExpandedIndices(Sets.newHashSet((Object[])item.indices()));
                remaining.retainAll(newIndices);
                if (!remaining.isEmpty()) continue;
                it.remove();
            }
            return;
        }
        if (this.actionRequest instanceof IndicesAliasesRequest) {
            IndicesAliasesRequest iar = (IndicesAliasesRequest)this.actionRequest;
            it = iar.getAliasActions().iterator();
            while (it.hasNext()) {
                Set indices;
                IndicesAliasesRequest.AliasActions act = (IndicesAliasesRequest.AliasActions)it.next();
                Set remaining = indices = this.getExpandedIndices(Sets.newHashSet((Object[])act.indices()));
                remaining.retainAll(newIndices);
                if (remaining.isEmpty()) {
                    it.remove();
                    continue;
                }
                act.indices(remaining.toArray(new String[remaining.size()]));
            }
            return;
        }
        boolean okSetResult = ReflecUtils.setIndices((Object)this.actionRequest, (Set)Sets.newHashSet((Object[])new String[]{"index", "indices"}), newIndices, (LoggerShim)this.logger);
        if (okSetResult) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("REFLECTION: success changing indices: " + newIndices + " correctly set as " + this.extractIndices());
            }
        } else {
            this.logger.error("REFLECTION: Failed to set indices for type " + this.actionRequest.getClass().getSimpleName() + "  in req id: " + this.extractId());
        }
    }

    public void writeResponseHeaders(Map<String, String> hMap) {
        hMap.keySet().forEach(k -> {
            String val = (String)hMap.get(k);
            this.threadPool.getThreadContext().addResponseHeader(k, val, v -> val);
        });
    }

    public Set<Map.Entry<String, Set<String>>> extractAllIndicesAndAliases() {
        ImmutableOpenMap indices = this.clusterService.state().metaData().getIndices();
        HashSet result = Sets.newHashSet();
        indices.keysIt().forEachRemaining(key -> {
            IndexMetaData indexMetaData = (IndexMetaData)indices.get(key);
            String indexName = indexMetaData.getIndex().getName();
            HashSet aliases = Sets.newHashSet((Iterator)indexMetaData.getAliases().keysIt());
            result.add(Maps.immutableEntry((Object)indexName, (Object)aliases));
        });
        return result;
    }

    public boolean involvesIndices() {
        return this.actionRequest instanceof IndicesRequest || this.actionRequest instanceof CompositeIndicesRequest || this.actionRequest instanceof RestoreSnapshotRequest;
    }

    public boolean extractIsReadRequest() {
        return RCUtils.isReadRequest((String)this.action);
    }

    public boolean extractIsAllowedForDLS() {
        if (!this.extractIsReadRequest()) {
            return false;
        }
        if (this.actionRequest instanceof SearchRequest) {
            SearchRequest sr = (SearchRequest)this.actionRequest;
            if (sr.source() == null) {
                return true;
            }
            if (sr.source().profile() || sr.source().suggest() != null && !sr.source().suggest().getSuggestions().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public boolean extractIsCompositeRequest() {
        return this.actionRequest instanceof CompositeIndicesRequest;
    }

    public void writeToThreadContextHeaders(Map<String, String> hMap) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        hMap.keySet().forEach(k -> threadContext.putTransient(k, hMap.get(k)));
    }

    public boolean extractHasRemoteClusters() {
        return this.remoteClusterService.isCrossClusterSearchEnabled();
    }
}

