/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.ResourceWatcherService;
import tech.beshu.ror.Constants;
import tech.beshu.ror.configuration.AllowedSettings;
import tech.beshu.ror.es.ESContextImpl;
import tech.beshu.ror.es.IndexLevelActionFilter;
import tech.beshu.ror.es.SSLNetty4HttpServerTransport;
import tech.beshu.ror.es.SSLNetty4InternodeServerTransport;
import tech.beshu.ror.es.SettingsObservableImpl;
import tech.beshu.ror.es.ThreadRepo;
import tech.beshu.ror.es.rradmin.RRAdminAction;
import tech.beshu.ror.es.rradmin.TransportRRAdminAction;
import tech.beshu.ror.es.rradmin.rest.RestRRAdminAction;
import tech.beshu.ror.es.security.RoleIndexSearcherWrapper;
import tech.beshu.ror.settings.BasicSettings;
import tech.beshu.ror.shims.es.LoggerShim;

public class ReadonlyRestPlugin
extends Plugin
implements ScriptPlugin,
ActionPlugin,
IngestPlugin,
NetworkPlugin {
    private final Settings settings;
    private final BasicSettings basicSettings;
    private IndexLevelActionFilter ilaf;
    private SettingsObservableImpl settingsObservable;
    private Environment environment;

    @Inject
    public ReadonlyRestPlugin(Settings s, Path p) {
        this.settings = s;
        this.environment = new Environment(s, p);
        Constants.FIELDS_ALWAYS_ALLOW.addAll(Sets.newHashSet((Object[])MapperService.getAllMetaFields()));
        LoggerShim logger = ESContextImpl.mkLoggerShim(Loggers.getLogger(((Object)((Object)this)).getClass(), (String[])new String[]{((Object)((Object)this)).getClass().getSimpleName()}));
        this.basicSettings = BasicSettings.fromFileObj((LoggerShim)logger, (Path)this.environment.configFile().toAbsolutePath(), (Object)this.settings);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry) {
        ArrayList<Object> components = new ArrayList<Object>(3);
        AccessController.doPrivileged(() -> {
            this.environment = environment;
            this.settingsObservable = new SettingsObservableImpl((NodeClient)client, this.settings, environment);
            this.ilaf = new IndexLevelActionFilter(this.settings, clusterService, (NodeClient)client, threadPool, this.settingsObservable, environment, TransportServiceInterceptor.getRemoteClusterServiceSupplier());
            components.add((Object)this.settingsObservable);
            return null;
        });
        return components;
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>(1);
        services.add(TransportServiceInterceptor.class);
        return services;
    }

    public List<ActionFilter> getActionFilters() {
        return Collections.singletonList(this.ilaf);
    }

    public void onIndexModule(IndexModule indexModule) {
        indexModule.setSearcherWrapper(indexService -> {
            try {
                return new RoleIndexSearcherWrapper(indexService, this.settings, this.environment);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher) {
        if (!this.basicSettings.getSslHttpSettings().map(x -> x.isSSLEnabled()).orElse(false).booleanValue()) {
            return Collections.EMPTY_MAP;
        }
        return Collections.singletonMap("ssl_netty4", () -> new SSLNetty4HttpServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher, this.environment));
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        if (!this.basicSettings.getSslInternodeSettings().map(x -> x.isSSLEnabled()).orElse(false).booleanValue()) {
            return Collections.EMPTY_MAP;
        }
        return Collections.singletonMap("ror_ssl_internode", () -> new SSLNetty4InternodeServerTransport(settings, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService, (BasicSettings.SSLSettings)this.basicSettings.getSslHttpSettings().get()));
    }

    public void close() {
        ESContextImpl.shutDownObservable.shutDown();
    }

    public List<Setting<?>> getSettings() {
        return AllowedSettings.list().entrySet().stream().map(e -> {
            Setting theSetting = null;
            switch ((AllowedSettings.SettingType)e.getValue()) {
                case BOOL: {
                    theSetting = Setting.boolSetting((String)((String)e.getKey()), (boolean)Boolean.FALSE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
                    break;
                }
                case STRING: {
                    theSetting = new Setting((String)e.getKey(), "", value -> value, new Setting.Property[]{Setting.Property.NodeScope});
                    break;
                }
                case GROUP: {
                    theSetting = Setting.groupSetting((String)((String)e.getKey()), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
                    break;
                }
                default: {
                    throw new ElasticsearchException("invalid settings " + e, new Object[0]);
                }
            }
            return theSetting;
        }).collect(Collectors.toList());
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Collections.singletonList(new ActionPlugin.ActionHandler((Action)RRAdminAction.INSTANCE, TransportRRAdminAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.singletonList(new RestRRAdminAction(settings, restController));
    }

    public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        return restHandler -> (request, channel, client) -> {
            ThreadRepo.channel.set(channel);
            restHandler.handleRequest(request, channel, client);
        };
    }

    private static class RemoteClusterServiceSupplier
    implements Supplier<Optional<RemoteClusterService>> {
        private final AtomicReference<Optional<RemoteClusterService>> remoteClusterServiceAtomicReference = new AtomicReference(Optional.empty());

        private RemoteClusterServiceSupplier() {
        }

        @Override
        public Optional<RemoteClusterService> get() {
            return this.remoteClusterServiceAtomicReference.get();
        }

        private void update(RemoteClusterService service) {
            this.remoteClusterServiceAtomicReference.set(Optional.ofNullable(service));
        }
    }

    public static class TransportServiceInterceptor
    extends AbstractLifecycleComponent {
        private static RemoteClusterServiceSupplier remoteClusterServiceSupplier;

        @Inject
        public TransportServiceInterceptor(TransportService transportService) {
            Optional.ofNullable(transportService.getRemoteClusterService()).ifPresent(r -> TransportServiceInterceptor.getRemoteClusterServiceSupplier().update(r));
        }

        public static synchronized RemoteClusterServiceSupplier getRemoteClusterServiceSupplier() {
            if (remoteClusterServiceSupplier == null) {
                remoteClusterServiceSupplier = new RemoteClusterServiceSupplier();
            }
            return remoteClusterServiceSupplier;
        }

        protected void doStart() {
        }

        protected void doStop() {
        }

        protected void doClose() throws IOException {
        }
    }
}

