/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es;

import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import monix.execution.Scheduler$;
import monix.execution.schedulers.CanBlock$;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.env.Environment;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import tech.beshu.ror.SecurityPermissionException;
import tech.beshu.ror.acl.AclHandlingResult;
import tech.beshu.ror.acl.AclStaticContext;
import tech.beshu.ror.acl.blocks.BlockContext;
import tech.beshu.ror.acl.helpers.AclActionHandler;
import tech.beshu.ror.acl.helpers.AclResultCommitter;
import tech.beshu.ror.acl.helpers.BlockContextJavaHelper$;
import tech.beshu.ror.acl.helpers.RorEngineFactory;
import tech.beshu.ror.acl.helpers.RorEngineFactory$;
import tech.beshu.ror.acl.logging.AuditSink;
import tech.beshu.ror.acl.request.EsRequestContext;
import tech.beshu.ror.acl.request.RequestContext;
import tech.beshu.ror.acl.utils.ScalaJavaHelper$;
import tech.beshu.ror.es.AuditSinkImpl;
import tech.beshu.ror.es.ESContextImpl;
import tech.beshu.ror.es.RequestInfo;
import tech.beshu.ror.es.ResponseActionListener;
import tech.beshu.ror.es.SettingsObservableImpl;
import tech.beshu.ror.es.ThreadRepo;
import tech.beshu.ror.settings.BasicSettings;
import tech.beshu.ror.shims.es.ESContext;
import tech.beshu.ror.shims.es.LoggerShim;
import tech.beshu.ror.shims.request.RequestInfoShim;

@Singleton
public class IndexLevelActionFilter
implements ActionFilter {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final AtomicReference<Optional<RorEngineFactory.Engine>> rorEngine;
    private final AtomicReference<ESContext> context = new AtomicReference();
    private final Logger logger;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final Supplier<Optional<RemoteClusterService>> remoteClusterServiceSupplier;

    public IndexLevelActionFilter(Settings settings, ClusterService clusterService, NodeClient client, ThreadPool threadPool, SettingsObservableImpl settingsObservable, Environment env, Supplier<Optional<RemoteClusterService>> remoteClusterServiceSupplier) {
        this.remoteClusterServiceSupplier = remoteClusterServiceSupplier;
        this.logger = LogManager.getLogger(this.getClass());
        try {
            System.setProperty("es.set.netty.runtime.available.processors", "false");
        }
        catch (Exception ex) {
            this.logger.error("Cannot set property 'es.set.netty.runtime.available.processors'", (Throwable)ex);
        }
        BasicSettings baseSettings = BasicSettings.fromFileObj((LoggerShim)ESContextImpl.mkLoggerShim(this.logger), (Path)env.configFile().toAbsolutePath(), (Object)settings);
        this.context.set((ESContext)new ESContextImpl(baseSettings));
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.rorEngine = new AtomicReference(Optional.empty());
        settingsObservable.addObserver((o, arg) -> {
            this.logger.info("Settings observer refreshing...");
            Environment newEnv = new Environment(settings, env.configFile().toAbsolutePath());
            BasicSettings newBasicSettings = new BasicSettings(settingsObservable.getCurrent(), newEnv.configFile().toAbsolutePath());
            ESContextImpl newContext = new ESContextImpl(newBasicSettings);
            this.context.set((ESContext)newContext);
            if (newContext.getSettings().isEnabled()) {
                FiniteDuration timeout = FiniteDuration.apply((long)10L, (TimeUnit)TimeUnit.MINUTES);
                RorEngineFactory.Engine engine = AccessController.doPrivileged(() -> this.lambda$null$0(client, newBasicSettings, (ESContext)newContext, timeout));
                Optional<RorEngineFactory.Engine> oldEngine = this.rorEngine.getAndSet(Optional.of(engine));
                oldEngine.ifPresent(this.scheduleDelayedEngineShutdown(java.time.Duration.ofSeconds(10L)));
                this.logger.info("Configuration reloaded - ReadonlyREST enabled");
            } else {
                Optional<RorEngineFactory.Engine> oldEngine = this.rorEngine.getAndSet(Optional.empty());
                oldEngine.ifPresent(this.scheduleDelayedEngineShutdown(java.time.Duration.ofSeconds(10L)));
                this.logger.info("Configuration reloaded - ReadonlyREST disabled");
            }
        });
        settingsObservable.forceRefresh();
        this.logger.info("Readonly REST plugin was loaded...");
        settingsObservable.pollForIndex(this.context.get());
    }

    public int order() {
        return 0;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        AccessController.doPrivileged(() -> {
            Optional<RorEngineFactory.Engine> engine = this.rorEngine.get();
            if (engine.isPresent()) {
                this.handleRequest(engine.get(), task, action, request, listener, chain);
            } else {
                chain.proceed(task, action, request, listener);
            }
            return null;
        });
    }

    private <Request extends ActionRequest, Response extends ActionResponse> void handleRequest(RorEngineFactory.Engine engine, Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        boolean reqNull;
        boolean chanNull;
        RestChannel channel = ThreadRepo.channel.get();
        if (channel != null) {
            ThreadRepo.channel.remove();
        }
        boolean bl = chanNull = channel == null;
        boolean bl2 = channel == null ? true : (reqNull = channel.request() == null);
        if (IndexLevelActionFilter.shouldSkipACL(chanNull, reqNull)) {
            chain.proceed(task, action, request, listener);
            return;
        }
        Optional<RemoteClusterService> remoteClusterService = this.remoteClusterServiceSupplier.get();
        if (remoteClusterService.isPresent()) {
            RequestInfo requestInfo = new RequestInfo(channel, task.getId(), action, request, this.clusterService, this.threadPool, this.context.get(), remoteClusterService.get());
            RequestContext requestContext = this.requestContextFrom(requestInfo);
            Consumer<ActionListener<Response>> proceed = responseActionListener -> chain.proceed(task, action, request, responseActionListener);
            engine.acl().handle(requestContext).runAsync(this.handleAclResult(engine, listener, request, requestContext, requestInfo, proceed), Scheduler$.MODULE$.global());
        } else {
            listener.onFailure(new Exception("Cluster service not ready yet. Cannot continue"));
        }
    }

    private <Request extends ActionRequest, Response extends ActionResponse> Function1<Either<Throwable, AclHandlingResult>, BoxedUnit> handleAclResult(RorEngineFactory.Engine engine, ActionListener<Response> listener, Request request, RequestContext requestContext, RequestInfo requestInfo, Consumer<ActionListener<Response>> chainProceed) {
        return result -> {
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                if (result.isRight()) {
                    AclActionHandler handler = this.createAclActionHandler(engine.context(), requestInfo, request, requestContext, listener, chainProceed);
                    AclResultCommitter.commit((AclHandlingResult)((AclHandlingResult)result.right().get()), (AclActionHandler)handler);
                } else {
                    listener.onFailure(new Exception((Throwable)result.left().get()));
                }
            }
            return null;
        };
    }

    private <Request extends ActionRequest, Response extends ActionResponse> AclActionHandler createAclActionHandler(final AclStaticContext aclStaticContext, final RequestInfo requestInfo, final Request request, final RequestContext requestContext, final ActionListener<Response> baseListener, final Consumer<ActionListener<Response>> chainProceed) {
        return new AclActionHandler(){

            public void onAllow(BlockContext blockContext) {
                ActionListener searchListener = this.createSearchListener(baseListener, request, requestContext, blockContext);
                requestInfo.writeResponseHeaders(JavaConverters$.MODULE$.mapAsJavaMap((Map)BlockContextJavaHelper$.MODULE$.responseHeadersFrom(blockContext)));
                requestInfo.writeToThreadContextHeaders(JavaConverters$.MODULE$.mapAsJavaMap((Map)BlockContextJavaHelper$.MODULE$.contextHeadersFrom(blockContext)));
                requestInfo.writeIndices(JavaConverters$.MODULE$.setAsJavaSet((Set)BlockContextJavaHelper$.MODULE$.indicesFrom(blockContext)));
                requestInfo.writeSnapshots(JavaConverters$.MODULE$.setAsJavaSet((Set)BlockContextJavaHelper$.MODULE$.snapshotsFrom(blockContext)));
                requestInfo.writeRepositories(JavaConverters$.MODULE$.setAsJavaSet((Set)BlockContextJavaHelper$.MODULE$.repositoriesFrom(blockContext)));
                chainProceed.accept(searchListener);
            }

            private ActionListener<Response> createSearchListener(ActionListener<Response> listener, Request request2, RequestContext requestContext2, BlockContext blockContext) {
                try {
                    if (aclStaticContext.involvesFilter()) {
                        if (request2 instanceof SearchRequest) {
                            IndexLevelActionFilter.this.logger.debug("ACL involves filters, will disable request cache for SearchRequest");
                            ((SearchRequest)request2).requestCache(Boolean.FALSE);
                        } else if (request2 instanceof MultiSearchRequest) {
                            IndexLevelActionFilter.this.logger.debug("ACL involves filters, will disable request cache for MultiSearchRequest");
                            for (SearchRequest sr : ((MultiSearchRequest)request2).requests()) {
                                sr.requestCache(Boolean.FALSE);
                            }
                        }
                    }
                    return new ResponseActionListener(listener, requestContext2, blockContext);
                }
                catch (Throwable e) {
                    IndexLevelActionFilter.this.logger.error("on allow exception", e);
                    return listener;
                }
            }

            public void onForbidden() {
                ElasticsearchStatusException exc = new ElasticsearchStatusException(((ESContext)IndexLevelActionFilter.this.context.get()).getSettings().getForbiddenMessage(), aclStaticContext.doesRequirePassword() ? RestStatus.UNAUTHORIZED : RestStatus.FORBIDDEN, new Object[0]){

                    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                        builder.field("reason", ((ESContext)IndexLevelActionFilter.this.context.get()).getSettings().getForbiddenMessage());
                        return builder;
                    }
                };
                if (aclStaticContext.doesRequirePassword()) {
                    exc.addHeader("WWW-Authenticate", new String[]{"Basic"});
                }
                baseListener.onFailure((Exception)exc);
            }

            public void onError(Throwable t) {
                baseListener.onFailure((Exception)t);
            }
        };
    }

    private AuditSink createAuditSink(final Client client, final BasicSettings settings) {
        return new AuditSink(){
            AuditSinkImpl auditSink;
            {
                this.auditSink = new AuditSinkImpl(client, settings);
            }

            public void submit(String indexName, String documentId, String jsonRecord) {
                this.auditSink.submit(indexName, documentId, jsonRecord);
            }
        };
    }

    private RequestContext requestContextFrom(RequestInfo requestInfo) {
        try {
            return (RequestContext)ScalaJavaHelper$.MODULE$.force(EsRequestContext.from((RequestInfoShim)requestInfo));
        }
        catch (Exception ex) {
            throw new SecurityPermissionException("Cannot create request context object", (Throwable)ex);
        }
    }

    private Consumer<RorEngineFactory.Engine> scheduleDelayedEngineShutdown(java.time.Duration delay) {
        return engine -> scheduler.schedule(() -> engine.shutdown(), delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    private static boolean shouldSkipACL(boolean chanNull, boolean reqNull) {
        if (reqNull && chanNull) {
            return true;
        }
        if (reqNull != chanNull) {
            if (chanNull) {
                throw new SecurityPermissionException("Problems analyzing the channel object. Have you checked the security permissions?", null);
            }
            if (reqNull) {
                throw new SecurityPermissionException("Problems analyzing the request object. Have you checked the security permissions?", null);
            }
        }
        return false;
    }

    private /* synthetic */ RorEngineFactory.Engine lambda$null$0(NodeClient client, BasicSettings newBasicSettings, ESContext newContext, FiniteDuration timeout) {
        return (RorEngineFactory.Engine)RorEngineFactory$.MODULE$.reload(this.createAuditSink((Client)client, newBasicSettings), newContext.getSettings().getRaw().yaml()).runSyncUnsafe((Duration)timeout, Scheduler$.MODULE$.global(), CanBlock$.MODULE$.permit());
    }
}

