/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import tech.beshu.ror.settings.BasicSettings;
import tech.beshu.ror.shims.es.AbstractESContext;
import tech.beshu.ror.shims.es.ESVersion;
import tech.beshu.ror.shims.es.LoggerShim;

public class ESContextImpl
extends AbstractESContext {
    private final BasicSettings settings;

    public ESContextImpl(BasicSettings settings) {
        this.settings = settings;
    }

    public static LoggerShim mkLoggerShim(final Logger l) {
        return new LoggerShim(){

            public void trace(String message) {
                l.trace(message);
            }

            public void info(String message) {
                l.info(message);
            }

            public void debug(String message) {
                l.debug(message);
            }

            public void warn(String message) {
                l.warn(message);
            }

            public void warn(String message, Throwable t) {
                l.warn(message, t);
                t.printStackTrace(System.out);
            }

            public void error(String message, Throwable t) {
                l.error(message, t);
                t.printStackTrace(System.out);
            }

            public void error(String message) {
                l.error(message);
            }

            public boolean isDebugEnabled() {
                return l.isDebugEnabled();
            }
        };
    }

    public LoggerShim mkLogger(Class<?> clazz) {
        return ESContextImpl.mkLoggerShim(LogManager.getLogger((String)clazz.getName()));
    }

    public RuntimeException rorException(String message) {
        return new ElasticsearchException(message, new Object[0]);
    }

    public ESVersion getVersion() {
        return new ESVersion(Version.CURRENT.id);
    }

    public BasicSettings getSettings() {
        return this.settings;
    }
}

