/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.es;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import tech.beshu.ror.Constants;
import tech.beshu.ror.settings.BasicSettings;

@Singleton
public class AuditSinkImpl {
    private static final Logger logger = LogManager.getLogger(AuditSinkImpl.class);
    private final BulkProcessor bulkProcessor;
    private final BasicSettings settings;

    @Inject
    public AuditSinkImpl(Client client, BasicSettings settings) {
        this.settings = settings;
        if (!settings.isAuditorCollectorEnabled().booleanValue()) {
            this.bulkProcessor = null;
            return;
        }
        this.bulkProcessor = BulkProcessor.builder((Client)client, (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                logger.debug("Flushing " + request.numberOfActions() + " bulk actions..");
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    logger.error("Some failures flushing the BulkProcessor: ");
                    Arrays.stream(response.getItems()).filter(r -> r.isFailed()).map(r -> r.getFailureMessage()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((message, times) -> logger.error(times + "x: " + message));
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                logger.error("Failed flushing the BulkProcessor: " + failure.getMessage());
                failure.printStackTrace();
            }
        }).setBulkActions(Constants.AUDIT_SINK_MAX_ITEMS.intValue()).setBulkSize(new ByteSizeValue((long)Constants.AUDIT_SINK_MAX_KB.intValue(), ByteSizeUnit.KB)).setFlushInterval(TimeValue.timeValueSeconds((long)Constants.AUDIT_SINK_MAX_SECONDS.intValue())).setConcurrentRequests(1).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)100L), (int)Constants.AUDIT_SINK_MAX_RETRIES)).build();
    }

    public void submit(String indexName, String documentId, String jsonRecord) {
        if (!this.settings.isAuditorCollectorEnabled().booleanValue()) {
            return;
        }
        IndexRequest ir = new IndexRequest(indexName, "ror_audit_evt", documentId).source(jsonRecord, XContentType.JSON);
        this.bulkProcessor.add(ir);
    }

    public void stop() {
        try {
            this.bulkProcessor.awaitClose(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

