/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.com.jayway.jsonpath.internal.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import tech.beshu.ror.com.jayway.jsonpath.Predicate;
import tech.beshu.ror.com.jayway.jsonpath.internal.Utils;
import tech.beshu.ror.com.jayway.jsonpath.internal.filter.ExpressionNode;
import tech.beshu.ror.com.jayway.jsonpath.internal.filter.LogicalOperator;

public class LogicalExpressionNode
extends ExpressionNode {
    protected List<ExpressionNode> chain = new ArrayList<ExpressionNode>();
    private final LogicalOperator operator;

    public static LogicalExpressionNode createLogicalOr(ExpressionNode left, ExpressionNode right) {
        return new LogicalExpressionNode(left, LogicalOperator.OR, right);
    }

    public static LogicalExpressionNode createLogicalOr(Collection<ExpressionNode> operands) {
        return new LogicalExpressionNode(LogicalOperator.OR, operands);
    }

    public static LogicalExpressionNode createLogicalAnd(ExpressionNode left, ExpressionNode right) {
        return new LogicalExpressionNode(left, LogicalOperator.AND, right);
    }

    public static LogicalExpressionNode createLogicalAnd(Collection<ExpressionNode> operands) {
        return new LogicalExpressionNode(LogicalOperator.AND, operands);
    }

    private LogicalExpressionNode(ExpressionNode left, LogicalOperator operator, ExpressionNode right) {
        this.chain.add(left);
        this.chain.add(right);
        this.operator = operator;
    }

    private LogicalExpressionNode(LogicalOperator operator, Collection<ExpressionNode> operands) {
        this.chain.addAll(operands);
        this.operator = operator;
    }

    public LogicalExpressionNode and(LogicalExpressionNode other) {
        return LogicalExpressionNode.createLogicalAnd(this, other);
    }

    public LogicalExpressionNode or(LogicalExpressionNode other) {
        return LogicalExpressionNode.createLogicalOr(this, other);
    }

    public LogicalOperator getOperator() {
        return this.operator;
    }

    public LogicalExpressionNode append(ExpressionNode expressionNode) {
        this.chain.add(0, expressionNode);
        return this;
    }

    public String toString() {
        return "(" + Utils.join(" " + this.operator.getOperatorString() + " ", this.chain) + ")";
    }

    @Override
    public boolean apply(Predicate.PredicateContext ctx) {
        if (this.operator == LogicalOperator.OR) {
            for (ExpressionNode expression : this.chain) {
                if (!expression.apply(ctx)) continue;
                return true;
            }
            return false;
        }
        for (ExpressionNode expression : this.chain) {
            if (expression.apply(ctx)) continue;
            return false;
        }
        return true;
    }
}

