/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import java.lang.reflect.Type;
import tech.beshu.ror.com.fasterxml.jackson.core.JsonGenerator;
import tech.beshu.ror.com.fasterxml.jackson.databind.JavaType;
import tech.beshu.ror.com.fasterxml.jackson.databind.JsonMappingException;
import tech.beshu.ror.com.fasterxml.jackson.databind.JsonNode;
import tech.beshu.ror.com.fasterxml.jackson.databind.SerializationFeature;
import tech.beshu.ror.com.fasterxml.jackson.databind.SerializerProvider;
import tech.beshu.ror.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tech.beshu.ror.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import tech.beshu.ror.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class UnknownSerializer
extends StdSerializer<Object> {
    public UnknownSerializer() {
        super(Object.class);
    }

    public UnknownSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        gen.writeStartObject();
        gen.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        typeSer.writeTypePrefixForObject(value, gen);
        typeSer.writeTypeSuffixForObject(value, gen);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }

    protected void failForEmpty(SerializerProvider prov, Object value) throws JsonMappingException {
        prov.reportMappingProblem("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", value.getClass().getName());
    }
}

