/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.utils;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Bytes;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import tech.beshu.ror.utils.Hasher;

public class SecureStringHasher
implements Hasher {
    private static byte[] salt;
    private static Map<Integer, byte[]> saltCache;
    private final HashFunction hf;
    private final String algo;

    public SecureStringHasher(String algo) {
        int saltSize;
        switch (algo.toLowerCase()) {
            case "sha256": {
                this.hf = Hashing.sha256();
                saltSize = 256;
                break;
            }
            case "sha348": {
                this.hf = Hashing.sha384();
                saltSize = 384;
                break;
            }
            case "sha512": {
                this.hf = Hashing.sha512();
                saltSize = 512;
                break;
            }
            default: {
                this.hf = Hashing.sha256();
                saltSize = 256;
            }
        }
        salt = saltCache.get(saltSize);
        if (salt == null) {
            salt = SecureRandom.getSeed(saltSize);
            saltCache.put(saltSize, salt);
        }
        this.algo = algo;
    }

    private static void rotate(byte[] arr, int order) {
        if (arr == null || order < 0) {
            throw new IllegalArgumentException("The array must be non-null and the order must be non-negative");
        }
        int offset = arr.length - order % arr.length;
        if (offset > 0) {
            byte[] copy = (byte[])arr.clone();
            for (int i = 0; i < arr.length; ++i) {
                int j = (i + offset) % arr.length;
                arr[i] = copy[j];
            }
        }
    }

    public String getAlgo() {
        return this.algo;
    }

    @Override
    public String hash(String originalKey) {
        int order = Hashing.consistentHash((HashCode)HashCode.fromBytes((byte[])originalKey.getBytes()), (int)salt.length);
        byte[] thisSalt = (byte[])salt.clone();
        SecureStringHasher.rotate(thisSalt, Math.abs(order));
        return this.hf.hashBytes(Bytes.concat((byte[][])new byte[][]{originalKey.getBytes(), thisSalt})).toString();
    }

    static {
        saltCache = new HashMap<Integer, byte[]>();
    }
}

