/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.utils;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Set;
import org.reflections.ReflectionUtils;
import tech.beshu.ror.Constants;
import tech.beshu.ror.SecurityPermissionException;
import tech.beshu.ror.shims.es.ESContext;
import tech.beshu.ror.shims.es.LoggerShim;

public class ReflecUtils {
    private static final HashMap<String, Method> methodsCache = new HashMap(128);

    public static Object invokeMethodCached(Object o, Class c, String method) {
        Object[] result = new Object[1];
        String cacheKey = c.getName() + "#" + method;
        return AccessController.doPrivileged(() -> {
            try {
                Method m = methodsCache.get(cacheKey);
                if (m != null) {
                    result[0] = m.invoke(o, new Object[0]);
                    return null;
                }
                try {
                    m = c.getDeclaredMethod(method, new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    m = c.getMethod(method, new Class[0]);
                }
                m.setAccessible(true);
                methodsCache.put(cacheKey, m);
                return m.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public static Object invokeMethod(Object o, Class c, String method) {
        String cacheKey = c.getName() + "#" + method;
        return AccessController.doPrivileged(() -> {
            try {
                Method m;
                try {
                    m = c.getDeclaredMethod(method, new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    m = c.getMethod(method, new Class[0]);
                }
                m.setAccessible(true);
                methodsCache.put(cacheKey, m);
                return m.invoke(o, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public static String[] extractStringArrayFromPrivateMethod(String methodName, Object o, ESContext context) {
        String[][] result = new String[][]{new String[0]};
        AccessController.doPrivileged(() -> {
            if (o == null) {
                throw context.rorException("cannot extract field from null!");
            }
            Class<?> clazz = o.getClass();
            while (!clazz.equals(Object.class)) {
                try {
                    Method m = ReflecUtils.exploreClassMethods(clazz, methodName, String[].class);
                    if (m != null) {
                        result[0] = (String[])m.invoke(o, new Object[0]);
                        return null;
                    }
                    m = ReflecUtils.exploreClassMethods(clazz, methodName, String.class);
                    if (m != null) {
                        result[0] = new String[]{(String)m.invoke(o, new Object[0])};
                        return null;
                    }
                }
                catch (SecurityException e) {
                    context.logger(ReflecUtils.class).error("Can't get indices for request because of wrong security configuration " + o.getClass());
                    throw new SecurityPermissionException("Insufficient permissions to extract field " + methodName + ". Abort! Cause: " + e.getMessage(), e);
                }
                catch (Exception e) {
                    context.logger(ReflecUtils.class).debug("Cannot to discover field " + methodName + " associated to this request: " + o.getClass());
                }
                clazz = clazz.getSuperclass();
            }
            return null;
        });
        return result[0];
    }

    private static Method exploreClassMethods(Class<?> c, String methodName, Class<?> returnClass) {
        String cacheKey = c.getName() + methodName + returnClass.getName();
        Method theMethod = methodsCache.get(cacheKey);
        if (theMethod != null) {
            return theMethod;
        }
        for (Method m : c.getDeclaredMethods()) {
            if (!methodName.equals(m.getName()) || !m.getReturnType().equals(returnClass)) continue;
            if (methodsCache.size() > Constants.CACHE_WATERMARK) {
                new Exception("Method cache has exceeded the watermark of " + Constants.CACHE_WATERMARK + " keys, currently at " + methodsCache.size()).printStackTrace();
            }
            m.setAccessible(true);
            methodsCache.put(cacheKey, m);
            return m;
        }
        return null;
    }

    public static boolean setIndices(Object o, Set<String> fieldNames, Set<String> newIndices, LoggerShim logger) {
        if (newIndices.isEmpty()) {
            return false;
        }
        boolean[] res = new boolean[]{false};
        AccessController.doPrivileged(() -> {
            Set indexFields = ReflectionUtils.getAllFields(o.getClass(), (Predicate[])new Predicate[]{field -> field != null && fieldNames.contains(field.getName()) && (field.getType().equals(String.class) || field.getType().equals(String[].class))});
            String firstIndex = (String)newIndices.iterator().next();
            for (Field f : indexFields) {
                f.setAccessible(true);
                try {
                    if (f.getType().equals(String[].class)) {
                        f.set(o, newIndices.toArray(new String[0]));
                    } else {
                        f.set(o, firstIndex);
                    }
                    res[0] = true;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    logger.error("could not find index or indices field to replace: " + e.getMessage() + " and then " + e.getMessage());
                }
            }
            return null;
        });
        return res[0];
    }
}

