/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.utils;

import com.google.common.collect.Sets;
import java.util.regex.Pattern;
import tech.beshu.ror.utils.MatcherWithWildcards;

public class RCUtils {
    public static final String LOCALHOST = "127.0.0.1";
    private static final Pattern localhostRe = Pattern.compile("^(127(\\.\\d+){1,3}|[0:]+1)$");
    private static MatcherWithWildcards readRequestMatcher = new MatcherWithWildcards(Sets.newHashSet((Object[])new String[]{"cluster:monitor/*", "cluster:*get*", "cluster:*search*", "indices:admin/aliases/exists", "indices:admin/aliases/get", "indices:admin/exists*", "indices:admin/get*", "indices:admin/mappings/fields/get*", "indices:admin/mappings/get*", "indices:admin/refresh*", "indices:admin/types/exists", "indices:admin/validate/*", "indices:data/read/*", "cluster:admin/*/get", "cluster:admin/*/status", "cluster:monitor/ccr/follow_info"}));

    public static boolean isReadRequest(String action) {
        return readRequestMatcher.match(action);
    }

    public static boolean isLocalHost(String remoteHost) {
        return localhostRe.matcher(remoteHost).find();
    }
}

