/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.utils;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import tech.beshu.ror.utils.MatcherWithWildcards;

public class MatcherWithWildcardsAndNegations {
    private MatcherWithWildcards positivePatterns;
    private MatcherWithWildcards negativePatterns;

    public MatcherWithWildcardsAndNegations(Set<String> patterns) {
        Map<Boolean, List<String>> fieldLists = patterns.stream().collect(Collectors.partitioningBy(f -> f.startsWith("~")));
        MatcherWithWildcards m = new MatcherWithWildcards(Sets.newHashSet((Iterable)fieldLists.get(false)));
        this.positivePatterns = m.getMatchers().isEmpty() ? null : m;
        m = new MatcherWithWildcards(Sets.newHashSet((Iterable)fieldLists.get(true).stream().map(x -> x.substring(1, x.length())).collect(Collectors.toSet())));
        this.negativePatterns = m.getMatchers().isEmpty() ? null : m;
    }

    public boolean match(String fieldName) {
        if (this.negativePatterns != null && this.negativePatterns.match(fieldName)) {
            return false;
        }
        return this.positivePatterns == null || this.positivePatterns.match(fieldName);
    }

    public Set<String> filter(Set<String> haystack) {
        if (haystack == null) {
            return Collections.emptySet();
        }
        HashSet filtered = Sets.newHashSet();
        for (String hs : haystack) {
            if (!this.match(hs)) continue;
            filtered.add(hs);
        }
        return filtered;
    }
}

