/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.utils;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MatcherWithWildcards {
    private static Set<String> empty = new HashSet<String>(0);
    private final Set<String> matchers;
    private List<String[]> patternsList = new LinkedList<String[]>();

    public MatcherWithWildcards(Set<String> patterns) {
        this.matchers = patterns;
        for (String p : patterns) {
            if (p == null) continue;
            this.patternsList.add(p.split("\\*+", -1));
        }
    }

    private static boolean miniglob(String[] pattern, String line) {
        if (pattern.length == 0) {
            return Strings.isNullOrEmpty((String)line);
        }
        if (pattern.length == 1) {
            return line.equals(pattern[0]);
        }
        if (!line.startsWith(pattern[0])) {
            return false;
        }
        int idx = pattern[0].length();
        for (int i = 1; i < pattern.length - 1; ++i) {
            String patternTok = pattern[i];
            int nextIdx = line.indexOf(patternTok, idx);
            if (nextIdx < 0) {
                return false;
            }
            idx = nextIdx + patternTok.length();
        }
        return line.endsWith(pattern[pattern.length - 1]);
    }

    public Set<String> getMatchers() {
        return this.matchers;
    }

    public boolean match(String haystack) {
        if (haystack == null) {
            return false;
        }
        for (String[] p : this.patternsList) {
            if (!MatcherWithWildcards.miniglob(p, haystack)) continue;
            return true;
        }
        return false;
    }

    public boolean match(boolean remoteClusterAware, String haystack) {
        return remoteClusterAware ? this.matchRemoteClusterAware(haystack) : this.match(haystack);
    }

    public Set<String> filter(boolean remoteClusterAware, Set<String> haystack) {
        return remoteClusterAware ? this.filterRemoteClusterAware(haystack) : this.filter(haystack);
    }

    public boolean matchRemoteClusterAware(String haystack) {
        if (haystack == null) {
            return false;
        }
        boolean remoteClusterRequested = haystack.contains(":");
        for (String[] p : this.patternsList) {
            if (!remoteClusterRequested && Arrays.asList(p).contains(":") || !MatcherWithWildcards.miniglob(p, haystack)) continue;
            return true;
        }
        return false;
    }

    public Set<String> filter(Set<String> haystack) {
        if (haystack == null) {
            return empty;
        }
        HashSet filtered = Sets.newHashSet();
        for (String hs : haystack) {
            if (!this.match(hs)) continue;
            filtered.add(hs);
        }
        return filtered;
    }

    public Set<String> matchingMatchers(Set<String> haystack) {
        if (haystack == null) {
            return empty;
        }
        HashSet filtered = Sets.newHashSet();
        for (String hs : haystack) {
            for (String m : this.matchers) {
                if (!new MatcherWithWildcards(Sets.newHashSet((Object[])new String[]{m})).match(hs)) continue;
                filtered.add(m);
            }
        }
        return filtered;
    }

    public Set<String> filterRemoteClusterAware(Set<String> haystack) {
        if (haystack == null) {
            return empty;
        }
        HashSet filtered = Sets.newHashSet();
        for (String hs : haystack) {
            if (!this.matchRemoteClusterAware(hs)) continue;
            filtered.add(hs);
        }
        return filtered;
    }
}

