/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

public class FilterTransient
implements Serializable {
    private static final long serialVersionUID = -8866625802695512997L;
    private final String _filter;

    private FilterTransient(String filter) {
        this._filter = filter;
    }

    public static FilterTransient createFromFilter(String filter) {
        return new FilterTransient(filter);
    }

    public static FilterTransient deserialize(String userTransientEncoded) {
        FilterTransient filterTransient = null;
        if (userTransientEncoded == null) {
            return filterTransient;
        }
        try {
            byte[] data = Base64.getDecoder().decode(userTransientEncoded);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            Object o = ois.readObject();
            if (o instanceof FilterTransient) {
                filterTransient = (FilterTransient)o;
            }
            ois.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't extract filterTransient from threadContext.");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Couldn't extract filterTransient from threadContext.");
        }
        return filterTransient;
    }

    public String getFilter() {
        return this._filter;
    }

    public String toString() {
        return "{ FILTER: " + this._filter + "}";
    }

    public String serialize() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            oos.close();
        }
        catch (IOException e) {
            return null;
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

