/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.shims.request;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import tech.beshu.ror.shims.request.RequestHandlingException;
import tech.beshu.ror.utils.MatcherWithWildcards;

public interface RequestInfoShim {
    public String extractType();

    public Integer getContentLength();

    default public Set<String> getExpandedIndices(Set<String> ixsSet) {
        if (this.involvesIndices()) {
            Set<String> all = this.extractAllIndicesAndAliases().stream().flatMap(e -> {
                HashSet aliases = Sets.newHashSet((Iterable)((Iterable)e.getValue()));
                aliases.add(e.getKey());
                return aliases.stream();
            }).collect(Collectors.toSet());
            return new MatcherWithWildcards(ixsSet).filter(all);
        }
        throw new RequestHandlingException("can'g expand indices of a request that does not involve indices: " + this.extractAction());
    }

    public Set<String> extractIndexMetadata(String var1);

    public Long extractTaskId();

    public Integer extractContentLength();

    public String extractContent();

    public String extractMethod();

    public String extractURI();

    public Set<String> extractIndices();

    public Set<String> extractSnapshots();

    public void writeSnapshots(Set<String> var1);

    public Set<String> extractRepositories();

    public void writeRepositories(Set<String> var1);

    public String extractAction();

    public Map<String, String> extractRequestHeaders();

    public String extractRemoteAddress();

    public String extractLocalAddress();

    public String extractId();

    public void writeIndices(Set<String> var1);

    public void writeResponseHeaders(Map<String, String> var1);

    public Set<Map.Entry<String, Set<String>>> extractAllIndicesAndAliases();

    public boolean involvesIndices();

    public boolean extractIsReadRequest();

    public boolean extractIsAllowedForDLS();

    public boolean extractIsCompositeRequest();

    public void writeToThreadContextHeaders(Map<String, String> var1);

    public boolean extractHasRemoteClusters();
}

