/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.shims.es;

import java.util.HashMap;
import tech.beshu.ror.Constants;
import tech.beshu.ror.settings.BasicSettings;
import tech.beshu.ror.shims.es.ESContext;
import tech.beshu.ror.shims.es.ESShutdownObservable;
import tech.beshu.ror.shims.es.ESVersion;
import tech.beshu.ror.shims.es.LoggerShim;

public abstract class AbstractESContext
implements ESContext {
    public static ESShutdownObservable shutDownObservable;
    private HashMap<Class<?>, LoggerShim> loggerCache = new HashMap(128);

    protected AbstractESContext() {
        if (shutDownObservable == null) {
            shutDownObservable = new ESShutdownObservable(this);
        }
    }

    @Override
    public ESShutdownObservable getShutDownObservable() {
        return shutDownObservable;
    }

    @Override
    public LoggerShim logger(Class<?> clazz) {
        LoggerShim shim = this.loggerCache.get(clazz);
        if (shim != null) {
            return shim;
        }
        shim = this.mkLogger(clazz);
        if (this.loggerCache.size() > Constants.CACHE_WATERMARK) {
            shim.error("Possible logger cache leak, we hit the watermark of " + Constants.CACHE_WATERMARK + ", now cache size=" + this.loggerCache.size());
        }
        this.loggerCache.put(clazz, shim);
        return shim;
    }

    protected abstract LoggerShim mkLogger(Class<?> var1);

    @Override
    public abstract RuntimeException rorException(String var1);

    @Override
    public abstract ESVersion getVersion();

    @Override
    public abstract BasicSettings getSettings();
}

