/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.settings;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import tech.beshu.ror.shims.es.LoggerShim;

public class SettingsUtils {
    private static final Gson gson = new Gson();
    private static Yaml yamlDumper;
    private static Yaml yamlLoader;

    public static String map2yaml(Map<String, ?> map) {
        return yamlDumper.dump(map);
    }

    public static String extractYAMLfromJSONStorage(String jsonWrappedYAML) {
        String[] s = new String[1];
        AccessController.doPrivileged(() -> {
            s[0] = (String)((Map)gson.fromJson(jsonWrappedYAML, Map.class)).get("settings");
            return null;
        });
        return s[0];
    }

    public static Map<String, ?> yaml2Map(String s, LoggerShim logger) {
        Map[] m = new Map[1];
        AccessController.doPrivileged(() -> {
            try {
                m[0] = (Map)yamlDumper.load(s);
            }
            catch (Exception e) {
                logger.error("Cannot parse YAML: " + e.getClass().getSimpleName() + ":" + e.getMessage() + "\n " + s, e);
            }
            return null;
        });
        return m[0];
    }

    private static String map2Json(Map<String, ?> m) {
        String[] jsonToCommit = new String[1];
        AccessController.doPrivileged(() -> {
            jsonToCommit[0] = gson.toJson((Object)m);
            return null;
        });
        return jsonToCommit[0];
    }

    public static String toJsonStorage(String yaml) {
        yamlLoader.load(yaml);
        HashMap tmpMap = Maps.newHashMap();
        tmpMap.put("settings", yaml);
        return SettingsUtils.map2Json(tmpMap);
    }

    static {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setExplicitEnd(false);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.AUTO);
        dumperOptions.setIndent(2);
        dumperOptions.setWidth(360);
        dumperOptions.setCanonical(false);
        dumperOptions.setPrettyFlow(false);
        dumperOptions.setExplicitStart(false);
        yamlLoader = yamlDumper = new Yaml(dumperOptions);
    }
}

