/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.settings;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import tech.beshu.ror.settings.SettingsObservable;
import tech.beshu.ror.shims.es.ESContext;
import tech.beshu.ror.shims.es.LoggerShim;

public class SettingsPoller {
    private final SettingsObservable obs;
    private final ESContext context;
    private final Integer subsequentAttemptsIntervalSeconds;
    private final Boolean forever;
    private final CompletableFuture<Void> result = new CompletableFuture();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private Integer intervalSeconds;

    public SettingsPoller(SettingsObservable obs, ESContext context, Integer intervalSeconds, Integer subsequentAttemptsIntervalSeconds, Boolean forever) {
        this.obs = obs;
        this.context = context;
        this.intervalSeconds = intervalSeconds;
        this.subsequentAttemptsIntervalSeconds = subsequentAttemptsIntervalSeconds;
        this.forever = forever;
        context.getShutDownObservable().addObserver((o, arg) -> {
            context.logger(this.getClass()).info("Shutting down settings poller executor...");
            if (!this.executor.isShutdown()) {
                this.executor.shutdown();
            }
        });
    }

    public void poll() {
        LoggerShim logger = this.context.logger(this.getClass());
        Runnable job = () -> {
            if (this.obs.isClusterReady()) {
                logger.debug("[CLUSTERWIDE SETTINGS] Cluster is ready!");
                this.result.complete(null);
                try {
                    this.obs.refreshFromIndex();
                }
                catch (Exception e) {
                    if (e.getMessage().equals("no settings found in index")) {
                        logger.info("[CLUSTERWIDE SETTINGS] Settings not found in index .readonlyrest, defaulting to local node setting...");
                        this.result.complete(null);
                    }
                    this.result.complete(null);
                    logger.error("error", e);
                    throw e;
                }
            } else {
                logger.info("[CLUSTERWIDE SETTINGS] Cluster not ready...");
            }
        };
        if (System.getProperty("com.readonlyrest.reloadsettingsonboot") == null) {
            ScheduledFuture<?> scheduledJob = this.executor.scheduleWithFixedDelay(job, this.intervalSeconds.intValue(), this.intervalSeconds.intValue(), TimeUnit.SECONDS);
            this.result.thenAccept(_x -> {
                if (!this.forever.booleanValue()) {
                    logger.info("[CLUSTERWIDE SETTINGS] Stopping cluster poller..");
                    scheduledJob.cancel(false);
                    this.executor.shutdown();
                    return;
                }
                this.intervalSeconds = this.subsequentAttemptsIntervalSeconds;
                scheduledJob.cancel(false);
                this.executor.scheduleWithFixedDelay(job, this.subsequentAttemptsIntervalSeconds.intValue(), this.subsequentAttemptsIntervalSeconds.intValue(), TimeUnit.SECONDS);
            });
        } else {
            logger.info("Skipping settings index poller...");
        }
    }
}

