/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.settings;

import com.google.common.util.concurrent.FutureCallback;
import java.nio.file.Path;
import java.util.Observable;
import tech.beshu.ror.settings.BasicSettings;
import tech.beshu.ror.settings.RawSettings;
import tech.beshu.ror.settings.SettingsMalformedException;
import tech.beshu.ror.settings.SettingsPoller;
import tech.beshu.ror.shims.es.ESContext;
import tech.beshu.ror.shims.es.ESVersion;
import tech.beshu.ror.shims.es.LoggerShim;

public abstract class SettingsObservable
extends Observable {
    public static final String SETTINGS_NOT_FOUND_MESSAGE = "no settings found in index";
    protected RawSettings current;
    private boolean printedInfo = false;

    protected abstract Path getConfigPath();

    protected abstract boolean isClusterReady();

    protected abstract LoggerShim getLogger();

    protected abstract RawSettings getFromIndex();

    protected abstract void writeToIndex(RawSettings var1, FutureCallback var2);

    public RawSettings getCurrent() {
        return this.current;
    }

    public RawSettings getFromFile() {
        this.getLogger().info("reading settings from file " + this.getConfigPath().toAbsolutePath());
        return BasicSettings.fromFile(this.getLogger(), this.getConfigPath(), this.current.asMap()).getRaw();
    }

    public void refreshFromIndex() {
        try {
            this.getLogger().debug("[CLUSTERWIDE SETTINGS] checking index..");
            RawSettings fromIndex = this.getFromIndex();
            if (!fromIndex.asMap().equals(this.current.asMap())) {
                this.updateSettings(fromIndex);
                this.getLogger().info("[CLUSTERWIDE SETTINGS] good settings found in index, overriding local YAML file");
            }
        }
        catch (Throwable t) {
            if (SETTINGS_NOT_FOUND_MESSAGE.equals(t.getMessage())) {
                if (!this.printedInfo) {
                    this.getLogger().info("[CLUSTERWIDE SETTINGS] index settings not found. Will keep on using the local YAML file. Learn more about clusterwide settings at https://readonlyrest.com/pro.html ");
                }
                this.printedInfo = true;
            }
            t.printStackTrace();
        }
    }

    public void forceRefresh() {
        this.setChanged();
        this.notifyObservers();
    }

    public void refreshFromStringAndPersist(RawSettings newSettings, FutureCallback fut) {
        RawSettings oldSettings = this.current;
        this.current = newSettings;
        try {
            this.forceRefresh();
            this.writeToIndex(newSettings, fut);
        }
        catch (Throwable t) {
            this.current = oldSettings;
            throw new SettingsMalformedException(t.getMessage());
        }
    }

    public void pollForIndex(ESContext context) {
        if (context.getVersion().before(ESVersion.V_5_0_0)) {
            return;
        }
        new SettingsPoller(this, context, 1, 5, true).poll();
    }

    private void updateSettings(RawSettings newSettings) {
        this.current = newSettings;
        this.setChanged();
        this.notifyObservers();
    }
}

