/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.settings;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import tech.beshu.ror.com.jayway.jsonpath.DocumentContext;
import tech.beshu.ror.com.jayway.jsonpath.JsonPath;
import tech.beshu.ror.com.jayway.jsonpath.Predicate;
import tech.beshu.ror.settings.SettingsMalformedException;
import tech.beshu.ror.settings.SettingsUtils;
import tech.beshu.ror.shims.es.LoggerShim;

public class RawSettings {
    private final Map<String, ?> raw;
    private final DocumentContext jpathContext;
    private final String rawYaml;
    private final LoggerShim logger;

    public RawSettings(String rawYaml, LoggerShim logger) {
        this.logger = logger;
        this.rawYaml = RawSettings.replaceEnvVars(rawYaml);
        this.raw = SettingsUtils.yaml2Map(rawYaml, logger);
        if (this.raw == null) {
            throw new SettingsMalformedException("Received null ROR settings: " + this.raw);
        }
        this.jpathContext = JsonPath.parse(this.raw);
    }

    public RawSettings(Map<String, ?> raw, LoggerShim logger) {
        this.logger = logger;
        this.rawYaml = RawSettings.replaceEnvVars(SettingsUtils.map2yaml(raw));
        this.raw = SettingsUtils.yaml2Map(this.rawYaml, logger);
        if (raw == null) {
            throw new SettingsMalformedException("Received null ROR settings: " + raw);
        }
        this.jpathContext = JsonPath.parse(this.raw);
    }

    private static String replaceEnvVars(String rawYaml) {
        String out = rawYaml;
        for (String key : System.getenv().keySet()) {
            out = out.replaceAll(Pattern.quote("${" + key + "}"), System.getenv(key));
        }
        return out;
    }

    static RawSettings fromMap(Map<String, ?> r, LoggerShim logger) {
        String syntheticYaml = SettingsUtils.map2yaml(r);
        return new RawSettings(syntheticYaml, logger);
    }

    public LoggerShim getLogger() {
        return this.logger;
    }

    public <T> Optional<T> opt(String attr) {
        Object val;
        try {
            val = this.jpathContext.read("$." + attr, new Predicate[0]);
        }
        catch (Exception e) {
            val = null;
        }
        return Optional.ofNullable(val);
    }

    public <T> T req(String attr) {
        Object val;
        try {
            val = this.jpathContext.read("$." + attr, new Predicate[0]);
        }
        catch (Exception e) {
            val = null;
        }
        if (val == null) {
            throw new SettingsMalformedException("Could not find required attribute '" + attr + "' in file " + Joiner.on((String)",").withKeyValueSeparator(":").join(this.raw));
        }
        return (T)val;
    }

    public Optional<Boolean> booleanOpt(String attr) {
        return this.opt(attr).map(x -> {
            if (x instanceof String) {
                return Boolean.parseBoolean((String)x);
            }
            return (Boolean)x;
        });
    }

    public Optional<String> stringOpt(String attr) {
        return this.opt(attr);
    }

    public String stringReq(String attr) {
        String s = (String)this.req(attr);
        return s;
    }

    public Optional<List<?>> notEmptyListOpt(String attr) {
        return this.opt(attr).flatMap(obj -> ((List)obj).isEmpty() ? Optional.empty() : Optional.of((List)obj));
    }

    public RawSettings inner(String attr) {
        return new RawSettings((Map)this.req(attr), this.logger);
    }

    public Optional<RawSettings> innerOpt(String attr) {
        return this.opt(attr).map(r -> RawSettings.fromMap((Map)r, this.logger));
    }

    public Map<String, ?> asMap() {
        return this.raw;
    }

    public String yaml() {
        return this.rawYaml;
    }

    public String toString() {
        return this.rawYaml;
    }
}

