/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.settings;

import com.google.common.base.Strings;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import tech.beshu.ror.Constants;
import tech.beshu.ror.settings.RawSettings;
import tech.beshu.ror.settings.SettingsUtils;
import tech.beshu.ror.shims.es.LoggerShim;
import tech.beshu.ror.utils.ReflecUtils;

public class BasicSettings {
    public static final String ROR_YAML_SETTINGS_PATH = System.getProperty("com.readonlyrest.settings.file.path");
    public static final String ATTRIBUTE_NAME = "readonlyrest";
    public static final String ATTRIBUTE_ENABLE = "enable";
    public static final String ATTRIBUTE_FORBIDDEN_RESPONSE = "response_if_req_forbidden";
    public static final String AUDIT_COLLECTOR = "audit_collector";
    public static final String CUSTOM_AUDIT_SERIALIZER = "audit_serializer";
    public static final String CACHE_HASHING_ALGO = "cache_hashing_algo";
    public static final String PREFIX_SSL_HTTP = "ssl.";
    public static final String PREFIX_SSL_INTERNODE = "ssl_internode.";
    public static final String ATTRIBUTE_SSL_KEYSTORE_FILE = "keystore_file";
    public static final String ATTRIBUTE_SSL_KEYSTORE_PASS = "keystore_pass";
    public static final String ATTRIBUTE_SSL_KEY_PASS = "key_pass";
    public static final String ATTRIBUTE_SSL_KEY_ALIAS = "key_alias";
    public static final String ATTRIBUTE_SSL_ALLOWED_CIPHERS = "allowed_ciphers";
    public static final String ATTRIBUTE_SSL_ALLOWED_PROTOCOLS = "allowed_protocols";
    public static final String ATTRIBUTE_SSL_CLIENT_VERIFICATION = "verification";
    private static final String DEFAULT_FORBIDDEN_MESSAGE = "forbidden";
    private final boolean enable;
    private final String forbiddenMessage;
    private final Boolean auditCollector;
    private final RawSettings raw;
    private final Path configPath;
    private final RawSettings raw_global;
    private Optional<SSLSettings> sslHttpSettings;
    private Optional<SSLSettings> sslTxpSettings;

    public BasicSettings(RawSettings raw_global, Path configPath) {
        this.configPath = configPath;
        this.raw_global = raw_global;
        this.raw = raw_global.inner(ATTRIBUTE_NAME);
        this.forbiddenMessage = this.raw.stringOpt(ATTRIBUTE_FORBIDDEN_RESPONSE).orElse(DEFAULT_FORBIDDEN_MESSAGE);
        List blocksSettings = this.raw.notEmptyListOpt("access_control_rules").orElse(new ArrayList(0));
        this.enable = this.raw.booleanOpt(ATTRIBUTE_ENABLE).orElse(!blocksSettings.isEmpty());
        this.auditCollector = this.raw.booleanOpt(AUDIT_COLLECTOR).orElse(false);
        try {
            this.sslHttpSettings = Optional.of(new SSLSettings(this.raw, PREFIX_SSL_HTTP));
        }
        catch (Exception e) {
            this.sslHttpSettings = Optional.empty();
        }
        try {
            this.sslTxpSettings = Optional.of(new SSLSettings(this.raw, PREFIX_SSL_INTERNODE));
        }
        catch (Exception e) {
            this.sslTxpSettings = Optional.empty();
        }
    }

    private static String slurpFile(LoggerShim logger, String filePath) {
        String[] slurped = new String[1];
        AccessController.doPrivileged(() -> {
            try {
                slurped[0] = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
                logger.debug("Read data from " + filePath);
            }
            catch (Throwable t) {
                logger.info("Could not find settings in " + filePath + " (" + t.getMessage() + ")");
            }
            return null;
        });
        return slurped[0];
    }

    public static BasicSettings fromFileObj(LoggerShim logger, Path configPath, Object settingsObject) {
        logger.debug("reading settings path (file obj) " + configPath);
        if (!Strings.isNullOrEmpty((String)ROR_YAML_SETTINGS_PATH)) {
            logger.info("overriding  settings path to " + ROR_YAML_SETTINGS_PATH);
            configPath = Paths.get(ROR_YAML_SETTINGS_PATH, new String[0]);
        }
        return BasicSettings.fromFile(logger, configPath, (Map)ReflecUtils.invokeMethodCached(settingsObject, settingsObject.getClass(), "getAsStructuredMap"));
    }

    public static BasicSettings fromFile(LoggerShim logger, Path configPath, Map<String, ?> fallback) {
        logger.debug("reading settings path (file obj) " + configPath);
        if (!Strings.isNullOrEmpty((String)ROR_YAML_SETTINGS_PATH)) {
            logger.info("overriding settings  path to " + ROR_YAML_SETTINGS_PATH);
            configPath = Paths.get(ROR_YAML_SETTINGS_PATH, new String[0]);
        }
        String baseConfigDirPath = configPath.toAbsolutePath().toString();
        String rorSettingsFilePath = Constants.makeAbsolutePath("readonlyrest.yml", baseConfigDirPath);
        String s4s = BasicSettings.slurpFile(logger, rorSettingsFilePath);
        try {
            if (SettingsUtils.yaml2Map(s4s, logger).containsKey(ATTRIBUTE_NAME)) {
                return new BasicSettings(new RawSettings(s4s, logger), configPath);
            }
            return new BasicSettings(new RawSettings(fallback, logger), configPath);
        }
        catch (Throwable t) {
            try {
                logger.error("cannot parse settings file ", t);
                return new BasicSettings(new RawSettings(fallback, logger), configPath);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                throw t2;
            }
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public String getForbiddenMessage() {
        return this.forbiddenMessage;
    }

    public Boolean isAuditorCollectorEnabled() {
        return this.auditCollector;
    }

    public RawSettings getRaw() {
        return this.raw_global;
    }

    public Map<String, ?> asMap() {
        return this.raw.asMap();
    }

    public Optional<SSLSettings> getSslHttpSettings() {
        return this.sslHttpSettings;
    }

    public Optional<SSLSettings> getSslInternodeSettings() {
        return this.sslTxpSettings;
    }

    public class SSLSettings {
        private final boolean sslEnabled;
        private Optional<String> keystorePass;
        private Optional<String> keyPass;
        private Optional<List<String>> allowedSSLCiphers = Optional.empty();
        private Optional<List<String>> allowedSSLProtocols = Optional.empty();
        private Optional<String> keyAlias;
        private String keystoreFile;
        private Optional<Boolean> verifyClient;

        public SSLSettings(RawSettings raw, String prefix) {
            Optional<RawSettings> sslSettingsOpt = raw.innerOpt(prefix.replaceFirst(".$", ""));
            Optional<Boolean> sslEnableOpt = raw.booleanOpt(prefix + BasicSettings.ATTRIBUTE_ENABLE);
            Optional<String> ksOpt = raw.stringOpt(prefix + BasicSettings.ATTRIBUTE_SSL_KEYSTORE_FILE);
            this.sslEnabled = sslSettingsOpt.isPresent() && (!sslEnableOpt.isPresent() || !((Object)sslEnableOpt.get()).equals(false)) && ksOpt.isPresent();
            if (this.sslEnabled) {
                this.keystoreFile = Constants.makeAbsolutePath(raw.stringReq(prefix + BasicSettings.ATTRIBUTE_SSL_KEYSTORE_FILE), BasicSettings.this.configPath.toAbsolutePath().toString());
                this.keyAlias = raw.stringOpt(prefix + BasicSettings.ATTRIBUTE_SSL_KEY_ALIAS);
                this.keyPass = raw.stringOpt(prefix + BasicSettings.ATTRIBUTE_SSL_KEY_PASS);
                this.keystorePass = raw.stringOpt(prefix + BasicSettings.ATTRIBUTE_SSL_KEYSTORE_PASS);
                this.allowedSSLCiphers = raw.opt(prefix + BasicSettings.ATTRIBUTE_SSL_ALLOWED_CIPHERS);
                this.allowedSSLProtocols = raw.opt(prefix + BasicSettings.ATTRIBUTE_SSL_ALLOWED_PROTOCOLS);
                this.verifyClient = raw.booleanOpt(prefix + BasicSettings.ATTRIBUTE_SSL_CLIENT_VERIFICATION);
            }
        }

        public Optional<List<String>> getAllowedSSLCiphers() {
            return this.allowedSSLCiphers;
        }

        public Optional<List<String>> getAllowedSSLProtocols() {
            return this.allowedSSLProtocols;
        }

        public Boolean isSSLEnabled() {
            return this.sslEnabled;
        }

        public Optional<String> getKeystorePass() {
            return this.keystorePass;
        }

        public String getKeystoreFile() {
            return this.keystoreFile;
        }

        public Optional<String> getKeyPass() {
            return this.keyPass;
        }

        public Optional<String> getKeyAlias() {
            return this.keyAlias;
        }

        public Optional<Boolean> isClientAuthVerify() {
            return this.verifyClient;
        }
    }
}

