/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.acl.request;

import cats.Show;
import cats.Show$;
import cats.implicits$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.types.string;
import io.circe.Error;
import java.io.Serializable;
import java.net.HttpCookie;
import java.time.Clock;
import java.time.Instant;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import org.apache.logging.log4j.scala.Logging;
import org.apache.logging.log4j.spi.ExtendedLogger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Try$;
import tech.beshu.ror.acl.domain;
import tech.beshu.ror.acl.domain$Header$Name$;
import tech.beshu.ror.acl.domain$User$Id$;
import tech.beshu.ror.acl.request.RequestContext;
import tech.beshu.ror.acl.request.RorSessionCookie;
import tech.beshu.ror.acl.request.RorSessionCookie$ExtractingError$Absent$;
import tech.beshu.ror.acl.request.RorSessionCookie$ExtractingError$Expired$;
import tech.beshu.ror.acl.request.RorSessionCookie$ExtractingError$Invalid$;
import tech.beshu.ror.acl.request.RorSessionCookie$Signature$;
import tech.beshu.ror.acl.request.RorSessionCookie$coders$;
import tech.beshu.ror.acl.show$logs$;
import tech.beshu.ror.acl.utils.UuidProvider;

public final class RorSessionCookie$
implements Logging,
scala.Serializable {
    public static RorSessionCookie$ MODULE$;
    private final String rorCookieName;
    private final Show<RorSessionCookie> rorCookieShow;
    private final ExtendedLogger logger;

    static {
        new RorSessionCookie$();
    }

    public ExtendedLogger logger() {
        return this.logger;
    }

    public void org$apache$logging$log4j$scala$Logging$_setter_$logger_$eq(ExtendedLogger x$1) {
        this.logger = x$1;
    }

    private String rorCookieName() {
        return this.rorCookieName;
    }

    public Either<RorSessionCookie.ExtractingError, RorSessionCookie> extractFrom(RequestContext context, domain.LoggedUser user, Clock clock, UuidProvider uuidProvider) {
        return this.extractRorHttpCookie(context).toRight((Function0 & Serializable & scala.Serializable)() -> RorSessionCookie$ExtractingError$Absent$.MODULE$).flatMap((Function1 & Serializable & scala.Serializable)httpCookie -> MODULE$.parseRorSessionCookieAndSignature((HttpCookie)httpCookie).left().map((Function1 & Serializable & scala.Serializable)x$1 -> RorSessionCookie$ExtractingError$Invalid$.MODULE$).map((Function1 & Serializable & scala.Serializable)cookieAndSignature -> {
            Tuple2 tuple2 = cookieAndSignature;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RorSessionCookie cookie = (RorSessionCookie)tuple2._1();
            String signature = ((RorSessionCookie.Signature)tuple2._2()).value();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)cookie, (Object)new RorSessionCookie.Signature(signature));
            Tuple3 tuple32 = tuple3;
            Tuple2 x$2 = (Tuple2)tuple32._1();
            RorSessionCookie cookie2 = (RorSessionCookie)tuple32._2();
            String signature2 = ((RorSessionCookie.Signature)tuple32._3()).value();
            return new Tuple2(cookieAndSignature, (Object)x$2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$4;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
                throw new MatchError((Object)tuple22);
            }
            RorSessionCookie cookie = (RorSessionCookie)tuple2._1();
            String signature = ((RorSessionCookie.Signature)tuple2._2()).value();
            Either either = MODULE$.checkCookie(cookie, signature, user, clock, uuidProvider).map((Function1 & Serializable & scala.Serializable)_ -> cookie);
            return either;
        }));
    }

    public domain.Header toSessionHeader(RorSessionCookie cookie, UuidProvider uuidProvider) {
        return new domain.Header(domain$Header$Name$.MODULE$.setCookie(), (String)((Refined)string.NonEmptyString$.MODULE$.unsafeFrom((Object)new StringBuilder(1).append(this.rorCookieName()).append("=").append(RorSessionCookie$coders$.MODULE$.encoder().apply((Object)new Tuple2((Object)cookie, (Object)new RorSessionCookie.Signature(RorSessionCookie$Signature$.MODULE$.sign(cookie, uuidProvider)))).noSpaces()).toString())).value());
    }

    private Option<HttpCookie> extractRorHttpCookie(RequestContext context) {
        return context.headers().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RorSessionCookie$.$anonfun$extractRorHttpCookie$1(x$5))).flatMap((Function1 & Serializable & scala.Serializable)h -> MODULE$.parseCookie(h.value())).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)RorSessionCookie$.$anonfun$extractRorHttpCookie$4(x$7))));
    }

    private Either<Error, Tuple2<RorSessionCookie, String>> parseRorSessionCookieAndSignature(HttpCookie httpCookie) {
        return io.circe.parser.package$.MODULE$.parse((String)Option$.MODULE$.apply((Object)httpCookie.getValue()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).flatMap((Function1 & Serializable & scala.Serializable)json -> RorSessionCookie$coders$.MODULE$.decoder().decodeJson(json).map((Function1 & Serializable & scala.Serializable)decoded -> decoded));
    }

    private Either<RorSessionCookie.ExtractingError, BoxedUnit> checkCookie(RorSessionCookie cookie, String signature, domain.LoggedUser loggedUser, Clock clock, UuidProvider uuidProvider) {
        Left left;
        Instant now = Instant.now(clock);
        if (domain$User$Id$.MODULE$.eqId().neqv((Object)cookie.userId(), (Object)loggedUser.id())) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(this.logger(), Level.WARN, null, (CharSequence)new StringBuilder(98).append("this cookie does not belong to the user logged in as. Found in Cookie: ").append(implicits$.MODULE$.toShow((Object)cookie.userId(), show$logs$.MODULE$.userIdShow()).show()).append(" whilst in Authentication: ").append(implicits$.MODULE$.toShow((Object)loggedUser.id(), show$logs$.MODULE$.userIdShow()).show()).toString(), null);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            left = package$.MODULE$.Left().apply((Object)RorSessionCookie$ExtractingError$Invalid$.MODULE$);
        } else if (!RorSessionCookie$Signature$.MODULE$.check$extension(signature, cookie, uuidProvider)) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(this.logger(), Level.WARN, null, (CharSequence)new StringBuilder(30).append("'").append(signature).append("' is not valid signature for ").append(implicits$.MODULE$.toShow((Object)cookie, this.rorCookieShow()).show()).toString(), null);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            left = package$.MODULE$.Left().apply((Object)RorSessionCookie$ExtractingError$Invalid$.MODULE$);
        } else if (now.isAfter(cookie.expiryDate())) {
            BoxedUnit boxedUnit;
            if (this.logger().isEnabled(Level.INFO)) {
                Logger$.MODULE$.logMessage$extension1(this.logger(), Level.INFO, null, (CharSequence)new StringBuilder(50).append("cookie was present but expired. Found: ").append(cookie.expiryDate()).append(", now it's ").append(now).toString(), null);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            left = package$.MODULE$.Left().apply((Object)RorSessionCookie$ExtractingError$Expired$.MODULE$);
        } else {
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        return left;
    }

    private Option<List<HttpCookie>> parseCookie(String value) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> HttpCookie.parse(value)).map((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).toList()).toOption();
    }

    private Show<RorSessionCookie> rorCookieShow() {
        return this.rorCookieShow;
    }

    public RorSessionCookie apply(domain.User.Id userId, Instant expiryDate) {
        return new RorSessionCookie(userId, expiryDate);
    }

    public Option<Tuple2<domain.User.Id, Instant>> unapply(RorSessionCookie x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.userId(), (Object)x$0.expiryDate()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$extractRorHttpCookie$1(domain.Header x$5) {
        return domain$Header$Name$.MODULE$.eqName().eqv((Object)x$5.name(), (Object)domain$Header$Name$.MODULE$.cookie());
    }

    public static final /* synthetic */ boolean $anonfun$extractRorHttpCookie$4(HttpCookie x$7) {
        return implicits$.MODULE$.catsKernelStdOrderForString().eqv((Object)x$7.getName(), (Object)MODULE$.rorCookieName());
    }

    private RorSessionCookie$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.rorCookieName = "ReadonlyREST_Session";
        this.rorCookieShow = Show$.MODULE$.show((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(16).append("user: ").append(c.userId().value()).append(", expiry: ").append(c.expiryDate().toEpochMilli()).toString());
    }
}

