/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.acl.helpers;

import cats.data.NonEmptyList;
import java.io.Serializable;
import java.time.Clock;
import monix.eval.Task;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import tech.beshu.ror.acl.factory.AsyncHttpClientsFactory;
import tech.beshu.ror.acl.factory.CoreFactory;
import tech.beshu.ror.acl.factory.CoreSettings;
import tech.beshu.ror.acl.helpers.RorEngineFactory;
import tech.beshu.ror.acl.logging.AclLoggingDecorator;
import tech.beshu.ror.acl.logging.AuditSink;
import tech.beshu.ror.acl.logging.AuditingTool;
import tech.beshu.ror.acl.utils.JavaEnvVarsProvider$;
import tech.beshu.ror.acl.utils.JavaUuidProvider$;
import tech.beshu.ror.acl.utils.StaticVariablesResolver;
import tech.beshu.ror.acl.utils.UuidProvider;
import tech.beshu.ror.settings.SettingsMalformedException;

public final class RorEngineFactory$ {
    public static RorEngineFactory$ MODULE$;
    private final Clock clock;
    private final UuidProvider uuidProvider;
    private final StaticVariablesResolver resolver;
    private final CoreFactory aclFactory;

    static {
        new RorEngineFactory$();
    }

    private Clock clock() {
        return this.clock;
    }

    private UuidProvider uuidProvider() {
        return this.uuidProvider;
    }

    private StaticVariablesResolver resolver() {
        return this.resolver;
    }

    private CoreFactory aclFactory() {
        return this.aclFactory;
    }

    public synchronized Task<RorEngineFactory.Engine> reload(AuditSink auditSink, String settingsYaml) {
        AsyncHttpClientsFactory httpClientsFactory = new AsyncHttpClientsFactory();
        return this.aclFactory().createCoreFrom(settingsYaml, httpClientsFactory).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either either = x0$1;
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    NonEmptyList errors = (NonEmptyList)left.value();
                    String errorsMessage = errors.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.reason()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        String string2;
                        CoreFactory.AclCreationError.Reason reason = x0$2;
                        if (reason instanceof CoreFactory.AclCreationError.Reason.Message) {
                            String msg;
                            CoreFactory.AclCreationError.Reason.Message message = (CoreFactory.AclCreationError.Reason.Message)reason;
                            string2 = msg = message.value();
                        } else if (reason instanceof CoreFactory.AclCreationError.Reason.MalformedValue) {
                            CoreFactory.AclCreationError.Reason.MalformedValue malformedValue = (CoreFactory.AclCreationError.Reason.MalformedValue)reason;
                            String yamlString = malformedValue.value();
                            string2 = new StringBuilder(18).append("Malformed config: ").append(yamlString).toString();
                        } else {
                            throw new MatchError((Object)reason);
                        }
                        return string2;
                    }).toList().mkString("Errors:\n", "\n", "");
                    throw new SettingsMalformedException(errorsMessage);
                }
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            CoreSettings coreSettings = (CoreSettings)right.value();
            RorEngineFactory.Engine engine = new RorEngineFactory.Engine(new AclLoggingDecorator(coreSettings.aclEngine(), (Option<AuditingTool>)coreSettings.auditingSettings().map((Function1 & Serializable & scala.Serializable)x$1 -> new AuditingTool((AuditingTool.Settings)x$1, auditSink, MODULE$.clock()))), coreSettings.aclStaticContext(), httpClientsFactory);
            return engine;
        });
    }

    private RorEngineFactory$() {
        MODULE$ = this;
        this.clock = Clock.systemUTC();
        this.uuidProvider = JavaUuidProvider$.MODULE$;
        this.resolver = new StaticVariablesResolver(JavaEnvVarsProvider$.MODULE$);
        this.aclFactory = new CoreFactory(this.clock(), this.uuidProvider(), this.resolver());
    }
}

