/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.acl.blocks.rules;

import eu.timepit.refined.api.Refined;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import monix.eval.Task;
import monix.eval.Task$;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import org.apache.logging.log4j.scala.Logging;
import org.apache.logging.log4j.spi.ExtendedLogger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import tech.beshu.ror.acl.blocks.BlockContext;
import tech.beshu.ror.acl.blocks.rules.Rule;
import tech.beshu.ror.acl.blocks.rules.Rule$RuleResult$Rejected$;
import tech.beshu.ror.acl.blocks.rules.SessionMaxIdleRule$;
import tech.beshu.ror.acl.domain;
import tech.beshu.ror.acl.request.RequestContext;
import tech.beshu.ror.acl.request.RorSessionCookie;
import tech.beshu.ror.acl.request.RorSessionCookie$;
import tech.beshu.ror.acl.request.RorSessionCookie$ExtractingError$Absent$;
import tech.beshu.ror.acl.request.RorSessionCookie$ExtractingError$Expired$;
import tech.beshu.ror.acl.request.RorSessionCookie$ExtractingError$Invalid$;
import tech.beshu.ror.acl.utils.UuidProvider;

@ScalaSignature(bytes="\u0006\u0001\t5d\u0001B\u0013'\u0001MB\u0001\"\u0018\u0001\u0003\u0006\u0004%\tA\u0018\u0005\n\u0003G\u0004!\u0011!Q\u0001\n}C!\"!:\u0001\u0005\u0003\u0005\u000b1BAt\u0011)\t\u0019\u0010\u0001B\u0001B\u0003-\u0011Q\u001f\u0005\u0007K\u0002!\tA!\u0001\t\u000f\u001d\u0004!\u0019!C!Q\"1Q\u000e\u0001Q\u0001\n%DqA!\u0004\u0001\t\u0003\u0012y\u0001C\u0004\u0003D\u0001!IA!\u0012\t\u000f\t\r\u0004\u0001\"\u0003\u0003f\u001d)\u0011M\nE\u0001E\u001a)QE\nE\u0001I\")Q\r\u0004C\u0001M\"9q\r\u0004b\u0001\n\u0003A\u0007BB7\rA\u0003%\u0011N\u0002\u0003o\u0019\t{\u0007\u0002\u0003<\u0011\u0005+\u0007I\u0011A<\t\u0013\u0005M\u0002C!E!\u0002\u0013A\bBB3\u0011\t\u0003\t)\u0004C\u0005\u0002>A\t\t\u0011\"\u0001\u0002@!I\u00111\t\t\u0012\u0002\u0013\u0005\u0011Q\t\u0005\n\u00037\u0002\u0012\u0011!C!\u0003;B\u0011\"a\u001c\u0011\u0003\u0003%\t!!\u001d\t\u0013\u0005e\u0004#!A\u0005\u0002\u0005m\u0004\"CAD!\u0005\u0005I\u0011IAE\u0011%\t9\nEA\u0001\n\u0003\tI\nC\u0005\u0002$B\t\t\u0011\"\u0011\u0002&\"I\u0011q\u0015\t\u0002\u0002\u0013\u0005\u0013\u0011\u0016\u0005\n\u0003W\u0003\u0012\u0011!C!\u0003[;\u0011\"!-\r\u0003\u0003E\t!a-\u0007\u00119d\u0011\u0011!E\u0001\u0003kCa!Z\u0010\u0005\u0002\u0005\r\u0007\"CAT?\u0005\u0005IQIAU\u0011%\t)mHA\u0001\n\u0003\u000b9\rC\u0005\u0002L~\t\t\u0011\"!\u0002N\"I\u0011\u0011\\\u0010\u0002\u0002\u0013%\u00111\u001c\u0002\u0013'\u0016\u001c8/[8o\u001b\u0006D\u0018\n\u001a7f%VdWM\u0003\u0002(Q\u0005)!/\u001e7fg*\u0011\u0011FK\u0001\u0007E2|7m[:\u000b\u0005-b\u0013aA1dY*\u0011QFL\u0001\u0004e>\u0014(BA\u00181\u0003\u0015\u0011Wm\u001d5v\u0015\u0005\t\u0014\u0001\u0002;fG\"\u001c\u0001a\u0005\u0003\u0001ii\u0002\u0006CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\r\u0005\u0002<\u001b:\u0011Ah\u0013\b\u0003{)s!AP%\u000f\u0005}BeB\u0001!H\u001d\t\teI\u0004\u0002C\u000b6\t1I\u0003\u0002Ee\u00051AH]8pizJ\u0011!M\u0005\u0003_AJ!!\f\u0018\n\u0005-b\u0013BA\u0015+\u0013\t9\u0003&\u0003\u0002MM\u0005!!+\u001e7f\u0013\tquJA\u0006SK\u001e,H.\u0019:Sk2,'B\u0001''!\t\t6,D\u0001S\u0015\t94K\u0003\u0002U+\u0006)An\\45U*\u0011akV\u0001\bY><w-\u001b8h\u0015\tA\u0016,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0006\u0019qN]4\n\u0005q\u0013&a\u0002'pO\u001eLgnZ\u0001\tg\u0016$H/\u001b8hgV\tq\f\u0005\u0002a!9\u0011AhC\u0001\u0013'\u0016\u001c8/[8o\u001b\u0006D\u0018\n\u001a7f%VdW\r\u0005\u0002d\u00195\tae\u0005\u0002\ri\u00051A(\u001b8jiz\"\u0012AY\u0001\u0005]\u0006lW-F\u0001j!\tQ7N\u0004\u0002d\u0017&\u0011An\u0014\u0002\u0005\u001d\u0006lW-A\u0003oC6,\u0007E\u0001\u0005TKR$\u0018N\\4t'\u0011\u0001B\u0007]:\u0011\u0005U\n\u0018B\u0001:7\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u000e;\n\u0005U4$\u0001D*fe&\fG.\u001b>bE2,\u0017AD:fgNLwN\\'bq&#G.Z\u000b\u0002qB9\u00110!\u0002\u0002\n\u0005eQ\"\u0001>\u000b\u0005md\u0018aA1qS*\u0011QP`\u0001\be\u00164\u0017N\\3e\u0015\ry\u0018\u0011A\u0001\bi&lW\r]5u\u0015\t\t\u0019!\u0001\u0002fk&\u0019\u0011q\u0001>\u0003\u000fI+g-\u001b8fIB!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0007\u0005Ma'\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u0006\u0002\u000e\tqa)\u001b8ji\u0016$UO]1uS>t\u0007\u0003BA\u000e\u0003[qA!!\b\u0002*9!\u0011qDA\u0014\u001d\u0011\t\t#!\n\u000f\u0007\t\u000b\u0019#\u0003\u0002\u0002\u0004%\u0019q0!\u0001\n\u0005ut\u0018bAA\u0016y\u00069a.^7fe&\u001c\u0017\u0002BA\u0018\u0003c\u0011\u0001\u0002U8tSRLg/\u001a\u0006\u0004\u0003Wa\u0018aD:fgNLwN\\'bq&#G.\u001a\u0011\u0015\t\u0005]\u00121\b\t\u0004\u0003s\u0001R\"\u0001\u0007\t\u000bY\u001c\u0002\u0019\u0001=\u0002\t\r|\u0007/\u001f\u000b\u0005\u0003o\t\t\u0005C\u0004w)A\u0005\t\u0019\u0001=\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\t\u0016\u0004q\u0006%3FAA&!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Uc'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0017\u0002P\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0006\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\t1\fgn\u001a\u0006\u0003\u0003S\nAA[1wC&!\u0011QNA2\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u000f\t\u0004k\u0005U\u0014bAA<m\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QPAB!\r)\u0014qP\u0005\u0004\u0003\u00033$aA!os\"I\u0011Q\u0011\r\u0002\u0002\u0003\u0007\u00111O\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005-\u0005CBAG\u0003'\u000bi(\u0004\u0002\u0002\u0010*\u0019\u0011\u0011\u0013\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0016\u0006=%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a'\u0002\"B\u0019Q'!(\n\u0007\u0005}eGA\u0004C_>dW-\u00198\t\u0013\u0005\u0015%$!AA\u0002\u0005u\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005M\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002\u001c\u0006=\u0006\"CAC;\u0005\u0005\t\u0019AA?\u0003!\u0019V\r\u001e;j]\u001e\u001c\bcAA\u001d?M!q$a.t!\u001d\tI,a0y\u0003oi!!a/\u000b\u0007\u0005uf'A\u0004sk:$\u0018.\\3\n\t\u0005\u0005\u00171\u0018\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAAZ\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\t9$!3\t\u000bY\u0014\u0003\u0019\u0001=\u0002\u000fUt\u0017\r\u001d9msR!\u0011qZAk!\u0011)\u0014\u0011\u001b=\n\u0007\u0005MgG\u0001\u0004PaRLwN\u001c\u0005\n\u0003/\u001c\u0013\u0011!a\u0001\u0003o\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005u\u0007\u0003BA1\u0003?LA!!9\u0002d\t1qJ\u00196fGR\f\u0011b]3ui&twm\u001d\u0011\u0002\u000b\rdwnY6\u0011\t\u0005%\u0018q^\u0007\u0003\u0003WTA!!<\u0002h\u0005!A/[7f\u0013\u0011\t\t0a;\u0003\u000b\rcwnY6\u0002\u0019U,\u0018\u000e\u001a)s_ZLG-\u001a:\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a?+\u0003\u0015)H/\u001b7t\u0013\u0011\ty0!?\u0003\u0019U+\u0018\u000e\u001a)s_ZLG-\u001a:\u0015\t\t\r!1\u0002\u000b\u0007\u0005\u000b\u00119A!\u0003\u0011\u0005\r\u0004\u0001bBAs\u000b\u0001\u000f\u0011q\u001d\u0005\b\u0003g,\u00019AA{\u0011\u0015iV\u00011\u0001`\u0003\u0015\u0019\u0007.Z2l)\u0019\u0011\tBa\n\u00038A1!1\u0003B\u000f\u0005Ci!A!\u0006\u000b\t\t]!\u0011D\u0001\u0005KZ\fGN\u0003\u0002\u0003\u001c\u0005)Qn\u001c8jq&!!q\u0004B\u000b\u0005\u0011!\u0016m]6\u0011\u0007m\u0012\u0019#C\u0002\u0003&=\u0013!BU;mKJ+7/\u001e7u\u0011\u001d\u0011I\u0003\u0003a\u0001\u0005W\taB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0003.\tMRB\u0001B\u0018\u0015\r\u0011\tDK\u0001\be\u0016\fX/Z:u\u0013\u0011\u0011)Da\f\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\"9!\u0011\b\u0005A\u0002\tm\u0012\u0001\u00042m_\u000e\\7i\u001c8uKb$\b\u0003\u0002B\u001f\u0005\u007fi\u0011\u0001K\u0005\u0004\u0005\u0003B#\u0001\u0004\"m_\u000e\\7i\u001c8uKb$\u0018AD2iK\u000e\\7i\\8lS\u00164uN\u001d\u000b\t\u0005\u000f\u0012iEa\u0018\u0003bI1!\u0011\n9t\u0005C1aAa\u0013\u0001\u0001\t\u001d#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004b\u0002B(\u0013\u0001\u0007!\u0011K\u0001\u0005kN,'\u000f\u0005\u0003\u0003T\tecb\u0001 \u0003V%\u0019!q\u000b\u0016\u0002\r\u0011|W.Y5o\u0013\u0011\u0011YF!\u0018\u0003\u00151{wmZ3e+N,'OC\u0002\u0003X)BqA!\u000b\n\u0001\u0004\u0011Y\u0003C\u0004\u0003:%\u0001\rAa\u000f\u0002\u001b9,w/\u0012=qSJLH)\u0019;f+\t\u00119\u0007\u0005\u0003\u0002j\n%\u0014\u0002\u0002B6\u0003W\u0014q!\u00138ti\u0006tG\u000f")
public class SessionMaxIdleRule
implements Rule.RegularRule,
Logging {
    private final Settings settings;
    private final Clock clock;
    private final UuidProvider uuidProvider;
    private final String name;
    private final ExtendedLogger logger;

    public ExtendedLogger logger() {
        return this.logger;
    }

    public void org$apache$logging$log4j$scala$Logging$_setter_$logger_$eq(ExtendedLogger x$1) {
        this.logger = x$1;
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Task<Rule.RuleResult> check(RequestContext requestContext, BlockContext blockContext) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Rule.RuleResult ruleResult;
            Option<domain.LoggedUser> option = blockContext.loggedUser();
            if (option instanceof Some) {
                Some some = (Some)option;
                domain.LoggedUser user = (domain.LoggedUser)some.value();
                ruleResult = (Rule.RuleResult)this.checkCookieFor(user, requestContext, blockContext);
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().isEnabled(Level.WARN)) {
                    Logger$.MODULE$.logMessage$extension1(this.logger(), Level.WARN, null, (CharSequence)"Cannot state the logged in user, put the authentication rule on top of the block!", null);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                ruleResult = Rule$RuleResult$Rejected$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            return ruleResult;
        });
    }

    private Product checkCookieFor(domain.LoggedUser user, RequestContext requestContext, BlockContext blockContext) {
        Rule.RuleResult ruleResult;
        Left left;
        RorSessionCookie.ExtractingError extractingError;
        Either<RorSessionCookie.ExtractingError, RorSessionCookie> either = RorSessionCookie$.MODULE$.extractFrom(requestContext, user, this.clock, this.uuidProvider);
        boolean bl = either instanceof Right ? true : either instanceof Left && RorSessionCookie$ExtractingError$Absent$.MODULE$.equals(extractingError = (RorSessionCookie.ExtractingError)(left = (Left)either).value());
        if (bl) {
            RorSessionCookie newCookie = new RorSessionCookie(user.id(), this.newExpiryDate());
            ruleResult = new Rule.RuleResult.Fulfilled(blockContext.withAddedResponseHeader(RorSessionCookie$.MODULE$.toSessionHeader(newCookie, this.uuidProvider)));
        } else {
            Left left2;
            RorSessionCookie.ExtractingError extractingError2;
            Left left3;
            RorSessionCookie.ExtractingError extractingError3;
            boolean bl2 = either instanceof Left && RorSessionCookie$ExtractingError$Invalid$.MODULE$.equals(extractingError3 = (RorSessionCookie.ExtractingError)(left3 = (Left)either).value()) ? true : either instanceof Left && RorSessionCookie$ExtractingError$Expired$.MODULE$.equals(extractingError2 = (RorSessionCookie.ExtractingError)(left2 = (Left)either).value());
            if (bl2) {
                ruleResult = Rule$RuleResult$Rejected$.MODULE$;
            } else {
                throw new MatchError(either);
            }
        }
        return ruleResult;
    }

    private Instant newExpiryDate() {
        return Instant.now(this.clock).plusMillis(this.settings().sessionMaxIdle().toMillis());
    }

    public SessionMaxIdleRule(Settings settings, Clock clock, UuidProvider uuidProvider) {
        this.settings = settings;
        this.clock = clock;
        this.uuidProvider = uuidProvider;
        Logging.$init$((Logging)this);
        this.name = SessionMaxIdleRule$.MODULE$.name();
    }

    public static final class Settings
    implements Product,
    scala.Serializable {
        private final FiniteDuration sessionMaxIdle;

        public FiniteDuration sessionMaxIdle() {
            return this.sessionMaxIdle;
        }

        public Settings copy(FiniteDuration sessionMaxIdle) {
            return new Settings(sessionMaxIdle);
        }

        public FiniteDuration copy$default$1() {
            return this.sessionMaxIdle();
        }

        public String productPrefix() {
            return "Settings";
        }

        public int productArity() {
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return new Refined((Object)this.sessionMaxIdle());
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Settings;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Settings)) return false;
            boolean bl = true;
            if (!bl) return false;
            Settings settings = (Settings)x$1;
            FiniteDuration finiteDuration = this.sessionMaxIdle();
            FiniteDuration finiteDuration2 = settings.sessionMaxIdle();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public Settings(FiniteDuration sessionMaxIdle) {
            this.sessionMaxIdle = sessionMaxIdle;
            Product.$init$((Product)this);
        }
    }
}

