/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import tech.beshu.ror.utils.MatcherWithWildcards;

public class ZeroKnowledgeMatchFilter {
    public static boolean alterIndicesIfNecessaryAndCheck(Set<String> indices, MatcherWithWildcards matcher, Consumer<Set<String>> indicesWriter) {
        Set<String> modifiedIndices = ZeroKnowledgeMatchFilter.alterIndicesIfNecessary(indices, matcher);
        if (modifiedIndices != null) {
            if (modifiedIndices.isEmpty()) {
                return false;
            }
            indicesWriter.accept(modifiedIndices);
        }
        return true;
    }

    public static Set<String> alterIndicesIfNecessary(Set<String> indices, MatcherWithWildcards matcher) {
        boolean shouldReplace = false;
        if ((indices = Sets.newHashSet(indices)).contains("_all")) {
            indices.remove("_all");
            indices.add("*");
        }
        if (indices.size() == 0) {
            indices.add("*");
        }
        if (indices.contains("*")) {
            if (indices.size() == 1) {
                return matcher.getMatchers().stream().collect(Collectors.toSet());
            }
            shouldReplace = true;
            indices.remove("*");
            indices.addAll(matcher.getMatchers().stream().collect(Collectors.toSet()));
        }
        HashSet newIndices = Sets.newHashSet();
        for (String i : indices) {
            if (matcher.match(i)) {
                newIndices.add(i);
                continue;
            }
            MatcherWithWildcards revMatcher = new MatcherWithWildcards(Sets.newHashSet((Object[])new String[]{i}));
            Set<String> matched = revMatcher.filter(matcher.getMatchers());
            if (matched.isEmpty()) continue;
            newIndices.addAll(matched);
            shouldReplace = true;
        }
        if (shouldReplace || !Sets.symmetricDifference((Set)newIndices, (Set)indices).isEmpty()) {
            return newIndices;
        }
        return null;
    }
}

