/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror;

import com.google.common.base.Joiner;
import java.io.FileInputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Base64;
import javax.net.ssl.SSLEngine;
import tech.beshu.ror.settings.BasicSettings;
import tech.beshu.ror.settings.SettingsMalformedException;
import tech.beshu.ror.shims.es.LoggerShim;

public class SSLCertParser {
    private final SSLContextCreator creator;
    private final LoggerShim logger;

    public SSLCertParser(BasicSettings.SSLSettings settings, LoggerShim logger, SSLContextCreator creator) {
        this.creator = creator;
        this.logger = logger;
        this.createContext(settings);
    }

    public static boolean validateProtocolAndCiphers(SSLEngine eng, LoggerShim logger, BasicSettings.SSLSettings basicSettings) {
        try {
            Object[] defaultProtocols = eng.getEnabledProtocols();
            logger.info("ROR SSL: Available ciphers: " + Joiner.on((String)",").join((Object[])eng.getEnabledCipherSuites()));
            basicSettings.getAllowedSSLCiphers().map(x -> x.toArray(new String[x.size()])).ifPresent(p -> {
                eng.setEnabledCipherSuites((String[])p);
                logger.info("ROR SSL: Restricting to ciphers: " + Joiner.on((String)",").join((Object[])eng.getEnabledCipherSuites()));
            });
            logger.info("ROR SSL: Available SSL protocols: " + Joiner.on((String)",").join(defaultProtocols));
            basicSettings.getAllowedSSLProtocols().map(x -> x.toArray(new String[x.size()])).ifPresent(p -> {
                eng.setEnabledProtocols((String[])p);
                logger.info("ROR SSL: Restricting to SSL protocols: " + Joiner.on((String)",").join((Object[])eng.getEnabledProtocols()));
            });
            return true;
        }
        catch (Exception e) {
            logger.error("ROR SSL: cannot validate SSL protocols and ciphers! " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createContext(BasicSettings.SSLSettings settings) {
        if (!settings.isSSLEnabled().booleanValue()) {
            this.logger.info("ROR SSL: SSL is disabled");
            return;
        }
        this.logger.info("ROR SSL: attempting with JKS keystore..");
        try {
            String sslKeyAlias;
            char[] keyStorePassBa = null;
            if (settings.getKeystorePass().isPresent()) {
                keyStorePassBa = settings.getKeystorePass().get().toCharArray();
            }
            char[] finKeystoerPassBa = keyStorePassBa;
            KeyStore ks = KeyStore.getInstance("JKS");
            AccessController.doPrivileged(() -> {
                try {
                    String keystoreFile = settings.getKeystoreFile();
                    ks.load(new FileInputStream(keystoreFile), finKeystoerPassBa);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            });
            char[] keyPassBa = null;
            if (settings.getKeyPass().isPresent()) {
                keyPassBa = settings.getKeyPass().get().toCharArray();
            }
            if (!settings.getKeyAlias().isPresent()) {
                if (!ks.aliases().hasMoreElements()) throw new SettingsMalformedException("No alias found, therefore key found in keystore!");
                String inferredAlias = ks.aliases().nextElement();
                this.logger.info("ROR SSL: ssl.key_alias not configured, took first alias in keystore: " + inferredAlias);
                sslKeyAlias = inferredAlias;
            } else {
                sslKeyAlias = settings.getKeyAlias().get();
            }
            Key key = ks.getKey(sslKeyAlias, keyPassBa);
            if (key == null) {
                throw new SettingsMalformedException("Private key not found in keystore for alias: " + sslKeyAlias);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("---BEGIN PRIVATE KEY---\n");
            sb.append(Base64.getEncoder().encodeToString(key.getEncoded()));
            sb.append("\n");
            sb.append("---END PRIVATE KEY---");
            String privateKey = sb.toString();
            this.logger.info("ROR SSL: Discovered key from JKS");
            Certificate[] cchain = ks.getCertificateChain(sslKeyAlias);
            sb = new StringBuilder();
            for (Certificate c : cchain) {
                sb.append("-----BEGIN CERTIFICATE-----\n");
                sb.append(Base64.getEncoder().encodeToString(c.getEncoded()));
                sb.append("\n");
                sb.append("-----END CERTIFICATE-----\n");
            }
            String certChain = sb.toString();
            this.logger.info("ROR SSL: Discovered cert chain from JKS");
            AccessController.doPrivileged(() -> {
                this.creator.mkSSLContext(certChain, privateKey);
                return null;
            });
            return;
        }
        catch (Throwable t) {
            this.logger.error("ROR SSL: Failed to load SSL certs and keys from JKS Keystore! " + t.getClass().getSimpleName() + ": " + t.getMessage(), t);
            if (t instanceof AccessControlException) {
                this.logger.error("ROR SSL: Check the JKS Keystore path is correct: " + settings.getKeystoreFile());
            }
            t.printStackTrace();
        }
    }

    public static interface SSLContextCreator {
        public void mkSSLContext(String var1, String var2);
    }
}

