/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.ControlArgument;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPCompare
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = 719069383330181184L;
    private ArgumentParser parser;
    private ControlArgument bindControls;
    private ControlArgument compareControls;

    public static void main(String[] args) {
        ResultCode resultCode = LDAPCompare.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        LDAPCompare ldapCompare = new LDAPCompare(outStream, errStream);
        return ldapCompare.runTool(args);
    }

    public LDAPCompare(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "ldapcompare";
    }

    @Override
    public String getToolDescription() {
        return "Process compare operations in LDAP directory server.";
    }

    @Override
    public String getToolVersion() {
        return "4.0.9";
    }

    @Override
    public int getMinTrailingArguments() {
        return 2;
    }

    @Override
    public int getMaxTrailingArguments() {
        return -1;
    }

    @Override
    public String getTrailingArgumentsPlaceholder() {
        return "attr:value dn1 [dn2 [dn3 [...]]]";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        String description = "Information about a control to include in the bind request.";
        this.bindControls = new ControlArgument(null, "bindControl", false, 0, null, description);
        this.bindControls.addLongIdentifier("bind-control", true);
        parser.addArgument(this.bindControls);
        description = "Information about a control to include in compare requests.";
        this.compareControls = new ControlArgument(Character.valueOf('J'), "control", false, 0, null, description);
        parser.addArgument(this.compareControls);
    }

    @Override
    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
        List<String> trailingArgs = this.parser.getTrailingArguments();
        if (trailingArgs.size() < 2) {
            throw new ArgumentException("At least two trailing argument must be provided to specify the assertion criteria in the form 'attr:value'.  All additional trailing arguments must be the DNs of the entries against which to perform the compare.");
        }
        Iterator<String> argIterator = trailingArgs.iterator();
        String ava = argIterator.next();
        if (ava.indexOf(58) < 1) {
            throw new ArgumentException("The first trailing argument value must specify the assertion criteria in the form 'attr:value'.");
        }
        while (argIterator.hasNext()) {
            String arg = argIterator.next();
            try {
                new DN(arg);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new ArgumentException("Unable to parse trailing argument '" + arg + "' as a valid DN.", e);
            }
        }
    }

    @Override
    protected List<Control> getBindControls() {
        return this.bindControls.getValues();
    }

    @Override
    public ResultCode doToolProcessing() {
        LDAPConnection connection;
        byte[] assertionValueBytes;
        List<String> trailingArguments = this.parser.getTrailingArguments();
        if (trailingArguments.isEmpty()) {
            this.err("No attribute value assertion was provided.");
            this.err(new Object[0]);
            this.err(this.parser.getUsageString(StaticUtils.TERMINAL_WIDTH_COLUMNS - 1));
            return ResultCode.PARAM_ERROR;
        }
        if (trailingArguments.size() == 1) {
            this.err("No target entry DNs were provided.");
            this.err(new Object[0]);
            this.err(this.parser.getUsageString(StaticUtils.TERMINAL_WIDTH_COLUMNS - 1));
            return ResultCode.PARAM_ERROR;
        }
        String avaString = trailingArguments.get(0);
        int colonPos = avaString.indexOf(58);
        if (colonPos <= 0) {
            this.err("Malformed attribute value assertion.");
            this.err(new Object[0]);
            this.err(this.parser.getUsageString(StaticUtils.TERMINAL_WIDTH_COLUMNS - 1));
            return ResultCode.PARAM_ERROR;
        }
        String attributeName = avaString.substring(0, colonPos);
        int doubleColonPos = avaString.indexOf("::");
        if (doubleColonPos == colonPos) {
            try {
                assertionValueBytes = Base64.decode(avaString.substring(colonPos + 2));
            }
            catch (ParseException pe) {
                this.err("Unable to base64-decode the assertion value:  ", pe.getMessage());
                this.err(new Object[0]);
                this.err(this.parser.getUsageString(StaticUtils.TERMINAL_WIDTH_COLUMNS - 1));
                return ResultCode.PARAM_ERROR;
            }
        } else {
            assertionValueBytes = StaticUtils.getBytes(avaString.substring(colonPos + 1));
        }
        try {
            connection = this.getConnection();
            this.out("Connected to ", connection.getConnectedAddress(), Character.valueOf(':'), connection.getConnectedPort());
        }
        catch (LDAPException le) {
            this.err("Error connecting to the directory server:  ", le.getMessage());
            return le.getResultCode();
        }
        ResultCode resultCode = ResultCode.SUCCESS;
        CompareRequest compareRequest = null;
        for (int i = 1; i < trailingArguments.size(); ++i) {
            block18: {
                String targetDN = trailingArguments.get(i);
                if (compareRequest == null) {
                    compareRequest = new CompareRequest(targetDN, attributeName, assertionValueBytes);
                    compareRequest.setControls(this.compareControls.getValues());
                } else {
                    compareRequest.setDN(targetDN);
                }
                try {
                    this.out("Processing compare request for entry ", targetDN);
                    CompareResult result = connection.compare(compareRequest);
                    if (result.compareMatched()) {
                        this.out("The compare operation matched.");
                    } else {
                        this.out("The compare operation did not match.");
                    }
                }
                catch (LDAPException le) {
                    resultCode = le.getResultCode();
                    this.err("An error occurred while processing the request:  ", le.getMessage());
                    this.err("Result Code:  ", le.getResultCode().intValue(), " (", le.getResultCode().getName(), Character.valueOf(')'));
                    if (le.getMatchedDN() != null) {
                        this.err("Matched DN:  ", le.getMatchedDN());
                    }
                    if (le.getReferralURLs() == null) break block18;
                    for (String url : le.getReferralURLs()) {
                        this.err("Referral URL:  ", url);
                    }
                }
            }
            this.out(new Object[0]);
        }
        connection.close();
        this.out(new Object[0]);
        this.out("Disconnected from the server");
        return resultCode;
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(1));
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "password", "givenName:John", "uid=jdoe,ou=People,dc=example,dc=com"};
        String description = "Attempt to determine whether the entry for user 'uid=jdoe,ou=People,dc=example,dc=com' has a value of 'John' for the givenName attribute.";
        examples.put(args, "Attempt to determine whether the entry for user 'uid=jdoe,ou=People,dc=example,dc=com' has a value of 'John' for the givenName attribute.");
        return examples;
    }
}

