/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.DisconnectHandler;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReferralConnector;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLSocketVerifier;
import com.unboundid.util.ssl.TrustAllSSLSocketVerifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPConnectionOptions {
    private static final String PROPERTY_PREFIX;
    public static final String PROPERTY_DEFAULT_ABANDON_ON_TIMEOUT;
    private static final boolean DEFAULT_ABANDON_ON_TIMEOUT;
    private static final boolean DEFAULT_AUTO_RECONNECT = false;
    public static final String PROPERTY_DEFAULT_BIND_WITH_DN_REQUIRES_PASSWORD;
    private static final boolean DEFAULT_BIND_WITH_DN_REQUIRES_PASSWORD;
    public static final String PROPERTY_DEFAULT_CAPTURE_CONNECT_STACK_TRACE;
    private static final boolean DEFAULT_CAPTURE_CONNECT_STACK_TRACE;
    public static final String PROPERTY_DEFAULT_FOLLOW_REFERRALS;
    private static final boolean DEFAULT_FOLLOW_REFERRALS;
    public static final String PROPERTY_DEFAULT_REFERRAL_HOP_LIMIT;
    private static final int DEFAULT_REFERRAL_HOP_LIMIT;
    public static final String PROPERTY_DEFAULT_USE_SCHEMA;
    private static final boolean DEFAULT_USE_SCHEMA;
    public static final String PROPERTY_DEFAULT_USE_POOLED_SCHEMA;
    private static final boolean DEFAULT_USE_POOLED_SCHEMA;
    public static final String PROPERTY_DEFAULT_POOLED_SCHEMA_TIMEOUT_MILLIS;
    private static final long DEFAULT_POOLED_SCHEMA_TIMEOUT_MILLIS = 3600000L;
    public static final String PROPERTY_DEFAULT_USE_KEEPALIVE;
    private static final boolean DEFAULT_USE_KEEPALIVE;
    public static final String PROPERTY_DEFAULT_USE_LINGER;
    private static final boolean DEFAULT_USE_LINGER;
    public static final String PROPERTY_DEFAULT_LINGER_TIMEOUT_SECONDS;
    private static final int DEFAULT_LINGER_TIMEOUT_SECONDS;
    public static final String PROPERTY_DEFAULT_USE_REUSE_ADDRESS;
    private static final boolean DEFAULT_USE_REUSE_ADDRESS;
    public static final String PROPERTY_DEFAULT_USE_SYNCHRONOUS_MODE;
    private static final boolean DEFAULT_USE_SYNCHRONOUS_MODE;
    public static final String PROPERTY_DEFAULT_USE_TCP_NODELAY;
    private static final boolean DEFAULT_USE_TCP_NODELAY;
    public static final String PROPERTY_DEFAULT_CONNECT_TIMEOUT_MILLIS;
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS;
    public static final String PROPERTY_DEFAULT_MAX_MESSAGE_SIZE_BYTES;
    private static final int DEFAULT_MAX_MESSAGE_SIZE_BYTES;
    public static final String PROPERTY_DEFAULT_RECEIVE_BUFFER_SIZE_BYTES;
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE_BYTES;
    public static final String PROPERTY_DEFAULT_SEND_BUFFER_SIZE_BYTES;
    private static final int DEFAULT_SEND_BUFFER_SIZE_BYTES;
    public static final String PROPERTY_DEFAULT_RESPONSE_TIMEOUT_MILLIS;
    public static final String PROPERTY_DEFAULT_ADD_RESPONSE_TIMEOUT_MILLIS;
    public static final String PROPERTY_DEFAULT_BIND_RESPONSE_TIMEOUT_MILLIS;
    public static final String PROPERTY_DEFAULT_COMPARE_RESPONSE_TIMEOUT_MILLIS;
    public static final String PROPERTY_DEFAULT_DELETE_RESPONSE_TIMEOUT_MILLIS;
    public static final String PROPERTY_DEFAULT_EXTENDED_RESPONSE_TIMEOUT_MILLIS;
    public static final String PROPERTY_DEFAULT_MODIFY_RESPONSE_TIMEOUT_MILLIS;
    public static final String PROPERTY_DEFAULT_MODIFY_DN_RESPONSE_TIMEOUT_MILLIS;
    public static final String PROPERTY_DEFAULT_SEARCH_RESPONSE_TIMEOUT_MILLIS;
    private static final long DEFAULT_RESPONSE_TIMEOUT_MILLIS;
    private static final Map<OperationType, Long> DEFAULT_RESPONSE_TIMEOUT_MILLIS_BY_OPERATION_TYPE;
    private static final Map<String, Long> DEFAULT_RESPONSE_TIMEOUT_MILLIS_BY_EXTENDED_OPERATION_TYPE;
    private static final boolean DEFAULT_ALLOW_CONCURRENT_SOCKET_FACTORY_USE;
    private static final SSLSocketVerifier DEFAULT_SSL_SOCKET_VERIFIER;
    private boolean abandonOnTimeout = DEFAULT_ABANDON_ON_TIMEOUT;
    private boolean allowConcurrentSocketFactoryUse;
    private boolean autoReconnect = false;
    private boolean bindWithDNRequiresPassword = DEFAULT_BIND_WITH_DN_REQUIRES_PASSWORD;
    private boolean captureConnectStackTrace = DEFAULT_CAPTURE_CONNECT_STACK_TRACE;
    private boolean followReferrals = DEFAULT_FOLLOW_REFERRALS;
    private boolean useKeepAlive = DEFAULT_USE_KEEPALIVE;
    private boolean useLinger = DEFAULT_USE_LINGER;
    private boolean useReuseAddress = DEFAULT_USE_REUSE_ADDRESS;
    private boolean usePooledSchema = DEFAULT_USE_POOLED_SCHEMA;
    private boolean useSchema = DEFAULT_USE_SCHEMA;
    private boolean useSynchronousMode = DEFAULT_USE_SYNCHRONOUS_MODE;
    private boolean useTCPNoDelay = DEFAULT_USE_TCP_NODELAY;
    private DisconnectHandler disconnectHandler = null;
    private int connectTimeoutMillis = DEFAULT_CONNECT_TIMEOUT_MILLIS;
    private int lingerTimeoutSeconds = DEFAULT_LINGER_TIMEOUT_SECONDS;
    private int maxMessageSizeBytes = DEFAULT_MAX_MESSAGE_SIZE_BYTES;
    private int receiveBufferSizeBytes;
    private int referralHopLimit = DEFAULT_REFERRAL_HOP_LIMIT;
    private int sendBufferSizeBytes;
    private long pooledSchemaTimeoutMillis = 3600000L;
    private long responseTimeoutMillis = DEFAULT_RESPONSE_TIMEOUT_MILLIS;
    private Map<OperationType, Long> responseTimeoutMillisByOperationType;
    private Map<String, Long> responseTimeoutMillisByExtendedOperationType;
    private ReferralConnector referralConnector = null;
    private SSLSocketVerifier sslSocketVerifier;
    private UnsolicitedNotificationHandler unsolicitedNotificationHandler = null;

    public LDAPConnectionOptions() {
        this.receiveBufferSizeBytes = DEFAULT_RECEIVE_BUFFER_SIZE_BYTES;
        this.sendBufferSizeBytes = DEFAULT_SEND_BUFFER_SIZE_BYTES;
        this.sslSocketVerifier = DEFAULT_SSL_SOCKET_VERIFIER;
        this.responseTimeoutMillisByOperationType = DEFAULT_RESPONSE_TIMEOUT_MILLIS_BY_OPERATION_TYPE;
        this.responseTimeoutMillisByExtendedOperationType = DEFAULT_RESPONSE_TIMEOUT_MILLIS_BY_EXTENDED_OPERATION_TYPE;
        this.allowConcurrentSocketFactoryUse = DEFAULT_ALLOW_CONCURRENT_SOCKET_FACTORY_USE;
    }

    public LDAPConnectionOptions duplicate() {
        LDAPConnectionOptions o = new LDAPConnectionOptions();
        o.abandonOnTimeout = this.abandonOnTimeout;
        o.allowConcurrentSocketFactoryUse = this.allowConcurrentSocketFactoryUse;
        o.autoReconnect = this.autoReconnect;
        o.bindWithDNRequiresPassword = this.bindWithDNRequiresPassword;
        o.captureConnectStackTrace = this.captureConnectStackTrace;
        o.followReferrals = this.followReferrals;
        o.useKeepAlive = this.useKeepAlive;
        o.useLinger = this.useLinger;
        o.useReuseAddress = this.useReuseAddress;
        o.usePooledSchema = this.usePooledSchema;
        o.useSchema = this.useSchema;
        o.useSynchronousMode = this.useSynchronousMode;
        o.useTCPNoDelay = this.useTCPNoDelay;
        o.connectTimeoutMillis = this.connectTimeoutMillis;
        o.lingerTimeoutSeconds = this.lingerTimeoutSeconds;
        o.maxMessageSizeBytes = this.maxMessageSizeBytes;
        o.pooledSchemaTimeoutMillis = this.pooledSchemaTimeoutMillis;
        o.responseTimeoutMillis = this.responseTimeoutMillis;
        o.referralConnector = this.referralConnector;
        o.referralHopLimit = this.referralHopLimit;
        o.disconnectHandler = this.disconnectHandler;
        o.unsolicitedNotificationHandler = this.unsolicitedNotificationHandler;
        o.receiveBufferSizeBytes = this.receiveBufferSizeBytes;
        o.sendBufferSizeBytes = this.sendBufferSizeBytes;
        o.sslSocketVerifier = this.sslSocketVerifier;
        o.responseTimeoutMillisByOperationType = this.responseTimeoutMillisByOperationType;
        o.responseTimeoutMillisByExtendedOperationType = this.responseTimeoutMillisByExtendedOperationType;
        return o;
    }

    @Deprecated
    public boolean autoReconnect() {
        return this.autoReconnect;
    }

    @Deprecated
    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public boolean bindWithDNRequiresPassword() {
        return this.bindWithDNRequiresPassword;
    }

    public void setBindWithDNRequiresPassword(boolean bindWithDNRequiresPassword) {
        this.bindWithDNRequiresPassword = bindWithDNRequiresPassword;
    }

    public boolean captureConnectStackTrace() {
        return this.captureConnectStackTrace;
    }

    public void setCaptureConnectStackTrace(boolean captureConnectStackTrace) {
        this.captureConnectStackTrace = captureConnectStackTrace;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public long getResponseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    public void setResponseTimeoutMillis(long responseTimeoutMillis) {
        this.responseTimeoutMillis = Math.max(0L, responseTimeoutMillis);
        this.responseTimeoutMillisByExtendedOperationType = Collections.emptyMap();
        EnumMap<OperationType, Long> newOperationTimeouts = new EnumMap<OperationType, Long>(OperationType.class);
        for (OperationType t : OperationType.values()) {
            newOperationTimeouts.put(t, this.responseTimeoutMillis);
        }
        this.responseTimeoutMillisByOperationType = Collections.unmodifiableMap(newOperationTimeouts);
    }

    public long getResponseTimeoutMillis(OperationType operationType) {
        return this.responseTimeoutMillisByOperationType.get((Object)operationType);
    }

    public void setResponseTimeoutMillis(OperationType operationType, long responseTimeoutMillis) {
        EnumMap<OperationType, Long> newOperationTimeouts = new EnumMap<OperationType, Long>(OperationType.class);
        newOperationTimeouts.putAll(this.responseTimeoutMillisByOperationType);
        newOperationTimeouts.put(operationType, Math.max(0L, responseTimeoutMillis));
        this.responseTimeoutMillisByOperationType = Collections.unmodifiableMap(newOperationTimeouts);
    }

    public long getExtendedOperationResponseTimeoutMillis(String requestOID) {
        Long timeout = this.responseTimeoutMillisByExtendedOperationType.get(requestOID);
        if (timeout == null) {
            return this.responseTimeoutMillisByOperationType.get((Object)OperationType.EXTENDED);
        }
        return timeout;
    }

    public void setExtendedOperationResponseTimeoutMillis(String requestOID, long responseTimeoutMillis) {
        HashMap<String, Long> newExtOpTimeouts = new HashMap<String, Long>(this.responseTimeoutMillisByExtendedOperationType);
        newExtOpTimeouts.put(requestOID, responseTimeoutMillis);
        this.responseTimeoutMillisByExtendedOperationType = Collections.unmodifiableMap(newExtOpTimeouts);
    }

    public boolean abandonOnTimeout() {
        return this.abandonOnTimeout;
    }

    public void setAbandonOnTimeout(boolean abandonOnTimeout) {
        this.abandonOnTimeout = abandonOnTimeout;
    }

    public boolean useKeepAlive() {
        return this.useKeepAlive;
    }

    public void setUseKeepAlive(boolean useKeepAlive) {
        this.useKeepAlive = useKeepAlive;
    }

    public boolean useLinger() {
        return this.useLinger;
    }

    public int getLingerTimeoutSeconds() {
        return this.lingerTimeoutSeconds;
    }

    public void setUseLinger(boolean useLinger, int lingerTimeoutSeconds) {
        this.useLinger = useLinger;
        this.lingerTimeoutSeconds = lingerTimeoutSeconds;
    }

    public boolean useReuseAddress() {
        return this.useReuseAddress;
    }

    public void setUseReuseAddress(boolean useReuseAddress) {
        this.useReuseAddress = useReuseAddress;
    }

    public boolean useSchema() {
        return this.useSchema;
    }

    public void setUseSchema(boolean useSchema) {
        this.useSchema = useSchema;
        if (useSchema) {
            this.usePooledSchema = false;
        }
    }

    public boolean usePooledSchema() {
        return this.usePooledSchema;
    }

    public void setUsePooledSchema(boolean usePooledSchema) {
        this.usePooledSchema = usePooledSchema;
        if (usePooledSchema) {
            this.useSchema = false;
        }
    }

    public long getPooledSchemaTimeoutMillis() {
        return this.pooledSchemaTimeoutMillis;
    }

    public void setPooledSchemaTimeoutMillis(long pooledSchemaTimeoutMillis) {
        this.pooledSchemaTimeoutMillis = Math.max(0L, pooledSchemaTimeoutMillis);
    }

    public boolean useSynchronousMode() {
        return this.useSynchronousMode;
    }

    public void setUseSynchronousMode(boolean useSynchronousMode) {
        this.useSynchronousMode = useSynchronousMode;
    }

    public boolean useTCPNoDelay() {
        return this.useTCPNoDelay;
    }

    public void setUseTCPNoDelay(boolean useTCPNoDelay) {
        this.useTCPNoDelay = useTCPNoDelay;
    }

    public boolean followReferrals() {
        return this.followReferrals;
    }

    public void setFollowReferrals(boolean followReferrals) {
        this.followReferrals = followReferrals;
    }

    public int getReferralHopLimit() {
        return this.referralHopLimit;
    }

    public void setReferralHopLimit(int referralHopLimit) {
        Validator.ensureTrue(referralHopLimit > 0, "LDAPConnectionOptions.referralHopLimit must be greater than 0.");
        this.referralHopLimit = referralHopLimit;
    }

    public ReferralConnector getReferralConnector() {
        return this.referralConnector;
    }

    public void setReferralConnector(ReferralConnector referralConnector) {
        this.referralConnector = referralConnector;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSizeBytes;
    }

    public void setMaxMessageSize(int maxMessageSizeBytes) {
        this.maxMessageSizeBytes = Math.max(0, maxMessageSizeBytes);
    }

    public DisconnectHandler getDisconnectHandler() {
        return this.disconnectHandler;
    }

    public void setDisconnectHandler(DisconnectHandler handler) {
        this.disconnectHandler = handler;
    }

    public UnsolicitedNotificationHandler getUnsolicitedNotificationHandler() {
        return this.unsolicitedNotificationHandler;
    }

    public void setUnsolicitedNotificationHandler(UnsolicitedNotificationHandler handler) {
        this.unsolicitedNotificationHandler = handler;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSizeBytes;
    }

    public void setReceiveBufferSize(int receiveBufferSizeBytes) {
        this.receiveBufferSizeBytes = Math.max(0, receiveBufferSizeBytes);
    }

    public int getSendBufferSize() {
        return this.sendBufferSizeBytes;
    }

    public void setSendBufferSize(int sendBufferSizeBytes) {
        this.sendBufferSizeBytes = Math.max(0, sendBufferSizeBytes);
    }

    public boolean allowConcurrentSocketFactoryUse() {
        return this.allowConcurrentSocketFactoryUse;
    }

    public void setAllowConcurrentSocketFactoryUse(boolean allowConcurrentSocketFactoryUse) {
        this.allowConcurrentSocketFactoryUse = allowConcurrentSocketFactoryUse;
    }

    public SSLSocketVerifier getSSLSocketVerifier() {
        return this.sslSocketVerifier;
    }

    public void setSSLSocketVerifier(SSLSocketVerifier sslSocketVerifier) {
        this.sslSocketVerifier = sslSocketVerifier == null ? DEFAULT_SSL_SOCKET_VERIFIER : sslSocketVerifier;
    }

    static boolean getSystemProperty(String propertyName, boolean defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue == null) {
            if (Debug.debugEnabled()) {
                Debug.debug(Level.FINE, DebugType.OTHER, "Using the default value of " + defaultValue + " for system " + "property '" + propertyName + "' that is not set.");
            }
            return defaultValue;
        }
        if (propertyValue.equalsIgnoreCase("true")) {
            if (Debug.debugEnabled()) {
                Debug.debug(Level.INFO, DebugType.OTHER, "Using value '" + propertyValue + "' set for system property '" + propertyName + "'.");
            }
            return true;
        }
        if (propertyValue.equalsIgnoreCase("false")) {
            if (Debug.debugEnabled()) {
                Debug.debug(Level.INFO, DebugType.OTHER, "Using value '" + propertyValue + "' set for system property '" + propertyName + "'.");
            }
            return false;
        }
        if (Debug.debugEnabled()) {
            Debug.debug(Level.WARNING, DebugType.OTHER, "Invalid value '" + propertyValue + "' set for system property '" + propertyName + "'.  The value was expected to be either " + "'true' or 'false'.  The default value of " + defaultValue + " will be used instead of the configured value.");
        }
        return defaultValue;
    }

    static int getSystemProperty(String propertyName, int defaultValue) {
        String propertyValueString = System.getProperty(propertyName);
        if (propertyValueString == null) {
            if (Debug.debugEnabled()) {
                Debug.debug(Level.FINE, DebugType.OTHER, "Using the default value of " + defaultValue + " for system " + "property '" + propertyName + "' that is not set.");
            }
            return defaultValue;
        }
        try {
            int propertyValueInt = Integer.parseInt(propertyValueString);
            if (Debug.debugEnabled()) {
                Debug.debug(Level.INFO, DebugType.OTHER, "Using value " + propertyValueInt + " set for system property '" + propertyName + "'.");
            }
            return propertyValueInt;
        }
        catch (Exception e) {
            if (Debug.debugEnabled()) {
                Debug.debugException(e);
                Debug.debug(Level.WARNING, DebugType.OTHER, "Invalid value '" + propertyValueString + "' set for system " + "property '" + propertyName + "'.  The value was expected " + "to be an integer.  The default value of " + defaultValue + "will be used instead of the configured value.", e);
            }
            return defaultValue;
        }
    }

    static Long getSystemProperty(String propertyName, Long defaultValue) {
        String propertyValueString = System.getProperty(propertyName);
        if (propertyValueString == null) {
            if (Debug.debugEnabled()) {
                Debug.debug(Level.FINE, DebugType.OTHER, "Using the default value of " + defaultValue + " for system " + "property '" + propertyName + "' that is not set.");
            }
            return defaultValue;
        }
        try {
            long propertyValueLong = Long.parseLong(propertyValueString);
            if (Debug.debugEnabled()) {
                Debug.debug(Level.INFO, DebugType.OTHER, "Using value " + propertyValueLong + " set for system property '" + propertyName + "'.");
            }
            return propertyValueLong;
        }
        catch (Exception e) {
            if (Debug.debugEnabled()) {
                Debug.debugException(e);
                Debug.debug(Level.WARNING, DebugType.OTHER, "Invalid value '" + propertyValueString + "' set for system " + "property '" + propertyName + "'.  The value was expected " + "to be a long.  The default value of " + defaultValue + "will be used instead of the configured value.", e);
            }
            return defaultValue;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("LDAPConnectionOptions(autoReconnect=");
        buffer.append(this.autoReconnect);
        buffer.append(", bindWithDNRequiresPassword=");
        buffer.append(this.bindWithDNRequiresPassword);
        buffer.append(", followReferrals=");
        buffer.append(this.followReferrals);
        if (this.followReferrals) {
            buffer.append(", referralHopLimit=");
            buffer.append(this.referralHopLimit);
        }
        if (this.referralConnector != null) {
            buffer.append(", referralConnectorClass=");
            buffer.append(this.referralConnector.getClass().getName());
        }
        buffer.append(", useKeepAlive=");
        buffer.append(this.useKeepAlive);
        buffer.append(", useLinger=");
        if (this.useLinger) {
            buffer.append("true, lingerTimeoutSeconds=");
            buffer.append(this.lingerTimeoutSeconds);
        } else {
            buffer.append("false");
        }
        buffer.append(", useReuseAddress=");
        buffer.append(this.useReuseAddress);
        buffer.append(", useSchema=");
        buffer.append(this.useSchema);
        buffer.append(", usePooledSchema=");
        buffer.append(this.usePooledSchema);
        buffer.append(", pooledSchemaTimeoutMillis=");
        buffer.append(this.pooledSchemaTimeoutMillis);
        buffer.append(", useSynchronousMode=");
        buffer.append(this.useSynchronousMode);
        buffer.append(", useTCPNoDelay=");
        buffer.append(this.useTCPNoDelay);
        buffer.append(", captureConnectStackTrace=");
        buffer.append(this.captureConnectStackTrace);
        buffer.append(", connectTimeoutMillis=");
        buffer.append(this.connectTimeoutMillis);
        buffer.append(", responseTimeoutMillis=");
        buffer.append(this.responseTimeoutMillis);
        for (Map.Entry<OperationType, Long> entry : this.responseTimeoutMillisByOperationType.entrySet()) {
            buffer.append(", responseTimeoutMillis.");
            buffer.append(entry.getKey().name());
            buffer.append('=');
            buffer.append(entry.getValue());
        }
        for (Map.Entry<Object, Long> entry : this.responseTimeoutMillisByExtendedOperationType.entrySet()) {
            buffer.append(", responseTimeoutMillis.EXTENDED.");
            buffer.append((String)entry.getKey());
            buffer.append('=');
            buffer.append(entry.getValue());
        }
        buffer.append(", abandonOnTimeout=");
        buffer.append(this.abandonOnTimeout);
        buffer.append(", maxMessageSizeBytes=");
        buffer.append(this.maxMessageSizeBytes);
        buffer.append(", receiveBufferSizeBytes=");
        buffer.append(this.receiveBufferSizeBytes);
        buffer.append(", sendBufferSizeBytes=");
        buffer.append(this.sendBufferSizeBytes);
        buffer.append(", allowConcurrentSocketFactoryUse=");
        buffer.append(this.allowConcurrentSocketFactoryUse);
        if (this.disconnectHandler != null) {
            buffer.append(", disconnectHandlerClass=");
            buffer.append(this.disconnectHandler.getClass().getName());
        }
        if (this.unsolicitedNotificationHandler != null) {
            buffer.append(", unsolicitedNotificationHandlerClass=");
            buffer.append(this.unsolicitedNotificationHandler.getClass().getName());
        }
        buffer.append(", sslSocketVerifierClass='");
        buffer.append(this.sslSocketVerifier.getClass().getName());
        buffer.append('\'');
        buffer.append(')');
    }

    static {
        HashMap<String, Long> timeoutsByExtOpType;
        EnumMap<OperationType, Long> timeoutsByOpType;
        Long allOpsTimeout;
        block10: {
            PROPERTY_PREFIX = LDAPConnectionOptions.class.getName() + '.';
            PROPERTY_DEFAULT_ABANDON_ON_TIMEOUT = PROPERTY_PREFIX + "defaultAbandonOnTimeout";
            DEFAULT_ABANDON_ON_TIMEOUT = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_ABANDON_ON_TIMEOUT, false);
            PROPERTY_DEFAULT_BIND_WITH_DN_REQUIRES_PASSWORD = PROPERTY_PREFIX + "defaultBindWithDNRequiresPassword";
            DEFAULT_BIND_WITH_DN_REQUIRES_PASSWORD = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_BIND_WITH_DN_REQUIRES_PASSWORD, true);
            PROPERTY_DEFAULT_CAPTURE_CONNECT_STACK_TRACE = PROPERTY_PREFIX + "defaultCaptureConnectStackTrace";
            DEFAULT_CAPTURE_CONNECT_STACK_TRACE = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_CAPTURE_CONNECT_STACK_TRACE, false);
            PROPERTY_DEFAULT_FOLLOW_REFERRALS = PROPERTY_PREFIX + "defaultFollowReferrals";
            DEFAULT_FOLLOW_REFERRALS = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_FOLLOW_REFERRALS, false);
            PROPERTY_DEFAULT_REFERRAL_HOP_LIMIT = PROPERTY_PREFIX + "defaultReferralHopLimit";
            DEFAULT_REFERRAL_HOP_LIMIT = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_REFERRAL_HOP_LIMIT, 5);
            PROPERTY_DEFAULT_USE_SCHEMA = PROPERTY_PREFIX + "defaultUseSchema";
            DEFAULT_USE_SCHEMA = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_USE_SCHEMA, false);
            PROPERTY_DEFAULT_USE_POOLED_SCHEMA = PROPERTY_PREFIX + "defaultUsePooledSchema";
            DEFAULT_USE_POOLED_SCHEMA = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_USE_POOLED_SCHEMA, false);
            PROPERTY_DEFAULT_POOLED_SCHEMA_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultPooledSchemaTimeoutMillis";
            PROPERTY_DEFAULT_USE_KEEPALIVE = PROPERTY_PREFIX + "defaultUseKeepalive";
            DEFAULT_USE_KEEPALIVE = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_USE_KEEPALIVE, true);
            PROPERTY_DEFAULT_USE_LINGER = PROPERTY_PREFIX + "defaultUseLinger";
            DEFAULT_USE_LINGER = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_USE_LINGER, true);
            PROPERTY_DEFAULT_LINGER_TIMEOUT_SECONDS = PROPERTY_PREFIX + "defaultLingerTimeoutSeconds";
            DEFAULT_LINGER_TIMEOUT_SECONDS = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_LINGER_TIMEOUT_SECONDS, 5);
            PROPERTY_DEFAULT_USE_REUSE_ADDRESS = PROPERTY_PREFIX + "defaultUseReuseAddress";
            DEFAULT_USE_REUSE_ADDRESS = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_USE_REUSE_ADDRESS, true);
            PROPERTY_DEFAULT_USE_SYNCHRONOUS_MODE = PROPERTY_PREFIX + "defaultUseSynchronousMode";
            DEFAULT_USE_SYNCHRONOUS_MODE = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_USE_SYNCHRONOUS_MODE, false);
            PROPERTY_DEFAULT_USE_TCP_NODELAY = PROPERTY_PREFIX + "defaultUseTCPNoDelay";
            DEFAULT_USE_TCP_NODELAY = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_USE_TCP_NODELAY, true);
            PROPERTY_DEFAULT_CONNECT_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultConnectTimeoutMillis";
            DEFAULT_CONNECT_TIMEOUT_MILLIS = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_CONNECT_TIMEOUT_MILLIS, 10000);
            PROPERTY_DEFAULT_MAX_MESSAGE_SIZE_BYTES = PROPERTY_PREFIX + "defaultMaxMessageSizeBytes";
            DEFAULT_MAX_MESSAGE_SIZE_BYTES = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_MAX_MESSAGE_SIZE_BYTES, 0x1400000);
            PROPERTY_DEFAULT_RECEIVE_BUFFER_SIZE_BYTES = PROPERTY_PREFIX + "defaultReceiveBufferSizeBytes";
            DEFAULT_RECEIVE_BUFFER_SIZE_BYTES = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_RECEIVE_BUFFER_SIZE_BYTES, 0);
            PROPERTY_DEFAULT_SEND_BUFFER_SIZE_BYTES = PROPERTY_PREFIX + "defaultSendBufferSizeBytes";
            DEFAULT_SEND_BUFFER_SIZE_BYTES = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_SEND_BUFFER_SIZE_BYTES, 0);
            PROPERTY_DEFAULT_RESPONSE_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultResponseTimeoutMillis";
            PROPERTY_DEFAULT_ADD_RESPONSE_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultAddResponseTimeoutMillis";
            PROPERTY_DEFAULT_BIND_RESPONSE_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultBindResponseTimeoutMillis";
            PROPERTY_DEFAULT_COMPARE_RESPONSE_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultCompareResponseTimeoutMillis";
            PROPERTY_DEFAULT_DELETE_RESPONSE_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultDeleteResponseTimeoutMillis";
            PROPERTY_DEFAULT_EXTENDED_RESPONSE_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultExtendedResponseTimeoutMillis";
            PROPERTY_DEFAULT_MODIFY_RESPONSE_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultModifyResponseTimeoutMillis";
            PROPERTY_DEFAULT_MODIFY_DN_RESPONSE_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultModifyDNResponseTimeoutMillis";
            PROPERTY_DEFAULT_SEARCH_RESPONSE_TIMEOUT_MILLIS = PROPERTY_PREFIX + "defaultSearchResponseTimeoutMillis";
            allOpsTimeout = null;
            timeoutsByOpType = new EnumMap<OperationType, Long>(OperationType.class);
            timeoutsByExtOpType = new HashMap<String, Long>(StaticUtils.computeMapCapacity(10));
            String allOpsPropertyValue = System.getProperty(PROPERTY_DEFAULT_RESPONSE_TIMEOUT_MILLIS);
            if (allOpsPropertyValue != null) {
                try {
                    allOpsTimeout = Math.max(0L, Long.parseLong(allOpsPropertyValue));
                    for (OperationType ot : OperationType.values()) {
                        timeoutsByOpType.put(ot, allOpsTimeout);
                    }
                    if (Debug.debugEnabled()) {
                        Debug.debug(Level.INFO, DebugType.OTHER, "Using value " + allOpsTimeout + " set for system property '" + PROPERTY_DEFAULT_RESPONSE_TIMEOUT_MILLIS + "'.  This " + "timeout will be used for all operation types.");
                    }
                }
                catch (Exception e) {
                    if (!Debug.debugEnabled()) break block10;
                    Debug.debugException(e);
                    Debug.debug(Level.WARNING, DebugType.OTHER, "Invalid value '" + allOpsPropertyValue + "' set for system " + "property '" + PROPERTY_DEFAULT_RESPONSE_TIMEOUT_MILLIS + "'.  The value was expected to be a long.  Ignoring " + "this property and proceeding as if it had not been set.");
                }
            }
        }
        if (allOpsTimeout == null) {
            allOpsTimeout = 300000L;
            timeoutsByOpType.put(OperationType.ABANDON, 10000L);
            timeoutsByOpType.put(OperationType.UNBIND, 10000L);
            timeoutsByOpType.put(OperationType.ADD, LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_ADD_RESPONSE_TIMEOUT_MILLIS, 30000L));
            timeoutsByOpType.put(OperationType.BIND, LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_BIND_RESPONSE_TIMEOUT_MILLIS, 30000L));
            timeoutsByOpType.put(OperationType.COMPARE, LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_COMPARE_RESPONSE_TIMEOUT_MILLIS, 30000L));
            timeoutsByOpType.put(OperationType.DELETE, LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_DELETE_RESPONSE_TIMEOUT_MILLIS, 30000L));
            timeoutsByOpType.put(OperationType.MODIFY, LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_MODIFY_RESPONSE_TIMEOUT_MILLIS, 30000L));
            timeoutsByOpType.put(OperationType.MODIFY_DN, LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_MODIFY_DN_RESPONSE_TIMEOUT_MILLIS, 30000L));
            timeoutsByOpType.put(OperationType.SEARCH, LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_SEARCH_RESPONSE_TIMEOUT_MILLIS, 300000L));
            String extendedOperationTypePrefix = PROPERTY_DEFAULT_EXTENDED_RESPONSE_TIMEOUT_MILLIS + '.';
            for (String propertyName : StaticUtils.getSystemProperties(new String[0]).stringPropertyNames()) {
                Long value;
                if (!propertyName.startsWith(extendedOperationTypePrefix) || (value = LDAPConnectionOptions.getSystemProperty(propertyName, null)) == null) continue;
                String oid = propertyName.substring(extendedOperationTypePrefix.length());
                timeoutsByExtOpType.put(oid, value);
            }
            Long extendedOpTimeout = LDAPConnectionOptions.getSystemProperty(PROPERTY_DEFAULT_EXTENDED_RESPONSE_TIMEOUT_MILLIS, null);
            if (extendedOpTimeout == null) {
                timeoutsByOpType.put(OperationType.EXTENDED, 300000L);
                for (String oid : Arrays.asList("1.3.6.1.4.1.4203.1.11.1", "1.3.6.1.4.1.1466.20037", "1.3.6.1.4.1.4203.1.11.3", "1.3.6.1.4.1.30221.2.6.55", "1.3.6.1.4.1.30221.2.6.14", "1.3.6.1.4.1.30221.2.6.56", "1.3.6.1.4.1.30221.1.6.2", "1.3.6.1.4.1.30221.2.6.43", "1.3.6.1.4.1.30221.1.6.1", "1.3.6.1.4.1.30221.2.6.54", "1.3.6.1.4.1.30221.2.6.58", "1.3.6.1.4.1.30221.2.6.13", "1.3.6.1.4.1.30221.2.6.15")) {
                    if (timeoutsByExtOpType.containsKey(oid)) continue;
                    timeoutsByExtOpType.put(oid, 30000L);
                }
            } else {
                timeoutsByOpType.put(OperationType.EXTENDED, extendedOpTimeout);
            }
        }
        DEFAULT_RESPONSE_TIMEOUT_MILLIS = allOpsTimeout;
        DEFAULT_RESPONSE_TIMEOUT_MILLIS_BY_OPERATION_TYPE = Collections.unmodifiableMap(timeoutsByOpType);
        DEFAULT_RESPONSE_TIMEOUT_MILLIS_BY_EXTENDED_OPERATION_TYPE = Collections.unmodifiableMap(timeoutsByExtOpType);
        String vmVendor = StaticUtils.toLowerCase(System.getProperty("java.vm.vendor"));
        DEFAULT_ALLOW_CONCURRENT_SOCKET_FACTORY_USE = vmVendor != null && (vmVendor.contains("sun microsystems") || vmVendor.contains("oracle") || vmVendor.contains("apple") || vmVendor.contains("azul systems"));
        DEFAULT_SSL_SOCKET_VERIFIER = TrustAllSSLSocketVerifier.getInstance();
    }
}

