/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.batches;

import monix.execution.internal.Platform$;
import monix.tail.batches.ArrayCursor;
import monix.tail.batches.BatchCursor;
import monix.tail.batches.BooleansCursor;
import monix.tail.batches.BytesCursor;
import monix.tail.batches.CharsCursor;
import monix.tail.batches.DoublesCursor;
import monix.tail.batches.EmptyCursor$;
import monix.tail.batches.IntegersCursor;
import monix.tail.batches.IteratorCursor;
import monix.tail.batches.LongsCursor;
import scala.Function0;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class BatchCursor$
implements Serializable {
    public static BatchCursor$ MODULE$;

    static {
        new BatchCursor$();
    }

    public <A> BatchCursor<A> apply(Seq<A> elems) {
        Object[] array = (Object[])elems.toArray(ClassTag$.MODULE$.AnyRef());
        return this.fromArray(array);
    }

    public <A> BatchCursor<A> fromIterator(Iterator<A> iter) {
        int bs = iter.hasDefiniteSize() ? Platform$.MODULE$.recommendedBatchSize() : 1;
        return new IteratorCursor<A>(iter, bs);
    }

    public <A> BatchCursor<A> fromIterator(Iterator<A> iter, int recommendedBatchSize) {
        return new IteratorCursor<A>(iter, recommendedBatchSize);
    }

    public <A> ArrayCursor<A> fromArray(Object array) {
        return this.fromArray(array, 0, ScalaRunTime$.MODULE$.array_length(array));
    }

    public <A> ArrayCursor<A> fromArray(Object array, int offset, int length) {
        ClassTag tp = ClassTag$.MODULE$.apply(array.getClass().getComponentType());
        return new ArrayCursor(array, offset, length, tp);
    }

    public <A> ArrayCursor<A> fromAnyArray(Object array, int offset, int length) {
        return this.fromArray(array, offset, length);
    }

    public <A> ArrayCursor<A> fromAnyArray(Object array) {
        return this.fromAnyArray(array, 0, ScalaRunTime$.MODULE$.array_length(array));
    }

    public <A> BatchCursor<A> fromSeq(Seq<A> seq) {
        int bs = seq.hasDefiniteSize() ? Platform$.MODULE$.recommendedBatchSize() : 1;
        return this.fromSeq(seq, bs);
    }

    public <A> BatchCursor<A> fromSeq(Seq<A> seq, int recommendedBatchSize) {
        return this.fromIterator(seq.iterator(), recommendedBatchSize);
    }

    public <A> BatchCursor<A> fromIndexedSeq(IndexedSeq<A> seq) {
        Object[] ref = (Object[])seq.toArray(ClassTag$.MODULE$.AnyRef());
        return this.fromArray(ref);
    }

    public <A> BatchCursor<A> empty() {
        return EmptyCursor$.MODULE$;
    }

    public BooleansCursor booleans(boolean[] array) {
        return this.booleans(array, 0, array.length);
    }

    public BooleansCursor booleans(boolean[] array, int offset, int length) {
        return new BooleansCursor(array, offset, length);
    }

    public BytesCursor bytes(byte[] array) {
        return this.bytes(array, 0, array.length);
    }

    public BytesCursor bytes(byte[] array, int offset, int length) {
        return new BytesCursor(array, offset, length);
    }

    public CharsCursor chars(char[] array) {
        return this.chars(array, 0, array.length);
    }

    public CharsCursor chars(char[] array, int offset, int length) {
        return new CharsCursor(array, offset, length);
    }

    public IntegersCursor integers(int[] array) {
        return this.integers(array, 0, array.length);
    }

    public IntegersCursor integers(int[] array, int offset, int length) {
        return new IntegersCursor(array, offset, length);
    }

    public LongsCursor longs(long[] array) {
        return this.longs(array, 0, array.length);
    }

    public LongsCursor longs(long[] array, int offset, int length) {
        return new LongsCursor(array, offset, length);
    }

    public DoublesCursor doubles(double[] array) {
        return this.doubles(array, 0, array.length);
    }

    public DoublesCursor doubles(double[] array, int offset, int length) {
        return new DoublesCursor(array, offset, length);
    }

    public BatchCursor<Object> range(int from, int until, int step) {
        return this.fromIterator(package$.MODULE$.Iterator().range(from, until, step), Platform$.MODULE$.recommendedBatchSize());
    }

    public int range$default$3() {
        return 1;
    }

    public <A> BatchCursor<A> continually(Function0<A> f) {
        return this.fromIterator(package$.MODULE$.Iterator().continually(f), 1);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BatchCursor$() {
        MODULE$ = this;
    }
}

