/*
 * Decompiled with CFR 0.152.
 */
package monix.tail;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Async;
import cats.effect.Clock$;
import cats.effect.ExitCase;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.syntax.package;
import java.io.Serializable;
import monix.execution.internal.Platform$;
import monix.tail.Iterant;
import monix.tail.IterantBuilders;
import monix.tail.IterantBuilders$;
import monix.tail.IterantInstances;
import monix.tail.batches.Batch;
import monix.tail.batches.Batch$;
import monix.tail.batches.BatchCursor;
import monix.tail.batches.BatchCursor$;
import monix.tail.internal.Constants$;
import monix.tail.internal.IterantConcat$;
import monix.tail.internal.IterantFromReactivePublisher$;
import monix.tail.internal.IterantIntervalAtFixedRate$;
import monix.tail.internal.IterantIntervalWithFixedDelay$;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.LinearSeq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.control.NonFatal$;

public final class Iterant$
implements IterantInstances,
scala.Serializable {
    public static Iterant$ MODULE$;

    static {
        new Iterant$();
    }

    @Override
    public <F> IterantInstances.CatsSyncInstances<F> catsSyncInstances(Sync<F> F) {
        return IterantInstances.catsSyncInstances$(this, F);
    }

    public <F> IterantBuilders<F> apply() {
        return IterantBuilders$.MODULE$.apply();
    }

    public <F, A> Iterant<F, A> pure(A a) {
        return this.now(a);
    }

    public <F, A> Iterant<F, A> resource(F acquire, Function1<A, F> release, Sync<F> F) {
        return this.resourceCase(acquire, (Function2 & Serializable & scala.Serializable)(a, x$14) -> release.apply(a), F);
    }

    public <F, A> Iterant<F, A> resourceCase(F acquire, Function2<A, ExitCase<Throwable>, F> release, Sync<F> F) {
        return new Iterant.Scope(acquire, (Function1 & Serializable & scala.Serializable)a -> F.pure(MODULE$.pure(a)), release);
    }

    public <F, A> Iterant<F, A> now(A a) {
        return this.lastS(a);
    }

    public <F, A> Iterant<F, A> lastS(A item) {
        return new Iterant.Last(item);
    }

    public <F, A> Iterant<F, A> eval(Function0<A> a, Sync<F> F) {
        return new Iterant.Suspend(F.delay((Function0 & Serializable & scala.Serializable)() -> MODULE$.lastS(a.apply())));
    }

    public <F, A> Iterant<F, A> delay(Function0<A> a, Sync<F> F) {
        return this.eval(a, F);
    }

    public <F, A> Iterant<F, A> liftF(F fa, Functor<F> F) {
        return new Iterant.Suspend(F.map(fa, (Function1 & Serializable & scala.Serializable)item -> MODULE$.lastS(item)));
    }

    public <F, A> Iterant<F, A> defer(Function0<Iterant<F, A>> fa, Sync<F> F) {
        return this.suspend(fa, F);
    }

    public <F, A> Iterant<F, A> suspend(Function0<Iterant<F, A>> fa, Sync<F> F) {
        return this.suspend(F.delay(fa));
    }

    public <F, A> Iterant<F, A> suspend(F rest) {
        return new Iterant.Suspend(rest);
    }

    public <F, A> Iterant<F, A> raiseError(Throwable ex) {
        return new Iterant.Halt((Option<Throwable>)new Some((Object)ex));
    }

    public <F, A, B> Iterant<F, B> tailRecM(A a, Function1<A, Iterant<F, Either<A, B>>> f, Sync<F> F) {
        return IterantConcat$.MODULE$.tailRecM(a, f, F);
    }

    public <F, A> Iterant<F, A> fromArray(Object xs, Applicative<F> F) {
        return new Iterant.NextBatch(Batch$.MODULE$.fromArray(xs), F.pure(this.empty()));
    }

    public <F, A> Iterant<F, A> fromSeq(Seq<A> xs, Applicative<F> F) {
        Iterant<F, A> iterant;
        Seq<A> seq = xs;
        if (seq instanceof LinearSeq) {
            LinearSeq linearSeq = (LinearSeq)seq;
            iterant = this.fromList(linearSeq, F);
        } else if (seq instanceof IndexedSeq) {
            IndexedSeq indexedSeq = (IndexedSeq)seq;
            iterant = this.fromIndexedSeq(indexedSeq, F);
        } else {
            iterant = this.fromIterable((Iterable<A>)xs, F);
        }
        return iterant;
    }

    public <F, A> Iterant<F, A> fromList(LinearSeq<A> xs, Applicative<F> F) {
        return new Iterant.NextBatch<Object, A>(Batch$.MODULE$.fromSeq(xs), F.pure(this.empty()));
    }

    public <F, A> Iterant<F, A> fromIndexedSeq(IndexedSeq<A> xs, Applicative<F> F) {
        return new Iterant.NextBatch<Object, A>(Batch$.MODULE$.fromIndexedSeq(xs), F.pure(this.empty()));
    }

    public <F, A> Iterant<F, A> fromIterable(Iterable<A> xs, Applicative<F> F) {
        int bs = xs.hasDefiniteSize() ? Platform$.MODULE$.recommendedBatchSize() : 1;
        return new Iterant.NextBatch<Object, A>(Batch$.MODULE$.fromIterable(xs, bs), F.pure(this.empty()));
    }

    public <F, A> Iterant<F, A> fromIterator(Iterator<A> xs, Applicative<F> F) {
        int bs = xs.hasDefiniteSize() ? Platform$.MODULE$.recommendedBatchSize() : 1;
        return new Iterant.NextCursor<Object, A>(BatchCursor$.MODULE$.fromIterator(xs, bs), F.pure(this.empty()));
    }

    public <F, A> Iterant<F, A> fromBatch(Batch<A> xs, Applicative<F> F) {
        return new Iterant.NextBatch<Object, A>(xs, F.pure(this.empty()));
    }

    public <F, A> Iterant<F, A> fromBatchCursor(BatchCursor<A> xs, Applicative<F> F) {
        return new Iterant.NextCursor<Object, A>(xs, F.pure(this.empty()));
    }

    public <F, A> Iterant<F, A> fromReactivePublisher(Publisher<A> publisher, int requestCount, boolean eagerBuffer, Async<F> F) {
        return IterantFromReactivePublisher$.MODULE$.apply(publisher, requestCount, eagerBuffer, F);
    }

    public <F, A> int fromReactivePublisher$default$2() {
        return 256;
    }

    public <F, A> boolean fromReactivePublisher$default$3() {
        return true;
    }

    public <F, S, A> Iterant<F, A> fromStateAction(Function1<S, Tuple2<A, S>> f, Function0<S> seed, Sync<F> F) {
        Iterant.Halt halt;
        try {
            halt = Iterant$.loop$1(seed.apply(), f, F);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!NonFatal$.MODULE$.apply(throwable2)) {
                throw throwable;
            }
            Iterant.Halt halt2 = new Iterant.Halt((Option<Throwable>)new Some((Object)throwable2));
            halt = halt2;
        }
        return halt;
    }

    public <F, S, A> Iterant<F, A> fromStateActionL(Function1<S, F> f, Function0<F> seed, Sync<F> F) {
        return new Iterant.Suspend(F.suspend((Function0 & Serializable & scala.Serializable)() -> package.all$.MODULE$.toFlatMapOps(seed.apply(), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)state -> Iterant$.loop$2(state, f, F))));
    }

    public <F> Iterant<F, Object> range(int from, int until, int step, Applicative<F> F) {
        return new Iterant.NextBatch<Object, Object>(Batch$.MODULE$.range(from, until, step), F.pure(this.empty()));
    }

    public <F> int range$default$3() {
        return 1;
    }

    public <F, A> Iterant<F, A> repeat(Seq<A> elems, Sync<F> F) {
        Iterant iterant;
        Seq<A> seq = elems;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            iterant = this.empty();
        } else {
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
                Object elem = ((SeqLike)some2.get()).apply(0);
                ObjectRef result = ObjectRef.create(null);
                result.elem = new Iterant.Next<Object, Object>(elem, F.delay((Function0 & Serializable & scala.Serializable)() -> (Iterant)result$1.elem));
                iterant = (Iterant)result.elem;
            } else {
                ObjectRef result = ObjectRef.create(null);
                result.elem = new Iterant.NextBatch<Object, A>(Batch$.MODULE$.apply(elems), F.delay((Function0 & Serializable & scala.Serializable)() -> (Iterant)result$2.elem));
                iterant = (Iterant)result.elem;
            }
        }
        return iterant;
    }

    public <F, A> Iterant<F, A> repeatEval(Function0<A> thunk, Sync<F> F) {
        return this.repeatEvalF(F.delay(thunk), F);
    }

    public <F, A> Iterant<F, A> repeatEvalF(F fa, Sync<F> F) {
        return this.repeat((Seq<A>)Predef$.MODULE$.wrapUnitArray(new BoxedUnit[]{BoxedUnit.UNIT}), F).mapEval((Function1 & Serializable & scala.Serializable)x$16 -> fa, F);
    }

    public <F, A> Iterant<F, A> empty() {
        return Constants$.MODULE$.emptyRef();
    }

    public <F, A> Iterant<F, A> never(Async<F> F) {
        return this.suspendS(F.never());
    }

    public <F> Iterant<F, Object> intervalAtFixedRate(FiniteDuration period, Async<F> F, Timer<F> timer) {
        return IterantIntervalAtFixedRate$.MODULE$.apply(Duration$.MODULE$.Zero(), period, F, timer, Clock$.MODULE$.extractFromTimer(timer));
    }

    public <F> Iterant<F, Object> intervalAtFixedRate(FiniteDuration initialDelay, FiniteDuration period, Async<F> F, Timer<F> timer) {
        return IterantIntervalAtFixedRate$.MODULE$.apply(initialDelay, period, F, timer, Clock$.MODULE$.extractFromTimer(timer));
    }

    public <F> Iterant<F, Object> intervalWithFixedDelay(FiniteDuration delay, Async<F> F, Timer<F> timer) {
        return IterantIntervalWithFixedDelay$.MODULE$.apply(Duration$.MODULE$.Zero(), delay, F, timer);
    }

    public <F> Iterant<F, Object> intervalWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, Async<F> F, Timer<F> timer) {
        return IterantIntervalWithFixedDelay$.MODULE$.apply(initialDelay, delay, F, timer);
    }

    public <F, A> Iterant<F, A> concat(Seq<Iterant<F, A>> xs, Sync<F> F) {
        return (Iterant)xs.foldLeft(this.empty(), (Function2 & Serializable & scala.Serializable)(acc, e) -> IterantConcat$.MODULE$.concat(acc, F.pure(e), F));
    }

    public <F, A> Iterant<F, A> nextS(A item, F rest) {
        return new Iterant.Next<F, A>(item, rest);
    }

    public <F, A> Iterant<F, A> nextCursorS(BatchCursor<A> items, F rest) {
        return new Iterant.NextCursor<F, A>(items, rest);
    }

    public <F, A> Iterant<F, A> nextBatchS(Batch<A> items, F rest) {
        return new Iterant.NextBatch<F, A>(items, rest);
    }

    public <F, A> Iterant<F, A> haltS(Option<Throwable> e) {
        return new Iterant.Halt(e);
    }

    public <F, A> Iterant<F, A> suspendS(F rest) {
        return new Iterant.Suspend(rest);
    }

    public <F, A, B> Iterant<F, B> scopeS(F acquire, Function1<A, F> use, Function2<A, ExitCase<Throwable>, F> release) {
        return new Iterant.Scope(acquire, use, release);
    }

    public <F, A> Iterant<F, A> concatS(F lh, F rh) {
        return new Iterant.Concat(lh, rh);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Iterant loop$1(Object state, Function1 f$5, Sync F$5) {
        ObjectRef currentState = ObjectRef.create((Object)state);
        Buffer buffer = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int toProcess = Platform$.MODULE$.recommendedBatchSize(); toProcess > 0; --toProcess) {
            Tuple2 tuple2 = (Tuple2)f$5.apply(currentState.elem);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object elem = tuple2._1();
            Object newState = tuple2._2();
            Tuple2 tuple22 = new Tuple2(elem, newState);
            Tuple2 tuple23 = tuple22;
            Object elem2 = tuple23._1();
            Object newState2 = tuple23._2();
            buffer.append((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elem2}));
            currentState.elem = newState2;
        }
        return new Iterant.NextBatch(Batch$.MODULE$.fromSeq(buffer), F$5.delay((Function0 & Serializable & scala.Serializable)() -> Iterant$.loop$1(currentState$1.elem, f$5, F$5)));
    }

    private static final Object loop$2(Object state, Function1 f$6, Sync F$6) {
        Object object;
        try {
            object = package.all$.MODULE$.toFunctorOps(f$6.apply(state), (Functor)F$6).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object elem = tuple2._1();
                Object newState = tuple2._2();
                Iterant.Next<Object, Object> next = new Iterant.Next<Object, Object>(elem, F$6.suspend((Function0 & Serializable & scala.Serializable)() -> Iterant$.loop$2(newState, f$6, F$6)));
                return next;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!NonFatal$.MODULE$.apply(throwable2)) {
                throw throwable;
            }
            Object object2 = F$6.pure(new Iterant.Halt((Option<Throwable>)new Some((Object)throwable2)));
            object = object2;
        }
        return object;
    }

    private Iterant$() {
        MODULE$ = this;
        IterantInstances.$init$(this);
    }
}

