/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.collection.queues;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import monix.execution.BufferCapacity;
import monix.execution.ChannelType;
import monix.execution.ChannelType$MPMC$;
import monix.execution.ChannelType$MPSC$;
import monix.execution.ChannelType$SPMC$;
import monix.execution.ChannelType$SPSC$;
import monix.execution.internal.Platform$;
import monix.execution.internal.atomic.UnsafeAccess;
import monix.execution.internal.collection.ConcurrentQueue;
import monix.execution.internal.collection.queues.FromCircularQueue;
import monix.execution.internal.collection.queues.FromJavaQueue;
import monix.execution.internal.collection.queues.FromMessagePassingQueue;
import org.jctools.queues.MpmcArrayQueue;
import org.jctools.queues.MpscArrayQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jctools.queues.SpmcArrayQueue;
import org.jctools.queues.SpscArrayQueue;
import org.jctools.queues.SpscUnboundedArrayQueue;
import org.jctools.queues.atomic.MpmcAtomicArrayQueue;
import org.jctools.queues.atomic.MpscAtomicArrayQueue;
import org.jctools.queues.atomic.MpscUnboundedAtomicArrayQueue;
import org.jctools.queues.atomic.SpmcAtomicArrayQueue;
import org.jctools.queues.atomic.SpscAtomicArrayQueue;
import org.jctools.queues.atomic.SpscUnboundedAtomicArrayQueue;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E3\u0001\"\u0001\u0002\u0011\u0002\u0007\u0005a\u0001\u0004\u0002\u0018\u0007>t7-\u001e:sK:$\u0018+^3vK\n+\u0018\u000e\u001c3feNT!a\u0001\u0003\u0002\rE,X-^3t\u0015\t)a!\u0001\u0006d_2dWm\u0019;j_:T!a\u0002\u0005\u0002\u0011%tG/\u001a:oC2T!!\u0003\u0006\u0002\u0013\u0015DXmY;uS>t'\"A\u0006\u0002\u000b5|g.\u001b=\u0014\u0005\u0001i\u0001C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\rC\u0003\u0015\u0001\u0011\u0005a#\u0001\u0004%S:LG\u000fJ\u0002\u0001)\u00059\u0002C\u0001\b\u0019\u0013\tIrB\u0001\u0003V]&$\b\"B\u000e\u0001\t\u0003a\u0012!B1qa2LXCA\u000f%)\rqRf\r\t\u0004?\u0001\u0012S\"\u0001\u0003\n\u0005\u0005\"!aD\"p]\u000e,(O]3oiF+X-^3\u0011\u0005\r\"C\u0002\u0001\u0003\u0006Ki\u0011\rA\n\u0002\u0002\u0003F\u0011qE\u000b\t\u0003\u001d!J!!K\b\u0003\u000f9{G\u000f[5oOB\u0011abK\u0005\u0003Y=\u00111!\u00118z\u0011\u0015q#\u00041\u00010\u0003!\u0019\u0017\r]1dSRL\bC\u0001\u00192\u001b\u0005A\u0011B\u0001\u001a\t\u00059\u0011UO\u001a4fe\u000e\u000b\u0007/Y2jifDQ\u0001\u000e\u000eA\u0002U\n1b\u00195b]:,G\u000eV=qKB\u0011\u0001GN\u0005\u0003o!\u00111b\u00115b]:,G\u000eV=qK\")\u0011\b\u0001C\u0001u\u00059!m\\;oI\u0016$WCA\u001e?)\rath\u0011\t\u0004?\u0001j\u0004CA\u0012?\t\u0015)\u0003H1\u0001'\u0011\u0015q\u0003\b1\u0001A!\tq\u0011)\u0003\u0002C\u001f\t\u0019\u0011J\u001c;\t\u000bQB\u0004\u0019A\u001b\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0013Ut'm\\;oI\u0016$WCA$K)\rA5\n\u0015\t\u0004?\u0001J\u0005CA\u0012K\t\u0015)CI1\u0001'\u0011\u0015aE\t1\u0001N\u0003%\u0019\u0007.\u001e8l'&TX\rE\u0002\u000f\u001d\u0002K!aT\b\u0003\r=\u0003H/[8o\u0011\u0015!D\t1\u00016\u0001")
public interface ConcurrentQueueBuilders {
    public static /* synthetic */ ConcurrentQueue apply$(ConcurrentQueueBuilders $this, BufferCapacity capacity, ChannelType channelType) {
        return $this.apply(capacity, channelType);
    }

    default public <A> ConcurrentQueue<A> apply(BufferCapacity capacity, ChannelType channelType) {
        ConcurrentQueue<A> concurrentQueue;
        BufferCapacity bufferCapacity = capacity;
        if (bufferCapacity instanceof BufferCapacity.Bounded) {
            BufferCapacity.Bounded bounded = (BufferCapacity.Bounded)bufferCapacity;
            int c = bounded.capacity();
            concurrentQueue = this.bounded(c, channelType);
        } else if (bufferCapacity instanceof BufferCapacity.Unbounded) {
            BufferCapacity.Unbounded unbounded = (BufferCapacity.Unbounded)bufferCapacity;
            Option<Object> hint = unbounded.chunkSizeHint();
            concurrentQueue = this.unbounded(hint, channelType);
        } else {
            throw new MatchError((Object)bufferCapacity);
        }
        return concurrentQueue;
    }

    public static /* synthetic */ ConcurrentQueue bounded$(ConcurrentQueueBuilders $this, int capacity, ChannelType channelType) {
        return $this.bounded(capacity, channelType);
    }

    default public <A> ConcurrentQueue<A> bounded(int capacity, ChannelType channelType) {
        ConcurrentQueue concurrentQueue;
        if (UnsafeAccess.IS_OPENJDK_COMPATIBLE) {
            FromCircularQueue fromCircularQueue;
            ChannelType channelType2 = channelType;
            if (ChannelType$MPMC$.MODULE$.equals(channelType2)) {
                fromCircularQueue = new FromCircularQueue(new MpmcArrayQueue(capacity));
            } else if (ChannelType$MPSC$.MODULE$.equals(channelType2)) {
                fromCircularQueue = new FromCircularQueue(new MpscArrayQueue(capacity));
            } else if (ChannelType$SPMC$.MODULE$.equals(channelType2)) {
                fromCircularQueue = new FromCircularQueue(new SpmcArrayQueue(capacity));
            } else if (ChannelType$SPSC$.MODULE$.equals(channelType2)) {
                fromCircularQueue = new FromCircularQueue(new SpscArrayQueue(capacity));
            } else {
                throw new MatchError((Object)channelType2);
            }
            concurrentQueue = fromCircularQueue;
        } else {
            FromMessagePassingQueue fromMessagePassingQueue;
            ChannelType channelType3 = channelType;
            if (ChannelType$MPMC$.MODULE$.equals(channelType3)) {
                fromMessagePassingQueue = new FromMessagePassingQueue(new MpmcAtomicArrayQueue(capacity));
            } else if (ChannelType$MPSC$.MODULE$.equals(channelType3)) {
                fromMessagePassingQueue = new FromMessagePassingQueue(new MpscAtomicArrayQueue(capacity));
            } else if (ChannelType$SPMC$.MODULE$.equals(channelType3)) {
                fromMessagePassingQueue = new FromMessagePassingQueue(new SpmcAtomicArrayQueue(capacity));
            } else if (ChannelType$SPSC$.MODULE$.equals(channelType3)) {
                fromMessagePassingQueue = new FromMessagePassingQueue(new SpscAtomicArrayQueue(capacity));
            } else {
                throw new MatchError((Object)channelType3);
            }
            concurrentQueue = fromMessagePassingQueue;
        }
        return concurrentQueue;
    }

    public static /* synthetic */ ConcurrentQueue unbounded$(ConcurrentQueueBuilders $this, Option chunkSize, ChannelType channelType) {
        return $this.unbounded((Option<Object>)chunkSize, channelType);
    }

    default public <A> ConcurrentQueue<A> unbounded(Option<Object> chunkSize, ChannelType channelType) {
        FromMessagePassingQueue fromMessagePassingQueue;
        int chunk = BoxesRunTime.unboxToInt((Object)chunkSize.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Platform$.MODULE$.recommendedBatchSize()));
        if (UnsafeAccess.IS_OPENJDK_COMPATIBLE) {
            ChannelType channelType2 = channelType;
            ConcurrentQueue<Object> concurrentQueue = ChannelType$MPSC$.MODULE$.equals(channelType2) ? new FromMessagePassingQueue(new MpscUnboundedArrayQueue(chunk)) : (ChannelType$SPSC$.MODULE$.equals(channelType2) ? new FromMessagePassingQueue(new SpscUnboundedArrayQueue(chunk)) : new FromJavaQueue(new ConcurrentLinkedQueue()));
            fromMessagePassingQueue = concurrentQueue;
        } else {
            ChannelType channelType3 = channelType;
            ConcurrentQueue<Object> concurrentQueue = ChannelType$MPSC$.MODULE$.equals(channelType3) ? new FromMessagePassingQueue(new MpscUnboundedAtomicArrayQueue(chunk)) : (ChannelType$SPSC$.MODULE$.equals(channelType3) ? new FromMessagePassingQueue(new SpscUnboundedAtomicArrayQueue(chunk)) : new FromJavaQueue(new ConcurrentLinkedQueue()));
            fromMessagePassingQueue = concurrentQueue;
        }
        return fromMessagePassingQueue;
    }

    public static void $init$(ConcurrentQueueBuilders $this) {
    }
}

