/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import cats.effect.Async;
import cats.effect.Concurrent;
import cats.effect.ConcurrentEffect;
import cats.effect.Effect;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.LiftIO;
import cats.effect.SyncIO;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.eval.Task$Async$;
import monix.eval.internal.TaskConnection;
import monix.eval.internal.TaskConnectionRef;
import monix.eval.internal.TaskConnectionRef$;
import monix.eval.internal.TaskConversions;
import monix.execution.Callback;
import monix.execution.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class TaskConversions$ {
    public static TaskConversions$ MODULE$;

    static {
        new TaskConversions$();
    }

    public <A> IO<A> toIO(Task<A> source, ConcurrentEffect<Task> eff) {
        IO iO;
        Task task = source;
        if (task instanceof Task.Now) {
            Task.Now now = (Task.Now)task;
            Object value = now.value();
            iO = IO$.MODULE$.pure(value);
        } else if (task instanceof Task.Error) {
            Task.Error error = (Task.Error)task;
            Throwable e = error.e();
            iO = IO$.MODULE$.raiseError(e);
        } else if (task instanceof Task.Eval) {
            Task.Eval eval = (Task.Eval)task;
            Function0 thunk = eval.thunk();
            iO = IO$.MODULE$.apply(thunk);
        } else {
            iO = IO$.MODULE$.cancelable((Function1 & Serializable & scala.Serializable)cb -> MODULE$.toIO((Task)eff.runCancelable((Object)source, (Function1 & Serializable & scala.Serializable)r -> {
                cb.apply(r);
                return IO$.MODULE$.unit();
            }).unsafeRunSync(), eff));
        }
        return iO;
    }

    public <F, A> F toConcurrent(Task<A> source, Concurrent<F> F, ConcurrentEffect<Task> eff) {
        Object object;
        Task task = source;
        if (task instanceof Task.Now) {
            Task.Now now = (Task.Now)task;
            Object value = now.value();
            object = F.pure(value);
        } else if (task instanceof Task.Error) {
            Task.Error error = (Task.Error)task;
            Throwable e = error.e();
            object = F.raiseError((Object)e);
        } else if (task instanceof Task.Eval) {
            Task.Eval eval = (Task.Eval)task;
            Function0 thunk = eval.thunk();
            object = F.delay(thunk);
        } else {
            object = F.cancelable((Function1 & Serializable & scala.Serializable)cb -> {
                Task token = (Task)eff.runCancelable((Object)source, (Function1 & Serializable & scala.Serializable)r -> {
                    cb.apply(r);
                    return IO$.MODULE$.unit();
                }).unsafeRunSync();
                return MODULE$.toConcurrent(token, F, eff);
            });
        }
        return (F)object;
    }

    public <F, A> F toAsync(Task<A> source, Async<F> F, Effect<Task> eff) {
        Object object;
        Task task = source;
        if (task instanceof Task.Now) {
            Task.Now now = (Task.Now)task;
            Object value = now.value();
            object = F.pure(value);
        } else if (task instanceof Task.Error) {
            Task.Error error = (Task.Error)task;
            Throwable e = error.e();
            object = F.raiseError((Object)e);
        } else if (task instanceof Task.Eval) {
            Task.Eval eval = (Task.Eval)task;
            Function0 thunk = eval.thunk();
            object = F.delay(thunk);
        } else {
            object = F.async((Function1 & Serializable & scala.Serializable)cb -> {
                TaskConversions$.$anonfun$toAsync$1(eff, task, cb);
                return BoxedUnit.UNIT;
            });
        }
        return (F)object;
    }

    public <F, A> Task<A> fromEffect(F fa, Effect<F> F) {
        Task task;
        F f = fa;
        if (f instanceof Task) {
            Task task2;
            task = task2 = (Task)f;
        } else if (f instanceof IO) {
            IO iO = (IO)f;
            task = (Task)iO.to((LiftIO)Task$.MODULE$.catsAsync());
        } else {
            task = this.fromEffect0(fa, F);
        }
        return task;
    }

    private <F, A> Task<A> fromEffect0(F fa, Effect<F> F) {
        Function2 & Serializable & scala.Serializable start = (Function2 & Serializable & scala.Serializable)(ctx, cb) -> {
            TaskConversions$.$anonfun$fromEffect0$1(fa, F, ctx, cb);
            return BoxedUnit.UNIT;
        };
        return new Task.Async(start, false, false, Task$Async$.MODULE$.apply$default$4());
    }

    public <F, A> Task<A> fromConcurrentEffect(F fa, ConcurrentEffect<F> F) {
        Task task;
        F f = fa;
        if (f instanceof Task) {
            Task task2;
            task = task2 = (Task)f;
        } else if (f instanceof IO) {
            IO iO = (IO)f;
            task = (Task)iO.to((LiftIO)Task$.MODULE$.catsAsync());
        } else {
            task = this.fromConcurrentEffect0(fa, F);
        }
        return task;
    }

    private <F, A> Task<A> fromConcurrentEffect0(F fa, ConcurrentEffect<F> F) {
        Function2 & Serializable & scala.Serializable start = (Function2 & Serializable & scala.Serializable)(ctx, cb) -> {
            TaskConversions$.$anonfun$fromConcurrentEffect0$1(fa, F, ctx, cb);
            return BoxedUnit.UNIT;
        };
        return new Task.Async(start, false, false, Task$Async$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ void $anonfun$toAsync$1(Effect eff$2, Task x1$1, Function1 cb) {
        eff$2.runAsync((Object)x1$1, (Function1 & Serializable & scala.Serializable)r -> {
            cb.apply(r);
            return IO$.MODULE$.unit();
        }).unsafeRunSync();
    }

    public static final /* synthetic */ void $anonfun$fromEffect0$1(Object fa$1, Effect F$2, Task.Context ctx, Callback cb) {
        try {
            Scheduler sc = ctx.scheduler();
            SyncIO io = F$2.runAsync(fa$1, new TaskConversions.CreateCallback(null, cb, sc));
            io.unsafeRunSync();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                ctx.scheduler().reportFailure(e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$fromConcurrentEffect0$1(Object fa$2, ConcurrentEffect F$3, Task.Context ctx, Callback cb) {
        try {
            Scheduler sc = ctx.scheduler();
            TaskConnection conn = ctx.connection();
            TaskConnectionRef cancelable = TaskConnectionRef$.MODULE$.apply();
            conn.push((Task<BoxedUnit>)cancelable.cancel(), sc);
            SyncIO syncIO = F$3.runCancelable(fa$2, new TaskConversions.CreateCallback(conn, cb, sc));
            cancelable.$colon$eq(MODULE$.fromEffect((Object)syncIO.unsafeRunSync(), (Effect)F$3), sc);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                ctx.scheduler().reportFailure(throwable2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private TaskConversions$() {
        MODULE$ = this;
    }
}

