/*
 * Decompiled with CFR 0.152.
 */
package tech.beshu.ror.audit.instances;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import org.json.JSONObject;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import tech.beshu.ror.audit.AuditLogSerializer;
import tech.beshu.ror.audit.AuditRequestContext;
import tech.beshu.ror.audit.AuditResponseContext;
import tech.beshu.ror.audit.AuditResponseContext$Verbosity$Error$;
import tech.beshu.ror.audit.AuditResponseContext$Verbosity$Info$;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u001b\tIB)\u001a4bk2$\u0018)\u001e3ji2{wmU3sS\u0006d\u0017N_3s\u0015\t\u0019A!A\u0005j]N$\u0018M\\2fg*\u0011QAB\u0001\u0006CV$\u0017\u000e\u001e\u0006\u0003\u000f!\t1A]8s\u0015\tI!\"A\u0003cKNDWOC\u0001\f\u0003\u0011!Xm\u00195\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0005\u0013\t9BA\u0001\nBk\u0012LG\u000fT8h'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\n}\t!\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;feV\t\u0001\u0005\u0005\u0002\"Q5\t!E\u0003\u0002$I\u00051am\u001c:nCRT!!\n\u0014\u0002\tQLW.\u001a\u0006\u0002O\u0005!!.\u0019<b\u0013\tI#EA\tECR,G+[7f\r>\u0014X.\u0019;uKJDaa\u000b\u0001!\u0002\u0013\u0001\u0013a\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\u0004\u0003\"B\u0017\u0001\t\u0003r\u0013AC8o%\u0016\u001c\bo\u001c8tKR\u0011qF\u000f\t\u0004\u001fA\u0012\u0014BA\u0019\u0011\u0005\u0019y\u0005\u000f^5p]B\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0005UN|gNC\u00018\u0003\ry'oZ\u0005\u0003sQ\u0012!BS*P\u001d>\u0013'.Z2u\u0011\u0015YD\u00061\u0001=\u0003=\u0011Xm\u001d9p]N,7i\u001c8uKb$\bCA\u000b>\u0013\tqDA\u0001\u000bBk\u0012LGOU3ta>t7/Z\"p]R,\u0007\u0010\u001e\u0005\u0006\u0001\u0002!I!Q\u0001\fGJ,\u0017\r^3F]R\u0014\u0018\u0010F\u00043\u0005\u001e#fk\u00183\t\u000b\r{\u0004\u0019\u0001#\u0002\u000f5\fGo\u00195fIB\u0011q\"R\u0005\u0003\rB\u0011qAQ8pY\u0016\fg\u000eC\u0003I\u007f\u0001\u0007\u0011*\u0001\u0006gS:\fGn\u0015;bi\u0016\u0004\"AS)\u000f\u0005-{\u0005C\u0001'\u0011\u001b\u0005i%B\u0001(\r\u0003\u0019a$o\\8u}%\u0011\u0001\u000bE\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q!!)Qk\u0010a\u0001\u0013\u00061!/Z1t_:DQaV A\u0002a\u000b\u0001\u0002Z;sCRLwN\u001c\t\u00033vk\u0011A\u0017\u0006\u0003/nS!\u0001\u0018\t\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002_5\nqa)\u001b8ji\u0016$UO]1uS>t\u0007\"\u00021@\u0001\u0004\t\u0017A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0003+\tL!a\u0019\u0003\u0003'\u0005+H-\u001b;SKF,Xm\u001d;D_:$X\r\u001f;\t\u000b\u0015|\u0004\u0019\u00014\u0002\u000b\u0015\u0014(o\u001c:\u0011\u0007=\u0001t\r\u0005\u0002i[:\u0011\u0011n\u001b\b\u0003\u0019*L\u0011!E\u0005\u0003YB\tq\u0001]1dW\u0006<W-\u0003\u0002o_\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003YB\u0001")
public class DefaultAuditLogSerializer
implements AuditLogSerializer {
    private final DateTimeFormatter timestampFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneId.of("GMT"));

    private DateTimeFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    @Override
    public Option<JSONObject> onResponse(AuditResponseContext responseContext) {
        Some some;
        AuditResponseContext auditResponseContext = responseContext;
        if (auditResponseContext instanceof AuditResponseContext.Allowed) {
            None$ none$;
            AuditResponseContext.Allowed allowed = (AuditResponseContext.Allowed)auditResponseContext;
            AuditRequestContext requestContext = allowed.requestContext();
            AuditResponseContext.Verbosity verbosity = allowed.verbosity();
            String reason = allowed.reason();
            AuditResponseContext.Verbosity verbosity2 = verbosity;
            if (AuditResponseContext$Verbosity$Info$.MODULE$.equals(verbosity2)) {
                none$ = new Some((Object)this.createEntry(true, "ALLOWED", reason, responseContext.duration(), requestContext, (Option<Throwable>)None$.MODULE$));
            } else if (AuditResponseContext$Verbosity$Error$.MODULE$.equals(verbosity2)) {
                none$ = None$.MODULE$;
            } else {
                throw new MatchError((Object)verbosity2);
            }
            some = none$;
        } else if (auditResponseContext instanceof AuditResponseContext.ForbiddenBy) {
            AuditResponseContext.ForbiddenBy forbiddenBy = (AuditResponseContext.ForbiddenBy)auditResponseContext;
            AuditRequestContext requestContext = forbiddenBy.requestContext();
            String reason = forbiddenBy.reason();
            some = new Some((Object)this.createEntry(true, "FORBIDDEN", reason, responseContext.duration(), requestContext, (Option<Throwable>)None$.MODULE$));
        } else if (auditResponseContext instanceof AuditResponseContext.Forbidden) {
            AuditResponseContext.Forbidden forbidden = (AuditResponseContext.Forbidden)auditResponseContext;
            AuditRequestContext requestContext = forbidden.requestContext();
            some = new Some((Object)this.createEntry(false, "FORBIDDEN", "default", responseContext.duration(), requestContext, (Option<Throwable>)None$.MODULE$));
        } else if (auditResponseContext instanceof AuditResponseContext.Errored) {
            AuditResponseContext.Errored errored = (AuditResponseContext.Errored)auditResponseContext;
            AuditRequestContext requestContext = errored.requestContext();
            Throwable cause = errored.cause();
            some = new Some((Object)this.createEntry(false, "ERRORED", "error", responseContext.duration(), requestContext, (Option<Throwable>)new Some((Object)cause)));
        } else {
            throw new MatchError((Object)auditResponseContext);
        }
        return some;
    }

    private JSONObject createEntry(boolean matched, String finalState, String reason, FiniteDuration duration, AuditRequestContext requestContext, Option<Throwable> error) {
        return new JSONObject().put("match", matched).put("block", (Object)reason).put("id", (Object)requestContext.id()).put("final_state", (Object)finalState).put("@timestamp", (Object)this.timestampFormatter().format(requestContext.timestamp())).put("processingMillis", duration.toMillis()).put("error_type", error.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getClass().getSimpleName()).orNull(Predef$.MODULE$.$conforms())).put("error_message", error.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getMessage()).orNull(Predef$.MODULE$.$conforms())).put("content_len", (Object)requestContext.contentLength()).put("content_len_kb", Predef$.MODULE$.Integer2int(requestContext.contentLength()) / 1024).put("type", (Object)requestContext.type()).put("origin", (Object)requestContext.remoteAddress()).put("destination", (Object)requestContext.localAddress()).put("xff", requestContext.headers().get((Object)"X-Forwarded-For").orNull(Predef$.MODULE$.$conforms())).put("task_id", requestContext.taskId()).put("req_method", (Object)requestContext.httpMethod()).put("headers", (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requestContext.headers().keys().toList()).asJava()).put("path", (Object)requestContext.uriPath()).put("user", requestContext.loggedInUserName().orNull(Predef$.MODULE$.$conforms())).put("action", (Object)requestContext.action()).put("indices", requestContext.involvesIndices() ? (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requestContext.indices().toList()).asJava() : (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()).put("acl_history", (Object)requestContext.history());
    }
}

