/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.sttp;

import com.softwaremill.sttp.BasicRequestBody;
import com.softwaremill.sttp.BasicResponseAs;
import com.softwaremill.sttp.ByteArrayBody;
import com.softwaremill.sttp.ByteBufferBody;
import com.softwaremill.sttp.FileBody;
import com.softwaremill.sttp.FileHelpers$;
import com.softwaremill.sttp.HeaderNames$;
import com.softwaremill.sttp.HttpURLConnectionBackend$;
import com.softwaremill.sttp.IdMonad$;
import com.softwaremill.sttp.IgnoreResponse$;
import com.softwaremill.sttp.InputStreamBody;
import com.softwaremill.sttp.MappedResponseAs;
import com.softwaremill.sttp.Method;
import com.softwaremill.sttp.MonadError;
import com.softwaremill.sttp.Multipart;
import com.softwaremill.sttp.MultipartBody;
import com.softwaremill.sttp.NoBody$;
import com.softwaremill.sttp.RequestBody;
import com.softwaremill.sttp.RequestT;
import com.softwaremill.sttp.Response;
import com.softwaremill.sttp.ResponseAs;
import com.softwaremill.sttp.ResponseAsByteArray$;
import com.softwaremill.sttp.ResponseAsFile;
import com.softwaremill.sttp.ResponseAsStream;
import com.softwaremill.sttp.ResponseAsString;
import com.softwaremill.sttp.ResponseMetadata;
import com.softwaremill.sttp.ResponseMetadata$;
import com.softwaremill.sttp.StreamBody;
import com.softwaremill.sttp.StringBody;
import com.softwaremill.sttp.SttpBackend;
import com.softwaremill.sttp.SttpBackendOptions;
import com.softwaremill.sttp.Uri;
import com.softwaremill.sttp.internal.SttpFile;
import com.softwaremill.sttp.internal.SttpFile$;
import com.softwaremill.sttp.internal.package$;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.file.Files;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\r\u001b\u0001\u0005B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!)\u0011\n\u0001C\u0005\u0015\")a\n\u0001C!\u001f\"9\u0011\r\u0001b\u0001\n\u0003\u0012\u0007B\u00024\u0001A\u0003%1\rC\u0003h\u0001\u0011%\u0001\u000eC\u0003o\u0001\u0011%q\u000eC\u0004\u0002\u0002\u0001!I!a\u0001\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u00024!9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0003bBA)\u0001\u0011%\u00111\u000b\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\tY\f\u0001C\u0005\u0003{Cq!!1\u0001\t\u0013\t\u0019\rC\u0004\u0002L\u0002!\t%!4\b\u000f\u0005='\u0004#\u0001\u0002R\u001a1\u0011D\u0007E\u0001\u0003'Da!\u0013\u000b\u0005\u0002\u0005U\u0007bBAl)\u0011\u0005\u0011\u0011\u001c\u0005\n\u0003C$\u0012\u0013!C\u0001\u0003GD\u0011\"!?\u0015#\u0003%\t!a?\u00031!#H\u000f]+S\u0019\u000e{gN\\3di&|gNQ1dW\u0016tGM\u0003\u0002\u001c9\u0005!1\u000f\u001e;q\u0015\tib$\u0001\u0007t_\u001a$x/\u0019:f[&dGNC\u0001 \u0003\r\u0019w.\\\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\t%RCfM\u0007\u00025%\u00111F\u0007\u0002\f'R$\bOQ1dW\u0016tG\r\u0005\u0002.a9\u0011\u0011FL\u0005\u0003_i\tq\u0001]1dW\u0006<W-\u0003\u00022e\t\u0011\u0011\n\u001a\u0006\u0003_i\u0001\"a\t\u001b\n\u0005U\"#a\u0002(pi\"LgnZ\u0001\u0005_B$8\u000f\u0005\u0002*q%\u0011\u0011H\u0007\u0002\u0013'R$\bOQ1dW\u0016tGm\u00149uS>t7/A\ndkN$x.\\5{K\u000e{gN\\3di&|g\u000e\u0005\u0003$yy2\u0015BA\u001f%\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006\u0019a.\u001a;\u000b\u0003\r\u000bAA[1wC&\u0011Q\t\u0011\u0002\u0012\u0011R$\b/\u0016*M\u0007>tg.Z2uS>t\u0007CA\u0012H\u0013\tAEE\u0001\u0003V]&$\u0018A\u0002\u001fj]&$h\bF\u0002L\u00196\u0003\"!\u000b\u0001\t\u000bY\u001a\u0001\u0019A\u001c\t\u000bi\u001a\u0001\u0019A\u001e\u0002\tM,g\u000eZ\u000b\u0003!Z#\"!\u0015/\u0011\u0007%\u0012F+\u0003\u0002T5\tA!+Z:q_:\u001cX\r\u0005\u0002V-2\u0001A!B,\u0005\u0005\u0004A&!\u0001+\u0012\u0005MJ\u0006CA\u0012[\u0013\tYFEA\u0002B]fDQ!\u0018\u0003A\u0002y\u000b\u0011A\u001d\t\u0005[}#6'\u0003\u0002ae\t9!+Z9vKN$\u0018!\u0004:fgB|gn]3N_:\fG-F\u0001d!\rIC\rL\u0005\u0003Kj\u0011!\"T8oC\u0012,%O]8s\u00039\u0011Xm\u001d9p]N,Wj\u001c8bI\u0002\nab\u001c9f]\u000e{gN\\3di&|g\u000e\u0006\u0002?S\")!n\u0002a\u0001W\u0006\u0019QO]5\u0011\u0005%b\u0017BA7\u001b\u0005\r)&/[\u0001\noJLG/\u001a\"pIf$2\u0001]=\u007f!\r\u0019\u0013o]\u0005\u0003e\u0012\u0012aa\u00149uS>t\u0007C\u0001;x\u001b\u0005)(B\u0001<C\u0003\tIw.\u0003\u0002yk\naq*\u001e;qkR\u001cFO]3b[\")!\u0010\u0003a\u0001w\u0006!!m\u001c3z!\rICpM\u0005\u0003{j\u00111BU3rk\u0016\u001cHOQ8es\")q\u0010\u0003a\u0001}\u0005\t1-A\u0004uS6,w.\u001e;\u0015\t\u0005\u0015\u00111\u0002\t\u0004G\u0005\u001d\u0011bAA\u0005I\t\u0019\u0011J\u001c;\t\u000f\u00055\u0011\u00021\u0001\u0002\u0010\u0005\tA\u000f\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0011\u0011,(/\u0019;j_:T1!!\u0007%\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003;\t\u0019B\u0001\u0005EkJ\fG/[8o\u000399(/\u001b;f\u0005\u0006\u001c\u0018n\u0019\"pIf$RARA\u0012\u0003WAaA\u001f\u0006A\u0002\u0005\u0015\u0002cA\u0015\u0002(%\u0019\u0011\u0011\u0006\u000e\u0003!\t\u000b7/[2SKF,Xm\u001d;C_\u0012L\bBBA\u0017\u0015\u0001\u00071/\u0001\u0002pg\u0006i!i\\;oI\u0006\u0014\u0018p\u00115beN,\"!a\r\u0011\u000b\r\n)$!\u000f\n\u0007\u0005]BEA\u0003BeJ\f\u0017\u0010E\u0002$\u0003wI1!!\u0010%\u0005\u0011\u0019\u0005.\u0019:\u0002\u001d\t{WO\u001c3bef\u001c\u0005.\u0019:tA\u0005\u00012/\u001a;Nk2$\u0018\u000e]1si\n{G-\u001f\u000b\u0006a\u0006\u0015\u0013q\n\u0005\b\u0003\u000fj\u0001\u0019AA%\u0003\ti\u0007\u000fE\u0002*\u0003\u0017J1!!\u0014\u001b\u00055iU\u000f\u001c;ja\u0006\u0014HOQ8es\")q0\u0004a\u0001}\u0005a!/Z1e%\u0016\u001c\bo\u001c8tKV!\u0011QKA.))\t9&!\u0018\u0002`\u0005%\u00141\u000f\t\u0005SI\u000bI\u0006E\u0002V\u00037\"Qa\u0016\bC\u0002aCQa \bA\u0002yBq!!\u0019\u000f\u0001\u0004\t\u0019'\u0001\u0002jgB\u0019A/!\u001a\n\u0007\u0005\u001dTOA\u0006J]B,Ho\u0015;sK\u0006l\u0007bBA6\u001d\u0001\u0007\u0011QN\u0001\u000be\u0016\u001c\bo\u001c8tK\u0006\u001b\bCB\u0015\u0002p\u0005e3'C\u0002\u0002ri\u0011!BU3ta>t7/Z!t\u0011\u001d\t)H\u0004a\u0001\u0003o\na\u0002]1sg\u0016\u001cuN\u001c3ji&|g\u000e\u0005\u0004$y\u0005e\u0014q\u0010\t\u0004[\u0005m\u0014bAA?e\tQ1\u000b^1ukN\u001cu\u000eZ3\u0011\u0007\r\n\t)C\u0002\u0002\u0004\u0012\u0012qAQ8pY\u0016\fg.\u0001\tsK\u0006$'+Z:q_:\u001cXMQ8esV!\u0011\u0011RAG))\tY)a$\u0002\u0012\u0006U\u0015\u0011\u0017\t\u0004+\u00065E!B,\u0010\u0005\u0004A\u0006bBA1\u001f\u0001\u0007\u00111\r\u0005\b\u0003Wz\u0001\u0019AAJ!\u0019I\u0013qNAFg!9\u0011qS\bA\u0002\u0005e\u0015aB2iCJ\u001cX\r\u001e\t\u0005GE\fY\n\u0005\u0003\u0002\u001e\u0006-f\u0002BAP\u0003O\u00032!!)%\u001b\t\t\u0019KC\u0002\u0002&\u0002\na\u0001\u0010:p_Rt\u0014bAAUI\u00051\u0001K]3eK\u001aLA!!,\u00020\n11\u000b\u001e:j]\u001eT1!!+%\u0011\u001d\t\u0019l\u0004a\u0001\u0003k\u000bq\u0001[3bI\u0016\u00148\u000fE\u0002*\u0003oK1!!/\u001b\u0005A\u0011Vm\u001d9p]N,W*\u001a;bI\u0006$\u0018-A\biC:$G.\u001a(vY2Le\u000e];u)\u0011\t\u0019'a0\t\u000f\u0005\u0005\u0004\u00031\u0001\u0002d\u0005IqO]1q\u0013:\u0004X\u000f\u001e\u000b\u0007\u0003G\n)-!3\t\u000f\u0005\u001d\u0017\u00031\u0001\u0002\u001a\u0006y1m\u001c8uK:$XI\\2pI&tw\rC\u0004\u0002bE\u0001\r!a\u0019\u0002\u000b\rdwn]3\u0015\u0003\u0019\u000b\u0001\u0004\u0013;uaV\u0013FjQ8o]\u0016\u001cG/[8o\u0005\u0006\u001c7.\u001a8e!\tICc\u0005\u0002\u0015EQ\u0011\u0011\u0011[\u0001\u0006CB\u0004H.\u001f\u000b\u0006Q\u0005m\u0017q\u001c\u0005\t\u0003;4\u0002\u0013!a\u0001o\u00059q\u000e\u001d;j_:\u001c\bb\u0002\u001e\u0017!\u0003\u0005\raO\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u001d\u0016\u0004o\u0005\u001d8FAAu!\u0011\tY/!>\u000e\u0005\u00055(\u0002BAx\u0003c\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005MH%\u0001\u0006b]:|G/\u0019;j_:LA!a>\u0002n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*\"!!@+\u0007m\n9\u000f")
public class HttpURLConnectionBackend
implements SttpBackend<Object, Nothing$> {
    private final SttpBackendOptions opts;
    private final Function1<HttpURLConnection, BoxedUnit> customizeConnection;
    private final MonadError<Object> responseMonad;
    private final char[] BoundaryChars;
    private volatile byte bitmap$init$0;

    public static Function1<HttpURLConnection, BoxedUnit> apply$default$2() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$2();
    }

    public static SttpBackendOptions apply$default$1() {
        return HttpURLConnectionBackend$.MODULE$.apply$default$1();
    }

    public static SttpBackend<Object, Nothing$> apply(SttpBackendOptions sttpBackendOptions, Function1<HttpURLConnection, BoxedUnit> function1) {
        return HttpURLConnectionBackend$.MODULE$.apply(sttpBackendOptions, function1);
    }

    @Override
    public <T> Response<T> send(RequestT<Object, T, Nothing$> r) {
        Response<T> response;
        HttpURLConnection c = this.openConnection((Uri)r.uri());
        c.setRequestMethod(((Method)r.method()).m());
        r.headers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HttpURLConnectionBackend.$anonfun$send$1(c, x0$1);
            return BoxedUnit.UNIT;
        });
        c.setDoInput(true);
        c.setReadTimeout(this.timeout(r.options().readTimeout()));
        c.setConnectTimeout(this.timeout((Duration)this.opts.connectionTimeout()));
        c.setInstanceFollowRedirects(false);
        this.customizeConnection.apply((Object)c);
        RequestBody<Nothing$> requestBody = r.body();
        NoBody$ noBody$ = NoBody$.MODULE$;
        if (requestBody == null ? noBody$ != null : !requestBody.equals(noBody$)) {
            c.setDoOutput(true);
            this.writeBody(r.body(), c).foreach((Function1 & Serializable & scala.Serializable)os -> {
                HttpURLConnectionBackend.$anonfun$send$2(os);
                return BoxedUnit.UNIT;
            });
        }
        try {
            InputStream is = c.getInputStream();
            response = this.readResponse(c, is, r.response(), r.options().parseResponseIf());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof CharacterCodingException) {
                CharacterCodingException characterCodingException = (CharacterCodingException)throwable2;
                throw characterCodingException;
            }
            if (throwable2 instanceof UnsupportedEncodingException) {
                UnsupportedEncodingException unsupportedEncodingException = (UnsupportedEncodingException)throwable2;
                throw unsupportedEncodingException;
            }
            if (!(throwable2 instanceof IOException) || c.getResponseCode() == -1) {
                throw throwable;
            }
            Response<T> response2 = this.readResponse(c, c.getErrorStream(), r.response(), r.options().parseResponseIf());
            response = response2;
        }
        return response;
    }

    @Override
    public MonadError<Object> responseMonad() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/jenkins/workspace/Release/sttp-release/core/jvm/src/main/scala/com/softwaremill/sttp/HttpURLConnectionBackend.scala: 56");
        }
        return this.responseMonad;
    }

    private HttpURLConnection openConnection(Uri uri) {
        URLConnection uRLConnection;
        Some some;
        SttpBackendOptions.Proxy p;
        URL url = new URL(uri.toString());
        Option<SttpBackendOptions.Proxy> option = this.opts.proxy();
        if (option instanceof Some && !(p = (SttpBackendOptions.Proxy)(some = (Some)option).value()).ignoreProxy(uri.host())) {
            p.auth().foreach((Function1 & Serializable & scala.Serializable)proxyAuth -> {
                HttpURLConnectionBackend.$anonfun$openConnection$1(proxyAuth);
                return BoxedUnit.UNIT;
            });
            uRLConnection = url.openConnection(p.asJavaProxy());
        } else {
            uRLConnection = url.openConnection();
        }
        URLConnection conn = uRLConnection;
        return (HttpURLConnection)conn;
    }

    private Option<OutputStream> writeBody(RequestBody<Nothing$> body, HttpURLConnection c) {
        Option<OutputStream> option;
        RequestBody<Nothing$> requestBody = body;
        if (NoBody$.MODULE$.equals(requestBody)) {
            option = None$.MODULE$;
        } else if (requestBody instanceof BasicRequestBody) {
            BasicRequestBody basicRequestBody = (BasicRequestBody)requestBody;
            OutputStream os = c.getOutputStream();
            this.writeBasicBody(basicRequestBody, os);
            option = new Some((Object)os);
        } else if (requestBody instanceof StreamBody) {
            option = None$.MODULE$;
        } else if (requestBody instanceof MultipartBody) {
            MultipartBody multipartBody = (MultipartBody)requestBody;
            option = this.setMultipartBody(multipartBody, c);
        } else {
            throw new MatchError(requestBody);
        }
        return option;
    }

    private int timeout(Duration t) {
        return t.isFinite() ? (int)t.toMillis() : 0;
    }

    private void writeBasicBody(BasicRequestBody body, OutputStream os) {
        BasicRequestBody basicRequestBody = body;
        if (basicRequestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)basicRequestBody;
            String b = stringBody.s();
            String encoding = stringBody.encoding();
            OutputStreamWriter writer = new OutputStreamWriter(os, encoding);
            writer.write(b);
            writer.flush();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (basicRequestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)basicRequestBody;
            byte[] b = byteArrayBody.b();
            os.write(b);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (basicRequestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)basicRequestBody;
            ByteBuffer b = byteBufferBody.b();
            WritableByteChannel channel = Channels.newChannel(os);
            channel.write(b);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (basicRequestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)basicRequestBody;
            InputStream b = inputStreamBody.b();
            package$.MODULE$.transfer(b, os);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (basicRequestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)basicRequestBody;
            SttpFile f = fileBody.f();
            Files.copy(f.toPath(), os);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)basicRequestBody);
        }
    }

    private char[] BoundaryChars() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/jenkins/workspace/Release/sttp-release/core/jvm/src/main/scala/com/softwaremill/sttp/HttpURLConnectionBackend.scala: 125");
        }
        return this.BoundaryChars;
    }

    private Option<OutputStream> setMultipartBody(MultipartBody mp, HttpURLConnection c) {
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        String boundary = ((TraversableOnce)List$.MODULE$.fill(32, (Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> this.BoundaryChars()[tlr.nextInt(this.BoundaryChars().length)])).mkString();
        Seq partsWithHeaders = (Seq)mp.parts().map((Function1 & Serializable & scala.Serializable)p -> {
            String contentDisposition = new StringBuilder(2).append(HeaderNames$.MODULE$.ContentDisposition()).append(": ").append(p.contentDispositionHeaderValue()).toString();
            Option contentTypeHeader = p.contentType().map((Function1 & Serializable & scala.Serializable)ct -> new StringBuilder(2).append(HeaderNames$.MODULE$.ContentType()).append(": ").append((String)ct).toString());
            Iterable otherHeaders = (Iterable)p.additionalHeaders().map((Function1 & Serializable & scala.Serializable)h -> new StringBuilder(2).append(h._1()).append(": ").append(h._2()).toString(), Iterable$.MODULE$.canBuildFrom());
            List allHeaders = (List)((List)new .colon.colon((Object)contentDisposition, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)contentTypeHeader.toList(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)otherHeaders, List$.MODULE$.canBuildFrom());
            return new Tuple2((Object)allHeaders.mkString(package$.MODULE$.CrLf()), p);
        }, Seq$.MODULE$.canBuildFrom());
        String dashes = "--";
        long dashesLen = dashes.length();
        long crLfLen = package$.MODULE$.CrLf().length();
        long boundaryLen = boundary.length();
        long finalBoundaryLen = dashesLen + boundaryLen + dashesLen + crLfLen;
        Option contentLength = (Option)((TraversableOnce)partsWithHeaders.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            None$ none$;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String headers = (String)tuple2._1();
            Multipart p = (Multipart)tuple2._2();
            BasicRequestBody basicRequestBody = p.body();
            if (basicRequestBody instanceof StringBody) {
                StringBody stringBody = (StringBody)basicRequestBody;
                String b = stringBody.s();
                String encoding = stringBody.encoding();
                none$ = new Some((Object)BoxesRunTime.boxToLong((long)b.getBytes(encoding).length));
            } else if (basicRequestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)basicRequestBody;
                byte[] b = byteArrayBody.b();
                none$ = new Some((Object)BoxesRunTime.boxToLong((long)b.length));
            } else if (basicRequestBody instanceof ByteBufferBody) {
                none$ = None$.MODULE$;
            } else if (basicRequestBody instanceof InputStreamBody) {
                none$ = None$.MODULE$;
            } else {
                if (!(basicRequestBody instanceof FileBody)) throw new MatchError((Object)basicRequestBody);
                FileBody fileBody = (FileBody)basicRequestBody;
                SttpFile b = fileBody.f();
                none$ = new Some((Object)BoxesRunTime.boxToLong((long)b.toFile().length()));
            }
            None$ bodyLen = none$;
            int headersLen = headers.getBytes(package$.MODULE$.Iso88591()).length;
            return bodyLen.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)bl -> dashesLen + boundaryLen + crLfLen + (long)headersLen + crLfLen + crLfLen + bl + crLfLen);
        }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)finalBoundaryLen)), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
            if (tuple2 == null) return None$.MODULE$;
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (!(option instanceof Some)) return None$.MODULE$;
            Some some = (Some)option;
            long acc = BoxesRunTime.unboxToLong((Object)some.value());
            if (!(option2 instanceof Some)) return None$.MODULE$;
            Some some2 = (Some)option2;
            long l = BoxesRunTime.unboxToLong((Object)some2.value());
            return new Some((Object)BoxesRunTime.boxToLong((long)(acc + l)));
        });
        c.setRequestProperty(HeaderNames$.MODULE$.ContentType(), new StringBuilder(30).append("multipart/form-data; boundary=").append(boundary).toString());
        contentLength.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)cl -> {
            c.setFixedLengthStreamingMode(cl);
            c.setRequestProperty(HeaderNames$.MODULE$.ContentLength(), ((Object)BoxesRunTime.boxToLong((long)cl)).toString());
        });
        LongRef total = LongRef.create((long)0L);
        OutputStream os = c.getOutputStream();
        partsWithHeaders.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            HttpURLConnectionBackend.$anonfun$setMultipartBody$9(this, dashes, boundary, os, total, x0$3);
            return BoxedUnit.UNIT;
        });
        HttpURLConnectionBackend.writeMeta$1(dashes, os, total);
        HttpURLConnectionBackend.writeMeta$1(boundary, os, total);
        HttpURLConnectionBackend.writeMeta$1(dashes, os, total);
        HttpURLConnectionBackend.writeMeta$1(package$.MODULE$.CrLf(), os, total);
        return new Some((Object)os);
    }

    private <T> Response<T> readResponse(HttpURLConnection c, InputStream is, ResponseAs<T, Nothing$> responseAs, Function1<Object, Object> parseCondition) {
        Vector headers = (Vector)((TraversableLike)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(c.getHeaderFields()).asScala()).toVector().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HttpURLConnectionBackend.$anonfun$readResponse$1(x$1)))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            java.util.List vv = (java.util.List)tuple2._2();
            Buffer buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(vv).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> new Tuple2((Object)k, x$2), Buffer$.MODULE$.canBuildFrom());
            return buffer;
        }, Vector$.MODULE$.canBuildFrom());
        Option contentEncoding = Option$.MODULE$.apply((Object)c.getHeaderField(HeaderNames$.MODULE$.ContentEncoding()));
        Option charsetFromHeaders = Option$.MODULE$.apply((Object)c.getHeaderField(HeaderNames$.MODULE$.ContentType())).flatMap((Function1 & Serializable & scala.Serializable)ct -> package$.MODULE$.encodingFromContentType((String)ct));
        int code = c.getResponseCode();
        InputStream wrappedIs = this.wrapInput((Option<String>)contentEncoding, this.handleNullInput(is));
        ResponseMetadata responseMetadata = ResponseMetadata$.MODULE$.apply((Seq<Tuple2<String, String>>)headers, code, c.getResponseMessage());
        Right body = parseCondition.apply$mcZI$sp(code) ? scala.package$.MODULE$.Right().apply(this.readResponseBody(wrappedIs, responseAs, (Option<String>)charsetFromHeaders, responseMetadata)) : scala.package$.MODULE$.Left().apply((Object)this.readResponseBody(wrappedIs, com.softwaremill.sttp.package$.MODULE$.asByteArray(), (Option<String>)charsetFromHeaders, responseMetadata));
        return new Response(body, code, c.getResponseMessage(), (Seq<Tuple2<String, String>>)headers, (List<Response<BoxedUnit>>)Nil$.MODULE$);
    }

    private <T> T readResponseBody(InputStream is, ResponseAs<T, Nothing$> responseAs, Option<String> charset, ResponseMetadata headers) {
        Object object;
        ResponseAs<T, Nothing$> responseAs2 = responseAs;
        if (responseAs2 instanceof MappedResponseAs) {
            MappedResponseAs mappedResponseAs = (MappedResponseAs)responseAs2;
            BasicResponseAs raw = mappedResponseAs.raw();
            Function2 g = mappedResponseAs.g();
            object = g.apply(this.readResponseBody(is, raw, charset, headers), (Object)headers);
        } else if (IgnoreResponse$.MODULE$.equals(responseAs2)) {
            this.consume$1(is);
            object = BoxedUnit.UNIT;
        } else if (responseAs2 instanceof ResponseAsString) {
            ResponseAsString responseAsString = (ResponseAsString)responseAs2;
            String enc = responseAsString.encoding();
            object = HttpURLConnectionBackend.asString$1(enc, is, charset);
        } else if (ResponseAsByteArray$.MODULE$.equals(responseAs2)) {
            object = package$.MODULE$.toByteArray(is);
        } else {
            if (responseAs2 instanceof ResponseAsStream) {
                throw new IllegalStateException();
            }
            if (responseAs2 instanceof ResponseAsFile) {
                ResponseAsFile responseAsFile = (ResponseAsFile)responseAs2;
                SttpFile output = responseAsFile.output();
                boolean overwrite = responseAsFile.overwrite();
                File f = FileHelpers$.MODULE$.saveFile(output.toFile(), is, overwrite);
                object = SttpFile$.MODULE$.fromFile(f);
            } else {
                throw new MatchError(responseAs2);
            }
        }
        return (T)object;
    }

    private InputStream handleNullInput(InputStream is) {
        return is == null ? new ByteArrayInputStream((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())) : is;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream wrapInput(Option<String> contentEncoding, InputStream is) {
        String string;
        boolean bl = false;
        Some some = null;
        Option option = contentEncoding.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toLowerCase());
        if (None$.MODULE$.equals(option)) {
            return is;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string2 = (String)some.value();
            if ("gzip".equals(string2)) {
                return new GZIPInputStream(is);
            }
        }
        if (bl && "deflate".equals(string = (String)some.value())) {
            return new InflaterInputStream(is);
        }
        if (!bl) throw new MatchError((Object)option);
        String ce = (String)some.value();
        throw new UnsupportedEncodingException(new StringBuilder(22).append("Unsupported encoding: ").append(ce).toString());
    }

    @Override
    public void close() {
    }

    public static final /* synthetic */ void $anonfun$send$1(HttpURLConnection c$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        c$1.setRequestProperty(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$send$2(OutputStream os) {
        os.flush();
        os.close();
    }

    public static final /* synthetic */ void $anonfun$openConnection$1(SttpBackendOptions.ProxyAuth proxyAuth) {
        Authenticator.setDefault(new Authenticator(null, proxyAuth){
            private final SttpBackendOptions.ProxyAuth proxyAuth$1;

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(this.proxyAuth$1.username(), this.proxyAuth$1.password().toCharArray());
            }
            {
                this.proxyAuth$1 = proxyAuth$1;
            }
        });
    }

    private static final void writeMeta$1(String s, OutputStream os$1, LongRef total$1) {
        os$1.write(s.getBytes(package$.MODULE$.Iso88591()));
        total$1.elem += (long)s.getBytes(package$.MODULE$.Iso88591()).length;
    }

    public static final /* synthetic */ void $anonfun$setMultipartBody$9(HttpURLConnectionBackend $this, String dashes$1, String boundary$1, OutputStream os$1, LongRef total$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String headers = (String)tuple2._1();
        Multipart p = (Multipart)tuple2._2();
        HttpURLConnectionBackend.writeMeta$1(dashes$1, os$1, total$1);
        HttpURLConnectionBackend.writeMeta$1(boundary$1, os$1, total$1);
        HttpURLConnectionBackend.writeMeta$1(package$.MODULE$.CrLf(), os$1, total$1);
        HttpURLConnectionBackend.writeMeta$1(headers, os$1, total$1);
        HttpURLConnectionBackend.writeMeta$1(package$.MODULE$.CrLf(), os$1, total$1);
        HttpURLConnectionBackend.writeMeta$1(package$.MODULE$.CrLf(), os$1, total$1);
        $this.writeBasicBody(p.body(), os$1);
        HttpURLConnectionBackend.writeMeta$1(package$.MODULE$.CrLf(), os$1, total$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$readResponse$1(Tuple2 x$1) {
        return x$1._1() != null;
    }

    private static final String asString$1(String enc, InputStream is$1, Option charset$1) {
        return Source$.MODULE$.fromInputStream(is$1, (String)charset$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> enc)).mkString();
    }

    private final void consume$1(InputStream is$1) {
        while (is$1.read() != -1) {
        }
    }

    public HttpURLConnectionBackend(SttpBackendOptions opts, Function1<HttpURLConnection, BoxedUnit> customizeConnection) {
        this.opts = opts;
        this.customizeConnection = customizeConnection;
        this.responseMonad = IdMonad$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.BoundaryChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

