/*
 * Decompiled with CFR 0.152.
 */
package io.circe.yaml.parser;

import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonNumber$;
import io.circe.JsonObject$;
import io.circe.ParsingFailure;
import io.circe.yaml.parser.package;
import io.circe.yaml.parser.package$CustomTag$;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.util.Either;
import scala.util.Right;

public final class package$ {
    public static package$ MODULE$;
    private final package.FlatteningConstructor flattener;

    static {
        new package$();
    }

    public Either<ParsingFailure, Json> parse(Reader yaml) {
        return this.parseSingle(yaml).flatMap((Function1 & Serializable & scala.Serializable)parsed -> MODULE$.yamlToJson((Node)parsed).map((Function1 & Serializable & scala.Serializable)json -> json));
    }

    public Either<ParsingFailure, Json> parse(String yaml) {
        return this.parse(new StringReader(yaml));
    }

    public Stream<Either<ParsingFailure, Json>> parseDocuments(Reader yaml) {
        return (Stream)this.parseStream(yaml).map((Function1 & Serializable & scala.Serializable)node -> MODULE$.yamlToJson((Node)node), Stream$.MODULE$.canBuildFrom());
    }

    public Stream<Either<ParsingFailure, Json>> parseDocuments(String yaml) {
        return this.parseDocuments(new StringReader(yaml));
    }

    private Either<ParsingFailure, Node> parseSingle(Reader reader) {
        return EitherOps$.MODULE$.leftMap$extension(package.either$.MODULE$.catsSyntaxEither(EitherObjectOps$.MODULE$.catchNonFatal$extension(package.either$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Function0 & Serializable & scala.Serializable)() -> new Yaml().compose(reader))), (Function1 & Serializable & scala.Serializable)err -> new ParsingFailure(err.getMessage(), err));
    }

    private Stream<Node> parseStream(Reader reader) {
        return ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(new Yaml().composeAll(reader)).asScala()).toStream();
    }

    private Either<ParsingFailure, Json> yamlToJson(Node node2) {
        Either either;
        Node node3 = node2;
        if (node3 instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)node3;
            either = ((Either)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.flattener.flatten(mappingNode).getValue()).asScala()).foldLeft((Object)EitherObjectOps$.MODULE$.right$extension(package.either$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)JsonObject$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(objEither, tup) -> objEither.flatMap((Function1 & Serializable & scala.Serializable)obj -> package$.convertKeyNode$1(tup.getKeyNode()).flatMap((Function1 & Serializable & scala.Serializable)key -> MODULE$.yamlToJson(tup.getValueNode()).map((Function1 & Serializable & scala.Serializable)value -> obj.add(key, value)))))).map((Function1 & Serializable & scala.Serializable)value -> Json$.MODULE$.fromJsonObject(value));
        } else if (node3 instanceof SequenceNode) {
            SequenceNode sequenceNode = (SequenceNode)node3;
            either = ((Either)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(sequenceNode.getValue()).asScala()).foldLeft((Object)EitherObjectOps$.MODULE$.right$extension(package.either$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)List$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(arrEither, node) -> arrEither.flatMap((Function1 & Serializable & scala.Serializable)arr -> MODULE$.yamlToJson((Node)node).map((Function1 & Serializable & scala.Serializable)value -> {
                Json json = value;
                return arr.$colon$colon((Object)json);
            })))).map((Function1 & Serializable & scala.Serializable)arr -> Json$.MODULE$.fromValues((Iterable)arr.reverse()));
        } else if (node3 instanceof ScalarNode) {
            ScalarNode scalarNode = (ScalarNode)node3;
            either = package$.convertScalarNode$1(scalarNode);
        } else {
            throw new MatchError((Object)node3);
        }
        return either;
    }

    private static final Either convertScalarNode$1(ScalarNode node) {
        return EitherOps$.MODULE$.leftMap$extension(package.either$.MODULE$.catsSyntaxEither(EitherObjectOps$.MODULE$.catchNonFatal$extension(package.either$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Function0 & Serializable & scala.Serializable)() -> {
            Json json;
            boolean bl;
            Tag tag = node.getTag();
            Tag tag2 = Tag.INT;
            Tag tag3 = tag;
            if (!(tag2 != null ? !tag2.equals(tag3) : tag3 != null)) {
                bl = true;
            } else {
                Tag tag4 = Tag.FLOAT;
                Tag tag5 = tag;
                bl = !(tag4 != null ? !tag4.equals(tag5) : tag5 != null);
            }
            if (bl) {
                json = (Json)JsonNumber$.MODULE$.fromString(node.getValue()).map((Function1 & Serializable & scala.Serializable)value -> Json$.MODULE$.fromJsonNumber(value)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NumberFormatException(new StringBuilder(23).append("Invalid numeric string ").append(node.getValue()).toString());
                });
            } else {
                Tag tag6 = Tag.BOOL;
                Tag tag7 = tag;
                if (!(tag6 != null ? !tag6.equals(tag7) : tag7 != null)) {
                    Object object = package$.MODULE$.flattener.construct(node);
                    if (!(object instanceof Boolean)) {
                        throw new IllegalArgumentException(new StringBuilder(23).append("Invalid boolean string ").append(node.getValue()).toString());
                    }
                    Boolean bl2 = (Boolean)object;
                    boolean bl3 = Predef$.MODULE$.Boolean2boolean(bl2);
                    json = Json$.MODULE$.fromBoolean(bl3);
                } else {
                    Tag tag8 = Tag.NULL;
                    Tag tag9 = tag;
                    if (!(tag8 != null ? !tag8.equals(tag9) : tag9 != null)) {
                        json = Json$.MODULE$.Null();
                    } else {
                        Option<String> option = package$CustomTag$.MODULE$.unapply(tag);
                        if (!option.isEmpty()) {
                            String other = (String)option.get();
                            json = Json$.MODULE$.fromJsonObject(JsonObject$.MODULE$.singleton(new StringOps(Predef$.MODULE$.augmentString(other)).stripPrefix("!"), Json$.MODULE$.fromString(node.getValue())));
                        } else {
                            json = Json$.MODULE$.fromString(node.getValue());
                        }
                    }
                }
            }
            return json;
        })), (Function1 & Serializable & scala.Serializable)err -> new ParsingFailure(err.getMessage(), err));
    }

    private static final Either convertKeyNode$1(Node node) {
        Right right;
        Node node2 = node;
        if (node2 instanceof ScalarNode) {
            ScalarNode scalarNode = (ScalarNode)node2;
            right = scala.package$.MODULE$.Right().apply((Object)scalarNode.getValue());
        } else {
            right = scala.package$.MODULE$.Left().apply((Object)new ParsingFailure("Only string keys can be represented in JSON", null));
        }
        return right;
    }

    private package$() {
        MODULE$ = this;
        this.flattener = new package.FlatteningConstructor();
    }
}

