/*
 * Decompiled with CFR 0.152.
 */
package squants.time;

import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.matching.Regex;
import squants.BaseDimension;
import squants.Dimension;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.time.Days$;
import squants.time.Hours$;
import squants.time.Microseconds$;
import squants.time.Milliseconds$;
import squants.time.Minutes$;
import squants.time.Nanoseconds$;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeUnit;

public final class Time$
implements Dimension<Time>,
BaseDimension,
Serializable {
    public static Time$ MODULE$;
    private final double NanosecondsPerSecond;
    private final double MicrosecondsPerSecond;
    private final double MillisecondsPerNanosecond;
    private final double MillisecondsPerMicrosecond;
    private final double MillisecondsPerSecond;
    private final double MillisecondsPerMinute;
    private final double MillisecondsPerHour;
    private final double MillisecondsPerDay;
    private final double SecondsPerMinute;
    private final double SecondsPerHour;
    private final double SecondsPerDay;
    private final double MinutesPerHour;
    private final double HoursPerDay;
    private Regex squants$Dimension$$QuantityString;
    private volatile boolean bitmap$0;

    static {
        new Time$();
    }

    @Override
    public Option<UnitOfMeasure<Time>> symbolToUnit(String symbol) {
        return Dimension.symbolToUnit$(this, symbol);
    }

    @Override
    public Try<Time> parse(Object value) {
        return Dimension.parse$(this, value);
    }

    @Override
    public Try<Time> parseString(String s) {
        return Dimension.parseString$(this, s);
    }

    @Override
    public <N> Try<Time> parseTuple(Tuple2<N, String> t, Numeric<N> num) {
        return Dimension.parseTuple$(this, t, num);
    }

    private Regex squants$Dimension$$QuantityString$lzycompute() {
        Time$ time$ = this;
        synchronized (time$) {
            if (!this.bitmap$0) {
                this.squants$Dimension$$QuantityString = Dimension.squants$Dimension$$QuantityString$(this);
                this.bitmap$0 = true;
            }
        }
        return this.squants$Dimension$$QuantityString;
    }

    @Override
    public Regex squants$Dimension$$QuantityString() {
        return !this.bitmap$0 ? this.squants$Dimension$$QuantityString$lzycompute() : this.squants$Dimension$$QuantityString;
    }

    public double NanosecondsPerSecond() {
        return this.NanosecondsPerSecond;
    }

    public double MicrosecondsPerSecond() {
        return this.MicrosecondsPerSecond;
    }

    public double MillisecondsPerNanosecond() {
        return this.MillisecondsPerNanosecond;
    }

    public double MillisecondsPerMicrosecond() {
        return this.MillisecondsPerMicrosecond;
    }

    public double MillisecondsPerSecond() {
        return this.MillisecondsPerSecond;
    }

    public double MillisecondsPerMinute() {
        return this.MillisecondsPerMinute;
    }

    public double MillisecondsPerHour() {
        return this.MillisecondsPerHour;
    }

    public double MillisecondsPerDay() {
        return this.MillisecondsPerDay;
    }

    public double SecondsPerMinute() {
        return this.SecondsPerMinute;
    }

    public double SecondsPerHour() {
        return this.SecondsPerHour;
    }

    public double SecondsPerDay() {
        return this.SecondsPerDay;
    }

    public double MinutesPerHour() {
        return this.MinutesPerHour;
    }

    public double HoursPerDay() {
        return this.HoursPerDay;
    }

    public <A> Time apply(A n, TimeUnit unit, Numeric<A> num) {
        return new Time(num.toDouble(n), unit);
    }

    public Try<Time> apply(Object value) {
        return this.parse(value);
    }

    public Time apply(Duration duration) {
        Quantity quantity;
        java.util.concurrent.TimeUnit timeUnit = duration.unit();
        if (((Object)((Object)java.util.concurrent.TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            quantity = Nanoseconds$.MODULE$.apply(BoxesRunTime.boxToLong((long)duration.length()), (Numeric)Numeric.LongIsIntegral$.MODULE$);
        } else if (((Object)((Object)java.util.concurrent.TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            quantity = Microseconds$.MODULE$.apply(BoxesRunTime.boxToLong((long)duration.length()), (Numeric)Numeric.LongIsIntegral$.MODULE$);
        } else if (((Object)((Object)java.util.concurrent.TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            quantity = Milliseconds$.MODULE$.apply(BoxesRunTime.boxToLong((long)duration.length()), (Numeric)Numeric.LongIsIntegral$.MODULE$);
        } else if (((Object)((Object)java.util.concurrent.TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            quantity = Seconds$.MODULE$.apply(BoxesRunTime.boxToLong((long)duration.length()), (Numeric)Numeric.LongIsIntegral$.MODULE$);
        } else if (((Object)((Object)java.util.concurrent.TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            quantity = Minutes$.MODULE$.apply(BoxesRunTime.boxToLong((long)duration.length()), (Numeric)Numeric.LongIsIntegral$.MODULE$);
        } else if (((Object)((Object)java.util.concurrent.TimeUnit.HOURS)).equals((Object)timeUnit)) {
            quantity = Hours$.MODULE$.apply(BoxesRunTime.boxToLong((long)duration.length()), (Numeric)Numeric.LongIsIntegral$.MODULE$);
        } else if (((Object)((Object)java.util.concurrent.TimeUnit.DAYS)).equals((Object)timeUnit)) {
            quantity = Days$.MODULE$.apply(BoxesRunTime.boxToLong((long)duration.length()), (Numeric)Numeric.LongIsIntegral$.MODULE$);
        } else {
            throw new MatchError((Object)timeUnit);
        }
        return quantity;
    }

    @Override
    public String name() {
        return "Time";
    }

    public Milliseconds$ primaryUnit() {
        return Milliseconds$.MODULE$;
    }

    @Override
    public Seconds$ siUnit() {
        return Seconds$.MODULE$;
    }

    @Override
    public Set<UnitOfMeasure<Time>> units() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnitOfMeasure[]{Nanoseconds$.MODULE$, Microseconds$.MODULE$, Milliseconds$.MODULE$, Seconds$.MODULE$, Minutes$.MODULE$, Hours$.MODULE$, Days$.MODULE$}));
    }

    @Override
    public String dimensionSymbol() {
        return "T";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Time$() {
        MODULE$ = this;
        Dimension.$init$(this);
        this.NanosecondsPerSecond = 1.0E9;
        this.MicrosecondsPerSecond = 1000000.0;
        this.MillisecondsPerNanosecond = 1.0E-6;
        this.MillisecondsPerMicrosecond = 0.001;
        this.MillisecondsPerSecond = 1000.0;
        this.MillisecondsPerMinute = this.MillisecondsPerSecond() * 60.0;
        this.MillisecondsPerHour = this.MillisecondsPerMinute() * 60.0;
        this.MillisecondsPerDay = this.MillisecondsPerHour() * 24.0;
        this.SecondsPerMinute = 60.0;
        this.SecondsPerHour = this.SecondsPerMinute() * 60.0;
        this.SecondsPerDay = this.SecondsPerHour() * (double)24;
        this.MinutesPerHour = 60.0;
        this.HoursPerDay = 24.0;
    }
}

