/*
 * Decompiled with CFR 0.152.
 */
package squants.time;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Dimensionless;
import squants.Each$;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.ElectricCharge;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.MagneticFlux;
import squants.energy.Energy;
import squants.energy.Power;
import squants.energy.PowerRamp;
import squants.information.DataRate;
import squants.information.Information;
import squants.mass.Mass;
import squants.motion.Acceleration;
import squants.motion.AngularVelocity;
import squants.motion.Force;
import squants.motion.Jerk;
import squants.motion.MassFlow;
import squants.motion.Momentum;
import squants.motion.Pressure;
import squants.motion.PressureChange;
import squants.motion.Velocity;
import squants.motion.VolumeFlow;
import squants.motion.Yank;
import squants.photo.Illuminance;
import squants.photo.LuminousEnergy;
import squants.photo.LuminousExposure;
import squants.photo.LuminousFlux;
import squants.space.Angle;
import squants.space.Length;
import squants.space.Volume;
import squants.time.Frequency$;
import squants.time.FrequencyUnit;
import squants.time.Gigahertz$;
import squants.time.Hertz$;
import squants.time.Kilohertz$;
import squants.time.Megahertz$;
import squants.time.RevolutionsPerMinute$;
import squants.time.Seconds$;
import squants.time.Terahertz$;
import squants.time.Time;
import squants.time.TimeDerivative;

@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u0001\u0003\u0005\u001d\u0011\u0011B\u0012:fcV,gnY=\u000b\u0005\r!\u0011\u0001\u0002;j[\u0016T\u0011!B\u0001\bgF,\u0018M\u001c;t\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\rI!\u0002D\u0007\u0002\t%\u00111\u0002\u0002\u0002\t#V\fg\u000e^5usB\u0011Q\u0002A\u0007\u0002\u0005A\u0019QbD\t\n\u0005A\u0011!A\u0004+j[\u0016$UM]5wCRLg/\u001a\t\u0003\u0013II!a\u0005\u0003\u0003\u001b\u0011KW.\u001a8tS>tG.Z:t\u0011!)\u0002A!b\u0001\n\u00031\u0012!\u0002<bYV,W#A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0011{WO\u00197f\u0011!q\u0002A!A!\u0002\u00139\u0012A\u0002<bYV,\u0007\u0005\u0003\u0005!\u0001\t\u0015\r\u0011\"\u0001\"\u0003\u0011)h.\u001b;\u0016\u0003\t\u0002\"!D\u0012\n\u0005\u0011\u0012!!\u0004$sKF,XM\\2z+:LG\u000f\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003#\u0003\u0015)h.\u001b;!\u0011\u0015A\u0003\u0001\"\u0003*\u0003\u0019a\u0014N\\5u}Q\u0019ABK\u0016\t\u000bU9\u0003\u0019A\f\t\u000b\u0001:\u0003\u0019\u0001\u0012\t\u000b5\u0002A\u0011\u0001\u0018\u0002\u0013\u0011LW.\u001a8tS>tW#A\u0018\u000f\u00055\u0001t!B\u0019\u0003\u0011\u0003\u0011\u0014!\u0003$sKF,XM\\2z!\ti1GB\u0003\u0002\u0005!\u0005Ag\u0005\u00034kaZ\u0004C\u0001\r7\u0013\t9\u0014D\u0001\u0004B]f\u0014VM\u001a\t\u0004\u0013eb\u0011B\u0001\u001e\u0005\u0005%!\u0015.\\3og&|g\u000e\u0005\u0002\u0019y%\u0011Q(\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006QM\"\ta\u0010\u000b\u0002e!1\u0011i\rC\u0001\u0005\t\u000bQ!\u00199qYf,\"aQ+\u0015\u0007\u0011s\u0006\r\u0006\u0002\r\u000b\")a\t\u0011a\u0002\u000f\u0006\u0019a.^7\u0011\u0007!\u00036K\u0004\u0002J\u001d:\u0011!*T\u0007\u0002\u0017*\u0011AJB\u0001\u0007yI|w\u000e\u001e \n\u0003iI!aT\r\u0002\u000fA\f7m[1hK&\u0011\u0011K\u0015\u0002\b\u001dVlWM]5d\u0015\ty\u0015\u0004\u0005\u0002U+2\u0001A!\u0002,A\u0005\u00049&!A!\u0012\u0005a[\u0006C\u0001\rZ\u0013\tQ\u0016DA\u0004O_RD\u0017N\\4\u0011\u0005aa\u0016BA/\u001a\u0005\r\te.\u001f\u0005\u0006?\u0002\u0003\raU\u0001\u0002]\")\u0001\u0005\u0011a\u0001E!)\u0011i\rC\u0001ER\u00111-\u001b\t\u0004I\u001edQ\"A3\u000b\u0005\u0019L\u0012\u0001B;uS2L!\u0001[3\u0003\u0007Q\u0013\u0018\u0010C\u0003\u0016C\u0002\u00071\fC\u0003lg\u0011\u0005A.\u0001\u0003oC6,W#A7\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018\u0001\u00027b]\u001eT\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\n11\u000b\u001e:j]\u001eDQA^\u001a\u0005\u0002]\f1\u0002\u001d:j[\u0006\u0014\u00180\u00168jiV\t\u0001P\u0004\u0002\u000es&\u0011!PA\u0001\u0006\u0011\u0016\u0014HO\u001f\u0005\u0006yN\"\ta^\u0001\u0007g&,f.\u001b;\t\u000by\u001cD\u0011A@\u0002\u000bUt\u0017\u000e^:\u0016\u0005\u0005\u0005\u0001CBA\u0002\u0003\u001b\t\t\"\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003%IW.\\;uC\ndWMC\u0002\u0002\fe\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty!!\u0002\u0003\u0007M+G\u000f\u0005\u0003\n\u0003'a\u0011bAA\u000b\t\tiQK\\5u\u001f\u001alU-Y:ve\u0016D\u0011\"!\u00074\u0003\u0003%I!a\u0007\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003;\u00012A\\A\u0010\u0013\r\t\tc\u001c\u0002\u0007\u001f\nTWm\u0019;\t\u0011\u0005\u0015\u0002\u0001\"\u0005\u0005\u0003O\ta\u0002^5nK&sG/Z4sCR,G-F\u0001\u0012\u0011\u001d\u0019\u0001\u0001\"\u0005\u0005\u0003W)\"!!\f\u0011\u00075\ty#C\u0002\u00022\t\u0011A\u0001V5nK\"9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0012A\u0002\u0013uS6,7\u000f\u0006\u0003\u0002:\u0005%\u0003\u0003BA\u001e\u0003\u0007rA!!\u0010\u0002B9\u0019!*a\u0010\n\u0003\u0015I!a\u0014\u0003\n\t\u0005\u0015\u0013q\t\u0002\u0005\u0015\u0016\u00148N\u0003\u0002P\t!A\u00111JA\u001a\u0001\u0004\ti%\u0001\u0003uQ\u0006$\b\u0003BA\u001e\u0003\u001fJA!!\u0015\u0002H\ta\u0011iY2fY\u0016\u0014\u0018\r^5p]\"9\u0011Q\u0007\u0001\u0005\u0002\u0005UC\u0003BA,\u0003G\u0002B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;\"\u0011AB7pi&|g.\u0003\u0003\u0002b\u0005m#aD!oOVd\u0017M\u001d,fY>\u001c\u0017\u000e^=\t\u0011\u0005-\u00131\u000ba\u0001\u0003K\u0002B!a\u000f\u0002h%!\u0011\u0011NA$\u0005\u0015\ten\u001a7f\u0011\u001d\t)\u0004\u0001C\u0001\u0003[\"2\u0001DA8\u0011\u001d\tY%a\u001bA\u0002EAq!!\u000e\u0001\t\u0003\t\u0019\b\u0006\u0003\u0002v\u0005m\u0004\u0003BA\u001e\u0003oJA!!\u001f\u0002H\tyQ\t\\3diJL7mQ;se\u0016tG\u000f\u0003\u0005\u0002L\u0005E\u0004\u0019AA?!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAAB\t\u00059Q\r\\3diJ|\u0017\u0002BAD\u0003\u0003\u0013a\"\u00127fGR\u0014\u0018nY\"iCJ<W\rC\u0004\u00026\u0001!\t!a#\u0015\t\u00055\u00151\u0013\t\u0005\u0003w\ty)\u0003\u0003\u0002\u0012\u0006\u001d#!\u0002)po\u0016\u0014\b\u0002CA&\u0003\u0013\u0003\r!!&\u0011\t\u0005m\u0012qS\u0005\u0005\u00033\u000b9E\u0001\u0004F]\u0016\u0014x-\u001f\u0005\b\u0003k\u0001A\u0011AAO)\u0011\ty*!*\u0011\t\u0005e\u0013\u0011U\u0005\u0005\u0003G\u000bYF\u0001\u0003ZC:\\\u0007\u0002CA&\u00037\u0003\r!a*\u0011\t\u0005m\u0012\u0011V\u0005\u0005\u0003W\u000b9EA\u0003G_J\u001cW\rC\u0004\u00026\u0001!\t!a,\u0015\t\u0005E\u0016Q\u0018\t\u0005\u0003g\u000bI,\u0004\u0002\u00026*\u0019\u0011q\u0017\u0003\u0002\u0017%tgm\u001c:nCRLwN\\\u0005\u0005\u0003w\u000b)L\u0001\u0005ECR\f'+\u0019;f\u0011!\tY%!,A\u0002\u0005}\u0006\u0003BAZ\u0003\u0003LA!a1\u00026\nY\u0011J\u001c4pe6\fG/[8o\u0011\u001d\t)\u0004\u0001C\u0001\u0003\u000f$B!!3\u0002PB!\u00111HAf\u0013\u0011\ti-a\u0012\u0003\u0011Y+Gn\\2jifD\u0001\"a\u0013\u0002F\u0002\u0007\u0011\u0011\u001b\t\u0005\u0003w\t\u0019.\u0003\u0003\u0002V\u0006\u001d#A\u0002'f]\u001e$\b\u000eC\u0004\u00026\u0001!\t!!7\u0015\t\u0005m\u0017q\u001d\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*\u0019\u0011\u0011\u001d\u0003\u0002\u000bADw\u000e^8\n\t\u0005\u0015\u0018q\u001c\u0002\r\u0019Vl\u0017N\\8vg\u001acW\u000f\u001f\u0005\t\u0003\u0017\n9\u000e1\u0001\u0002jB!\u0011Q\\Av\u0013\u0011\ti/a8\u0003\u001d1+X.\u001b8pkN,e.\u001a:hs\"9\u0011Q\u0007\u0001\u0005\u0002\u0005EH\u0003BAz\u0003s\u0004B!!8\u0002v&!\u0011q_Ap\u0005-IE\u000e\\;nS:\fgnY3\t\u0011\u0005-\u0013q\u001ea\u0001\u0003w\u0004B!!8\u0002~&!\u0011q`Ap\u0005AaU/\\5o_V\u001cX\t\u001f9pgV\u0014X\rC\u0004\u00026\u0001!\tAa\u0001\u0015\t\t\u0015!1\u0002\t\u0005\u0003\u007f\u00129!\u0003\u0003\u0003\n\u0005\u0005%!E#mK\u000e$(/[2Q_R,g\u000e^5bY\"A\u00111\nB\u0001\u0001\u0004\u0011i\u0001\u0005\u0003\u0002\u0000\t=\u0011\u0002\u0002B\t\u0003\u0003\u0013A\"T1h]\u0016$\u0018n\u0019$mkbDq!!\u000e\u0001\t\u0003\u0011)\u0002\u0006\u0003\u0003\u0018\tu\u0001\u0003BA\u001e\u00053IAAa\u0007\u0002H\tAQ*Y:t\r2|w\u000f\u0003\u0005\u0002L\tM\u0001\u0019\u0001B\u0010!\u0011\tYD!\t\n\t\t\r\u0012q\t\u0002\u0005\u001b\u0006\u001c8\u000fC\u0004\u00026\u0001!\tAa\n\u0015\t\u0005\u001d&\u0011\u0006\u0005\t\u0003\u0017\u0012)\u00031\u0001\u0003,A!\u00111\bB\u0017\u0013\u0011\u0011y#a\u0012\u0003\u00115{W.\u001a8uk6Dq!!\u000e\u0001\t\u0003\u0011\u0019\u0004\u0006\u0003\u00036\tm\u0002\u0003BA\u001e\u0005oIAA!\u000f\u0002H\tI\u0001k\\<feJ\u000bW\u000e\u001d\u0005\t\u0003\u0017\u0012\t\u00041\u0001\u0002\u000e\"9\u0011Q\u0007\u0001\u0005\u0002\t}B\u0003\u0002B!\u0005\u000f\u0002B!!\u0017\u0003D%!!QIA.\u00059\u0001&/Z:tkJ,7\t[1oO\u0016D\u0001\"a\u0013\u0003>\u0001\u0007!\u0011\n\t\u0005\u00033\u0012Y%\u0003\u0003\u0003N\u0005m#\u0001\u0003)sKN\u001cXO]3\t\u000f\u0005U\u0002\u0001\"\u0001\u0003RQ!\u0011Q\nB*\u0011!\tYEa\u0014A\u0002\u0005%\u0007bBA\u001b\u0001\u0011\u0005!q\u000b\u000b\u0005\u00053\u0012y\u0006\u0005\u0003\u0002<\tm\u0013\u0002\u0002B/\u0003\u000f\u0012!BV8mk6,g\t\\8x\u0011!\tYE!\u0016A\u0002\t\u0005\u0004\u0003BA\u001e\u0005GJAA!\u001a\u0002H\t1ak\u001c7v[\u0016DaA!\u001b\u0001\t\u00031\u0012a\u0002;p\u0011\u0016\u0014HO\u001f\u0005\u0007\u0005[\u0002A\u0011\u0001\f\u0002\u0017Q|7*\u001b7pQ\u0016\u0014HO\u001f\u0005\u0007\u0005c\u0002A\u0011\u0001\f\u0002\u0017Q|W*Z4bQ\u0016\u0014HO\u001f\u0005\u0007\u0005k\u0002A\u0011\u0001\f\u0002\u0017Q|w)[4bQ\u0016\u0014HO\u001f\u0005\u0007\u0005s\u0002A\u0011\u0001\f\u0002\u0017Q|G+\u001a:bQ\u0016\u0014HO\u001f\u0005\u0007\u0005{\u0002A\u0011\u0001\f\u0002-Q|'+\u001a<pYV$\u0018n\u001c8t!\u0016\u0014X*\u001b8vi\u0016\u0004")
public final class Frequency
extends Quantity<Frequency>
implements TimeDerivative<Dimensionless> {
    private final double value;
    private final FrequencyUnit unit;

    public static <N> Try<Frequency> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Frequency$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Frequency> parseString(String string) {
        return Frequency$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Frequency>> symbolToUnit(String string) {
        return Frequency$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Frequency$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Frequency$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<Frequency>> units() {
        return Frequency$.MODULE$.units();
    }

    public static Hertz$ siUnit() {
        return Frequency$.MODULE$.siUnit();
    }

    public static Hertz$ primaryUnit() {
        return Frequency$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Frequency$.MODULE$.name();
    }

    public static Try<Frequency> apply(Object object) {
        return Frequency$.MODULE$.apply(object);
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative.$times$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public FrequencyUnit unit() {
        return this.unit;
    }

    public Frequency$ dimension() {
        return Frequency$.MODULE$;
    }

    @Override
    public Dimensionless timeIntegrated() {
        return Each$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toHertz()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Jerk $times(Acceleration that) {
        return (Jerk)that.$times(this);
    }

    public AngularVelocity $times(Angle that) {
        return (AngularVelocity)that.$times(this);
    }

    public Frequency $times(Dimensionless that) {
        return (Frequency)this.$times(that.toEach());
    }

    public ElectricCurrent $times(ElectricCharge that) {
        return (ElectricCurrent)that.$times(this);
    }

    public Power $times(Energy that) {
        return (Power)that.$times(this);
    }

    public Yank $times(Force that) {
        return (Yank)that.$times(this);
    }

    public DataRate $times(Information that) {
        return (DataRate)that.$times(this);
    }

    public Velocity $times(Length that) {
        return (Velocity)that.$times(this);
    }

    public LuminousFlux $times(LuminousEnergy that) {
        return (LuminousFlux)that.$times(this);
    }

    public Illuminance $times(LuminousExposure that) {
        return (Illuminance)that.$times(this);
    }

    public ElectricPotential $times(MagneticFlux that) {
        return (ElectricPotential)that.$times(this);
    }

    public MassFlow $times(Mass that) {
        return (MassFlow)that.$times(this);
    }

    public Force $times(Momentum that) {
        return (Force)that.$times(this);
    }

    public PowerRamp $times(Power that) {
        return (PowerRamp)that.$times(this);
    }

    public PressureChange $times(Pressure that) {
        return (PressureChange)that.$times(this);
    }

    public Acceleration $times(Velocity that) {
        return (Acceleration)that.$times(this);
    }

    public VolumeFlow $times(Volume that) {
        return (VolumeFlow)that.$times(this);
    }

    public double toHertz() {
        return this.to(Hertz$.MODULE$);
    }

    public double toKilohertz() {
        return this.to(Kilohertz$.MODULE$);
    }

    public double toMegahertz() {
        return this.to(Megahertz$.MODULE$);
    }

    public double toGigahertz() {
        return this.to(Gigahertz$.MODULE$);
    }

    public double toTerahertz() {
        return this.to(Terahertz$.MODULE$);
    }

    public double toRevolutionsPerMinute() {
        return this.to(RevolutionsPerMinute$.MODULE$);
    }

    public Frequency(double value, FrequencyUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative.$init$(this);
    }
}

